/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.internal;

import com.yakindu.licmgmt.internal.utils.PathUtils;
import java.io.File;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class LoggingHelper {
    private static final int LOG_FILE_LIMIT = 0x200000;
    private static final int LOG_FILE_COUNT = 10;
    private static final String LOG_FORMAT = "%1$tF %1$tT [%4$11s] %5$s%n";
    private static final Level LOGFILE_LOGLEVEL = Level.FINEST;
    private static final Level CONSOLE_LOGLEVEL = Level.WARNING;
    private static final String USER_HOME = PathUtils.getUserHomePath();
    private static final String USER_HOME_PLACEHOLDER = "<USER-HOME-FOLDER>";
    private static Logger logger;

    private static void init(Logger logger) {
        try {
            LoggingHelper.doInit(logger);
        }
        catch (IOException e) {
            new Exception("Failed to initialize logger", e).printStackTrace();
        }
    }

    private static void doInit(Logger logger) throws IOException {
        File logFile = LoggingHelper.getLogPath();
        File logDirectory = logFile.getParentFile();
        if (!logDirectory.isDirectory() && !logDirectory.mkdirs()) {
            throw new IOException("Can't create directory '" + logDirectory.getAbsolutePath() + "'.");
        }
        FileHandler handler = new FileHandler(logFile.getAbsolutePath(), 0x200000, 10, true);
        handler.setFormatter(new SimpleFormatter());
        handler.setLevel(LOGFILE_LOGLEVEL);
        logger.addHandler(handler);
        logger.setLevel(LOGFILE_LOGLEVEL);
        Logger rootLogger = logger.getParent();
        if (rootLogger != null) {
            Handler[] handlerArray = rootLogger.getHandlers();
            int n = handlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Handler rootHandler = handlerArray[n2];
                if (rootHandler instanceof ConsoleHandler) {
                    rootHandler.setLevel(CONSOLE_LOGLEVEL);
                }
                ++n2;
            }
        }
    }

    private static Logger getLogger() {
        if (logger == null) {
            System.setProperty("java.util.logging.SimpleFormatter.format", LOG_FORMAT);
            logger = Logger.getLogger("itemis License Management Log");
            LoggingHelper.init(logger);
        }
        return logger;
    }

    private static File getLogPath() {
        return new File(USER_HOME, "yakindu_license.log");
    }

    public static void error(String msg, Throwable throwable, Object ... args) {
        if (LoggingHelper.getLogger().isLoggable(Level.SEVERE)) {
            LoggingHelper.getLogger().log(Level.SEVERE, LoggingHelper.formatStringIfNeccessary(msg, args), throwable);
        }
    }

    public static void error(String msg, Object ... args) {
        if (LoggingHelper.getLogger().isLoggable(Level.SEVERE)) {
            LoggingHelper.getLogger().log(Level.SEVERE, LoggingHelper.formatStringIfNeccessary(msg, args));
        }
    }

    public static void warn(String msg, Throwable throwable, Object ... args) {
        if (LoggingHelper.getLogger().isLoggable(Level.WARNING)) {
            LoggingHelper.getLogger().log(Level.WARNING, LoggingHelper.formatStringIfNeccessary(msg, args), throwable);
        }
    }

    public static void warn(String msg, Object ... args) {
        if (LoggingHelper.getLogger().isLoggable(Level.WARNING)) {
            LoggingHelper.getLogger().log(Level.WARNING, LoggingHelper.formatStringIfNeccessary(msg, args));
        }
    }

    public static void info(String msg, Object ... args) {
        if (LoggingHelper.getLogger().isLoggable(Level.INFO)) {
            LoggingHelper.getLogger().log(Level.INFO, LoggingHelper.formatStringIfNeccessary(msg, args));
        }
    }

    public static void debug(String msg, Object ... args) {
        if (LoggingHelper.getLogger().isLoggable(Level.FINE)) {
            LoggingHelper.getLogger().log(Level.FINE, LoggingHelper.formatStringIfNeccessary(msg, args));
        }
    }

    public static void trace(String msg, Object ... args) {
        if (LoggingHelper.getLogger().isLoggable(Level.FINER)) {
            LoggingHelper.getLogger().log(Level.FINER, LoggingHelper.formatStringIfNeccessary(msg, args));
        }
    }

    private static String formatStringIfNeccessary(String msg, Object ... objects) {
        if (msg == null || msg.isBlank()) {
            return msg;
        }
        String msgWithoutUserHome = USER_HOME == null || USER_HOME.isEmpty() ? msg : msg.replace(USER_HOME, USER_HOME_PLACEHOLDER);
        String msgWithoutXformationInfo = msgWithoutUserHome.replace("For further information go to http://www.x-formation.com", "").trim();
        if (objects != null && objects.length > 0) {
            return String.format(msgWithoutXformationInfo, objects);
        }
        return msgWithoutXformationInfo;
    }
}

