/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.linking;

import com.google.inject.Inject;
import com.yakindu.base.expressions.expressions.ArgumentExpression;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Parameter;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypeParameter;
import com.yakindu.base.types.TypesPackage;
import com.yakindu.base.types.inferrer.ITypeSystemInferrer;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.base.types.util.ArgumentSorter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.resource.IEObjectDescription;

public class OperationOverloadingResolver {
    @Inject
    protected ITypeSystemInferrer inferrer;
    @Inject
    protected ITypeSystem typeSystem;

    public Optional<Operation> linkOperation(List<IEObjectDescription> candidates, ArgumentExpression call) {
        if (candidates.size() == 1 && candidates.get(0).getEClass().isSuperTypeOf(TypesPackage.Literals.OPERATION)) {
            return Optional.of((Operation)candidates.get(0).getEObjectOrProxy());
        }
        List operations = candidates.stream().map(it -> (Operation)it.getEObjectOrProxy()).collect(Collectors.toList());
        Collections.sort(operations, new PolymorphicComparator());
        for (Operation operation : operations) {
            if (!this.isCallable(operation, call)) continue;
            return Optional.of(operation);
        }
        return Optional.empty();
    }

    protected boolean isCallable(Operation operation, ArgumentExpression expression) {
        EList orderedExpressions = ArgumentSorter.getOrderedExpressions(expression.getArguments(), (Operation)operation);
        List argumentTypes = orderedExpressions.stream().map(it -> this.inferrer.infer((EObject)it)).filter(t -> t != null).map(t -> t.getType()).filter(t -> t != null).collect(Collectors.toList());
        List parameterTypes = operation.getParameters().stream().map(it -> it.getType()).collect(Collectors.toList());
        if (argumentTypes.size() != parameterTypes.size()) {
            return false;
        }
        int i = 0;
        while (i < argumentTypes.size()) {
            Type type2;
            Type type1 = (Type)argumentTypes.get(i);
            if (!(this.typeSystem.isConvertableTo(type1, type2 = (Type)parameterTypes.get(i)) || this.typeSystem.isSuperType(type1, type2) || type2 instanceof TypeParameter && (((TypeParameter)type2).getBound() == null || this.typeSystem.isSuperType(type1, ((TypeParameter)type2).getBound())))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected class PolymorphicComparator
    implements Comparator<Operation> {
        protected PolymorphicComparator() {
        }

        @Override
        public int compare(Operation operation1, Operation operation2) {
            EList parameters1 = operation1.getParameters();
            EList parameters2 = operation2.getParameters();
            if (parameters1.size() > parameters2.size()) {
                return -1;
            }
            if (parameters1.size() < parameters2.size()) {
                return 1;
            }
            int i = 0;
            while (i < parameters1.size()) {
                Type type2;
                Type type1 = ((Parameter)parameters1.get(i)).getType();
                if (!OperationOverloadingResolver.this.typeSystem.isSame(type1, type2 = ((Parameter)parameters2.get(i)).getType())) {
                    if (OperationOverloadingResolver.this.typeSystem.isSuperType(type1, type2)) {
                        return -1;
                    }
                    if (OperationOverloadingResolver.this.typeSystem.isSuperType(type2, type1)) {
                        return 1;
                    }
                }
                ++i;
            }
            return 0;
        }
    }
}

