/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.terminals;

import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractLexerBasedConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

public class FloatValueConverter
extends AbstractLexerBasedConverter<Float> {
    protected static final String FLOAT_SUFFIX = "f";

    public Float toValue(String string, INode node) throws ValueConverterException {
        if (Strings.isEmpty((String)string)) {
            throw new ValueConverterException("Couldn't convert empty string to float.", node, null);
        }
        try {
            if (string.endsWith(FLOAT_SUFFIX)) {
                return Float.valueOf(Float.parseFloat(string.substring(0, string.length() - 1)));
            }
            return Float.valueOf(Float.parseFloat(string));
        }
        catch (NumberFormatException e) {
            throw new ValueConverterException("Couldn't convert '" + string + "' to float.", node, null);
        }
    }

    protected String toEscapedString(Float value) {
        return super.toEscapedString((Object)value) + FLOAT_SUFFIX;
    }
}

