/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.refactoring.refactor.impl;

import com.google.common.collect.Lists;
import com.yakindu.sct.model.sgraph.Region;
import com.yakindu.sct.model.sgraph.SGraphFactory;
import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.model.sgraph.Vertex;
import com.yakindu.sct.refactoring.refactor.AbstractRefactoring;
import com.yakindu.sct.ui.editor.DiagramActivator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;

public class GroupStatesIntoCompositeRefactoring
extends AbstractRefactoring<GraphicalEditPart> {
    private View parentRegionView;
    private PreferencesHint preferencesHint = DiagramActivator.DIAGRAM_PREFERENCES_HINT;
    private final int PADDING = 55;
    private State compositeState;
    private Region innerRegion;
    protected List<State> contextStates;

    @Override
    protected void internalExecute() {
        this.doSemanticalRefactoring();
        this.doGraphicalRefactoring();
    }

    @Override
    public boolean isExecutable() {
        return super.isExecutable() && this.allStatesHaveSameParentRegion();
    }

    protected void doSemanticalRefactoring() {
        this.compositeState = this.createCompositeState();
        this.innerRegion = SGraphFactory.eINSTANCE.createRegion();
        this.innerRegion.setName("inner region");
        this.compositeState.getRegions().add((Object)this.innerRegion);
        for (State state : this.contextStates) {
            this.innerRegion.getVertices().add((Object)state);
        }
    }

    protected void doGraphicalRefactoring() {
        Node compositeStateView = this.createNodeForCompositeState(this.compositeState);
        Node innerRegionNode = ViewService.createNode((View)this.getStateFigureCompartmentView(compositeStateView), (EObject)this.innerRegion, (String)"Region", (PreferencesHint)this.preferencesHint);
        View regionCompartment = ViewUtil.getChildBySemanticHint((View)innerRegionNode, (String)"RegionCompartment");
        this.moveSelectedStateNodesTo(regionCompartment, (Bounds)compositeStateView.getLayoutConstraint());
    }

    protected State createCompositeState() {
        State compositeState = SGraphFactory.eINSTANCE.createState();
        compositeState.setName(this.getNameForCompositeState());
        this.getParentRegion().getVertices().add((Object)compositeState);
        return compositeState;
    }

    protected Node createNodeForCompositeState(State compositeState) {
        Node compositeStateNode = ViewService.createNode((View)this.parentRegionView, (EObject)compositeState, (String)"State", (PreferencesHint)this.preferencesHint);
        this.setCompositeStateLayoutConstraint(compositeStateNode);
        return compositeStateNode;
    }

    protected void setContextStates() {
        this.contextStates = Lists.newArrayList();
        List contextObjects = this.getContextObjects();
        for (GraphicalEditPart editPart : contextObjects) {
            EObject element = editPart.resolveSemanticElement();
            this.contextStates.add((State)element);
        }
    }

    @Override
    public void setContextObjects(List<GraphicalEditPart> contextObject) {
        super.setContextObjects(contextObject);
        this.setContextStates();
    }

    protected void moveSelectedStateNodesTo(View containerView, Bounds compositeBounds) {
        for (GraphicalEditPart editPart : this.getContextObjects()) {
            Node stateNode = (Node)editPart.getNotationView();
            ViewUtil.insertChildView((View)containerView, (View)stateNode, (int)-1, (boolean)true);
            Bounds newBounds = NotationFactory.eINSTANCE.createBounds();
            Bounds oldBounds = (Bounds)stateNode.getLayoutConstraint();
            newBounds.setX(oldBounds.getX() - compositeBounds.getX() - 7);
            newBounds.setY(oldBounds.getY() - compositeBounds.getY() - 34);
            ((Node)editPart.getNotationView()).setLayoutConstraint((LayoutConstraint)newBounds);
        }
    }

    protected void setCompositeStateLayoutConstraint(Node compositeStateNode) {
        Rectangle newbounds = null;
        for (GraphicalEditPart editPart : this.getContextObjects()) {
            Rectangle childBounds = editPart.getFigure().getBounds();
            if (newbounds == null) {
                newbounds = childBounds.getCopy();
            }
            newbounds.union(childBounds);
        }
        newbounds.expand(new Insets(55, 55, 55, 55));
        Bounds bounds = NotationFactory.eINSTANCE.createBounds();
        bounds.setX(newbounds.x);
        bounds.setY(newbounds.y);
        bounds.setWidth(newbounds.width);
        bounds.setHeight(newbounds.height);
        compositeStateNode.setLayoutConstraint((LayoutConstraint)bounds);
    }

    protected View getStateFigureCompartmentView(Node compositeStateView) {
        return ViewUtil.getChildBySemanticHint((View)compositeStateView, (String)"StateFigureCompartment");
    }

    protected String getNameForCompositeState() {
        StringBuilder nameBuilder = new StringBuilder("Composite");
        for (State state : this.contextStates) {
            nameBuilder.append("_");
            nameBuilder.append(state.getName());
        }
        this.makeNameUnique(nameBuilder);
        return nameBuilder.toString();
    }

    protected void makeNameUnique(StringBuilder nameBuilder) {
        int index = 2;
        ArrayList existingStateNames = Lists.newArrayList();
        EList vertices = this.getParentRegion().getVertices();
        for (Vertex vertex : vertices) {
            existingStateNames.add(vertex.getName());
        }
        while (existingStateNames.contains(nameBuilder.toString())) {
            nameBuilder.append(index++);
        }
    }

    protected Region getParentRegion() {
        return this.contextStates.get(0).getParentRegion();
    }

    protected boolean allStatesHaveSameParentRegion() {
        this.parentRegionView = null;
        for (IGraphicalEditPart editPart : this.getContextObjects()) {
            if (this.parentRegionView == null) {
                this.parentRegionView = (Node)((Node)editPart.getNotationView()).eContainer();
                continue;
            }
            Node nextParentRegion = (Node)((Node)editPart.getNotationView()).eContainer();
            if (nextParentRegion.equals(this.parentRegionView)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String getCommandLabel() {
        return "Group states into composite state";
    }

    @Override
    protected Resource getResource() {
        return ((GraphicalEditPart)this.getContextObject()).resolveSemanticElement().eResource();
    }

    @Override
    protected void executeCommand(AbstractTransactionalCommand refactoringCommand) {
        GroupStatesIntoCompositeRefactoring.executeCommand((IUndoableOperation)refactoringCommand, this.getResource(), false);
    }
}

