/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.coverage.ui.view;

import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.yakindu.base.gmf.runtime.highlighting.IHighlightingSupport;
import com.yakindu.base.gmf.runtime.util.EditPartUtils;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.Reaction;
import com.yakindu.base.types.TypedDeclaration;
import com.yakindu.sct.model.sgraph.Pseudostate;
import com.yakindu.sct.model.sgraph.RegularState;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.util.SubchartDFS;
import com.yakindu.sct.simulation.core.coverage.Measurement;
import com.yakindu.sct.simulation.core.coverage.MeasurementContext;
import com.yakindu.sct.simulation.core.coverage.MeasurementExtension;
import com.yakindu.sct.simulation.ui.coverage.CoverageColors;
import com.yakindu.sct.simulation.ui.coverage.CoverageITreeContentProvider;
import com.yakindu.sct.simulation.ui.coverage.CoverageImageRenderer;
import com.yakindu.sct.simulation.ui.view.AbstractDebugTargetView;
import com.yakindu.sct.simulation.ui.view.actions.CollapseAllAction;
import com.yakindu.sct.simulation.ui.view.actions.ExpandAllAction;
import com.yakindu.sct.ui.editor.partitioning.DiagramPartitioningUtil;
import com.yakindu.sctunit.coverage.persistence.CoverageStore;
import com.yakindu.sctunit.coverage.report.CoverageReportStore;
import com.yakindu.sctunit.coverage.ui.CoverageActivator;
import com.yakindu.sctunit.coverage.ui.CoverageImages;
import com.yakindu.sctunit.coverage.ui.view.CoveragePartListener;
import com.yakindu.sctunit.coverage.ui.view.SCTUnitCoverageAdapterFactoryLabelProvider;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.SCTUnitElement;
import com.yakindu.sctunit.sCTUnit.SCTUnitSuite;
import com.yakindu.sctunit.simulation.core.debugmodel.SCTUnitDebugTarget;
import com.yakindu.sctunit.simulation.core.launch.ISCTUnitLaunchParameters;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToImageUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.PlatformUI;
import org.yakindu.sct.ui.editor.editor.StatechartDiagramEditor;

public class SCTUnitCoverageResultView
extends AbstractDebugTargetView
implements ISelectionChangedListener,
IPropertyChangeListener,
ISCTUnitLaunchParameters {
    protected Measurement measurement;
    protected MeasurementContext context;
    protected MeasurementExtension mExtension;
    protected Consumer<Measurement> measurementConsumer = this::handleMeasurementUpdate;
    protected IDebugTarget target;
    protected TreeViewer treeViewer;
    protected IHighlightingSupport highlightingSupport;
    protected IPartListener listener;
    protected boolean isDisposed = false;
    private CoveragePartListener coveragePartListener;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.createCoverageViewer(parent);
        this.hookActions();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener((IPartListener)this.coveragePartListener);
        this.isDisposed = false;
    }

    protected void hookActions() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IContributionItem)new Separator());
        CollapseAllAction collapse = new CollapseAllAction(this.treeViewer);
        mgr.add((IAction)collapse);
        ExpandAllAction expand = new ExpandAllAction(this.treeViewer);
        mgr.add((IAction)expand);
        ShowUncoveredOnlyAction toggle = new ShowUncoveredOnlyAction(true);
        mgr.add((IAction)toggle);
        ClearViewAction clear = new ClearViewAction();
        mgr.add((IAction)clear);
        ExportReportAction export = new ExportReportAction();
        mgr.add((IAction)export);
        this.getViewSite().getActionBars().getToolBarManager().update(true);
    }

    protected void createCoverageViewer(Composite parent) {
        this.treeViewer = new TreeViewer(parent);
        this.coveragePartListener = new CoveragePartListener(this::onInputChanged);
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        final SCTUnitCoverageAdapterFactoryLabelProvider labelProvider = new SCTUnitCoverageAdapterFactoryLabelProvider((AdapterFactory)composedAdapterFactory);
        this.treeViewer.setContentProvider((IContentProvider)new CoverageITreeContentProvider());
        this.treeViewer.addFilter((ViewerFilter)new CoverageViewerFilter());
        this.treeViewer.getTree().setHeaderVisible(true);
        this.treeViewer.getTree().setLinesVisible(true);
        TreeViewerColumn elementColumn = new TreeViewerColumn(this.treeViewer, 0);
        StyledCellLabelProvider cellLabelProvider = new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(labelProvider.getText(cell.getElement()));
                cell.setImage(labelProvider.getImage(cell.getElement()));
            }
        };
        elementColumn.setLabelProvider((CellLabelProvider)cellLabelProvider);
        TreeColumn column = elementColumn.getColumn();
        column.setText("Model Element");
        column.setWidth(300);
        TreeViewerColumn coverageColumn = new TreeViewerColumn(this.treeViewer, 0);
        coverageColumn.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                Measurement measurement = (Measurement)cell.getElement();
                MeasurementExtension extension = new MeasurementExtension();
                Measurement.StateTransitionCoverage coverage = extension.coverage(measurement);
                cell.setText((int)(coverage.coverage * 100.0f) + " % (" + coverage.weight + ")");
                cell.setImage(CoverageImageRenderer.render((float)coverage.coverage));
            }
        });
        column = coverageColumn.getColumn();
        column.setText("Coverage");
        column.setWidth(100);
        column.setResizable(false);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected void activeTargetChanged(IDebugTarget target) {
        MeasurementContext context = this.getMeasurementFromTarget(target);
        if (this.context == context) {
            return;
        }
        if (this.context != null) {
            this.context.removeListener(this.measurementConsumer);
        }
        this.context = context;
        if (this.context != null) {
            this.context.addListener(this.measurementConsumer);
        }
    }

    public void handleMeasurementUpdate(Measurement m) {
        this.onInputChanged(m);
    }

    protected MeasurementContext getMeasurementFromTarget(IDebugTarget target) {
        if (target instanceof SCTUnitDebugTarget) {
            return ((SCTUnitDebugTarget)target).getMeasurementContext();
        }
        return null;
    }

    protected void trigger(Runnable r) {
        Display.getDefault().asyncExec(r);
    }

    public Object unwrap(ISelection selection) {
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        return structuredSelection.getFirstElement();
    }

    protected void onInputChanged(Measurement m) {
        if (this.measurement == m) {
            this.trigger(() -> ((TreeViewer)this.treeViewer).refresh());
            return;
        }
        this.measurement = m;
        MeasurementExtension measurementExtension = this.mExtension = m != null ? new MeasurementExtension() : null;
        if (m == null) {
            this.trigger(() -> {
                if (this.treeViewer != null) {
                    this.treeViewer.setInput(null);
                }
            });
            return;
        }
        this.trigger(() -> {
            Measurement[] measurements = new Measurement[]{m};
            if (!this.isDisposed && this.treeViewer != null) {
                this.treeViewer.setInput((Object)measurements);
                if (measurements.length == 1) {
                    this.treeViewer.expandAll();
                } else {
                    this.treeViewer.expandToLevel(1);
                }
            }
        });
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Measurement measurement = (Measurement)this.unwrap(event.getSelection());
        if (measurement == null) {
            return;
        }
        EObject semanticElement = measurement.getSubject();
        if (semanticElement == null) {
            semanticElement = measurement.getParent().getSubject();
        }
        if (semanticElement instanceof SCTUnitClass) {
            semanticElement = ((SCTUnitClass)semanticElement).getStatechart();
        } else if (semanticElement instanceof Property) {
            semanticElement = SubchartDFS.getStatechart((Property)((Property)semanticElement));
        }
        Diagram diagram = DiagramPartitioningUtil.getDiagramContaining((EObject)semanticElement);
        if (diagram == null) {
            return;
        }
        Diagram sharedDiagram = (Diagram)DiagramPartitioningUtil.getSharedDomain().getResourceSet().getEObject(EcoreUtil.getURI((EObject)diagram), true);
        StatechartDiagramEditor editor = (StatechartDiagramEditor)DiagramPartitioningUtil.openEditor((Diagram)sharedDiagram);
        Measurement statechartMeasurement = this.mExtension.forSubject(measurement, (Object)semanticElement);
        if (statechartMeasurement == null || !(statechartMeasurement.getSubject() instanceof Statechart)) {
            statechartMeasurement = this.mExtension.findParent(measurement, m -> m.getSubject() instanceof Statechart);
        }
        this.highlightCoverage(diagram, (IEditorPart)editor, statechartMeasurement);
        this.selectAndReveal(semanticElement, editor);
    }

    protected void selectAndReveal(EObject semanticElement, StatechartDiagramEditor editor) {
        IGraphicalEditPart editPart = EditPartUtils.findEditPartForSemanticElement((EditPart)editor.getDiagramGraphicalViewer().getRootEditPart(), (EObject)semanticElement);
        if (editPart != null) {
            editor.getDiagramGraphicalViewer().select((EditPart)editPart);
            editor.getDiagramGraphicalViewer().reveal((EditPart)editPart);
        }
    }

    protected void highlightCoverage(Diagram diagram, IEditorPart editor, Measurement measurement) {
        ArrayList fullCovered = Lists.newArrayList();
        ArrayList partlyCovered = Lists.newArrayList();
        ArrayList notCovered = Lists.newArrayList();
        TreeIterator eAllContents = diagram.getElement().eAllContents();
        while (eAllContents.hasNext()) {
            float coverage;
            EObject eObject = (EObject)eAllContents.next();
            if (!this.considered(eObject)) continue;
            Measurement.StateTransitionCoverage stc = this.mExtension.coverage(this.mExtension.forSubject(measurement, (Object)eObject));
            float f = coverage = stc == null ? 0.0f : stc.coverage;
            if (coverage == 1.0f) {
                fullCovered.add(eObject);
                continue;
            }
            if (coverage == 0.0f) {
                notCovered.add(eObject);
                continue;
            }
            partlyCovered.add(eObject);
        }
        this.highlightingSupport = (IHighlightingSupport)editor.getAdapter(IHighlightingSupport.class);
        if (this.highlightingSupport.isLocked()) {
            this.highlightingSupport.releaseAndLockEditor();
        } else {
            this.highlightingSupport.lockEditor();
        }
        Display.getDefault().asyncExec(() -> {
            this.highlightingSupport.highlight(fullCovered, CoverageColors.FULL_COVERED);
            this.highlightingSupport.highlight(partlyCovered, CoverageColors.PARTLY_COVERED);
            this.highlightingSupport.highlight(notCovered, CoverageColors.NOT_COVERED);
        });
    }

    protected boolean considered(EObject eObject) {
        return eObject instanceof Reaction || eObject instanceof Pseudostate || eObject instanceof RegularState;
    }

    protected List<SCTUnitClass> collectTests(EObject context) {
        ArrayList result = Lists.newArrayList();
        if (context instanceof SCTUnitClass) {
            result.add((SCTUnitClass)context);
        } else if (context instanceof SCTUnitSuite) {
            EList allFeatures = ((SCTUnitSuite)context).getAllFeatures();
            for (Declaration declaration : allFeatures) {
                if (!(declaration instanceof TypedDeclaration)) continue;
                SCTUnitClass clazz = (SCTUnitClass)((TypedDeclaration)declaration).getType();
                result.add(clazz);
            }
        }
        return result;
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    protected String getTestClassName(Measurement m) {
        if (m.getSubject() instanceof SCTUnitSuite || m.getSubject() instanceof SCTUnitClass) {
            return ((SCTUnitElement)m.getSubject()).getName();
        }
        return this.getTestClassName(m.getParent());
    }

    protected void handleDebugEvent(DebugEvent event) {
    }

    public void setFocus() {
    }

    public class ClearViewAction
    extends Action {
        public ClearViewAction() {
            super("Clear Editor and View");
            this.setToolTipText("Removed highlighting from the editor and clears the view");
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_REMOVEALL"));
        }

        public void run() {
            SCTUnitCoverageResultView.this.treeViewer.setInput(null);
            if (SCTUnitCoverageResultView.this.highlightingSupport != null && SCTUnitCoverageResultView.this.highlightingSupport.isLocked()) {
                SCTUnitCoverageResultView.this.highlightingSupport.releaseEditor();
            }
        }
    }

    public class CoverageViewerFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (CoverageActivator.getDefault().getPreferenceStore().getBoolean("ShowColors")) {
                return true;
            }
            return SCTUnitCoverageResultView.this.mExtension.coverage((Measurement)((Measurement)element)).coverage != 1.0f;
        }
    }

    public class ExportReportAction
    extends Action {
        public ExportReportAction() {
            super("Export Coverage Report");
            this.setToolTipText("Export Coverage Report");
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_SAVEAS_EDIT"));
        }

        public void run() {
            CoverageStore store = new CoverageStore();
            String reportFileName = store.getCoverageFileName(SCTUnitCoverageResultView.this.measurement) + ".zip";
            FileDialog dialog = new FileDialog(SCTUnitCoverageResultView.this.getViewSite().getShell(), 8192);
            dialog.setFilterExtensions(new String[]{"*.zip"});
            dialog.setFileName(reportFileName);
            String absolutePath = dialog.open();
            if (absolutePath != null && !absolutePath.isBlank()) {
                Path path = Paths.get(absolutePath, new String[0]);
                CopyToImageUtil imageUtil = (CopyToImageUtil)Guice.createInjector((Module[])new Module[0]).getInstance(CopyToImageUtil.class);
                CoverageReportStore save = new CoverageReportStore(SCTUnitCoverageResultView.this.measurement, imageUtil);
                save.saveReportFolder(path, dialog.getFileName());
            }
        }
    }

    public class ShowUncoveredOnlyAction
    extends Action {
        public static final String SHOW_COVERED = "ShowColors";

        public ShowUncoveredOnlyAction(boolean show) {
            super("Show / Hide Covered Elements");
            this.getStore().setValue(SHOW_COVERED, show);
            this.setToolTipText("Show / Hide Covered Elements");
            this.setImageDescriptor(CoverageImages.TOGGLE_ERRORS.imageDescriptor());
            this.setChecked(!this.getStore().getBoolean(SHOW_COVERED));
        }

        public void run() {
            this.getStore().setValue(SHOW_COVERED, !this.getStore().getBoolean(SHOW_COVERED));
            SCTUnitCoverageResultView.this.treeViewer.refresh();
        }

        private IPreferenceStore getStore() {
            return CoverageActivator.getDefault().getPreferenceStore();
        }
    }
}

