/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.partitioning;

import com.yakindu.sct.model.sgraph.CompositeElement;
import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.ui.editor.partitioning.DiagramEditorInput;
import com.yakindu.sct.ui.editor.partitioning.SubmachineEditorInput;
import com.yakindu.sct.ui.editor.utils.GMFNotationUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditorInput;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.notation.BooleanValueStyle;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class DiagramPartitioningUtil {
    public static final String INLINE_STYLE = "isInline";
    public static final String INLINE_DEFINITION_SECTION_STYLE = "inlineDefinitionSection";
    private static final String DOMAIN_ID = "com.yakindu.sct.domain";

    private DiagramPartitioningUtil() {
    }

    public static BooleanValueStyle getInlineStyle(View view) {
        BooleanValueStyle result = GMFNotationUtil.getBooleanValueStyle(view, INLINE_STYLE);
        return result;
    }

    public static BooleanValueStyle getInlineDefinitionSectionStyle(View view) {
        BooleanValueStyle result = GMFNotationUtil.getBooleanValueStyle(view, INLINE_DEFINITION_SECTION_STYLE);
        return result;
    }

    public static BooleanValueStyle createInlineStyle() {
        BooleanValueStyle result = NotationFactory.eINSTANCE.createBooleanValueStyle();
        result.setName(INLINE_STYLE);
        result.setBooleanValue(true);
        return result;
    }

    public static BooleanValueStyle createInlineDefinitionSectionStyle() {
        BooleanValueStyle result = NotationFactory.eINSTANCE.createBooleanValueStyle();
        result.setName(INLINE_DEFINITION_SECTION_STYLE);
        result.setBooleanValue(false);
        return result;
    }

    public static synchronized TransactionalEditingDomain getSharedDomain() {
        return TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(DOMAIN_ID);
    }

    public static Diagram getDiagramContaining(EObject element) {
        Assert.isNotNull((Object)element);
        Resource eResource = element.eResource();
        if (eResource == null) {
            return null;
        }
        Collection objects = EcoreUtil.getObjectsByType((Collection)eResource.getContents(), (EClassifier)NotationPackage.Literals.DIAGRAM);
        for (Diagram diagram : objects) {
            TreeIterator eAllContents = diagram.eAllContents();
            while (eAllContents.hasNext()) {
                EObject next = (EObject)eAllContents.next();
                if (!(next instanceof View) || !EcoreUtil.equals((EObject)((View)next).getElement(), (EObject)element)) continue;
                return ((View)next).getDiagram();
            }
        }
        return null;
    }

    public static Diagram getSubDiagram(CompositeElement element) {
        Assert.isNotNull((Object)element);
        Resource eResource = element.eResource();
        Collection objects = EcoreUtil.getObjectsByType((Collection)eResource.getContents(), (EClassifier)NotationPackage.Literals.DIAGRAM);
        for (Diagram diagram : objects) {
            if (!EcoreUtil.equals((EObject)diagram.getElement(), (EObject)element)) continue;
            return diagram;
        }
        return null;
    }

    public static IEditorPart openEditor(IFile file) {
        try {
            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
            IWorkbenchPage wbPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            return wbPage.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IEditorPart openEditor(Diagram diagramToOpen) {
        IFile file = WorkspaceSynchronizer.getFile((Resource)diagramToOpen.eResource());
        try {
            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
            IWorkbenchPage wbPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (diagramToOpen.getElement() instanceof Statechart) {
                return wbPage.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
            }
            if (diagramToOpen.getElement() instanceof State) {
                return wbPage.openEditor((IEditorInput)new DiagramEditorInput(diagramToOpen), desc.getId());
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static IEditorPart openSubmachineEditor(Diagram diagram, String context) {
        try {
            IFile file = WorkspaceSynchronizer.getFile((Resource)diagram.eResource());
            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
            IWorkbenchPage wbPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            return wbPage.openEditor((IEditorInput)new SubmachineEditorInput(diagram, context), desc.getId());
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static View findNotationView(EObject semanticElement) {
        Collection objects = EcoreUtil.getObjectsByType((Collection)semanticElement.eResource().getContents(), (EClassifier)NotationPackage.Literals.DIAGRAM);
        for (Diagram diagram : objects) {
            TreeIterator eAllContents = diagram.eAllContents();
            while (eAllContents.hasNext()) {
                EObject next = (EObject)eAllContents.next();
                if (!(next instanceof View) || ((View)next).getElement() != semanticElement) continue;
                return (View)next;
            }
        }
        return null;
    }

    public static void selectElementsInDiagram(IDiagramWorkbenchPart diagramPart, List<EditPart> editParts) {
        diagramPart.getDiagramGraphicalViewer().deselectAll();
        EditPart firstPrimary = null;
        for (EditPart nextPart : editParts) {
            if (nextPart.isSelectable()) {
                diagramPart.getDiagramGraphicalViewer().appendSelection(nextPart);
            }
            if (firstPrimary != null || !(nextPart instanceof IPrimaryEditPart)) continue;
            firstPrimary = nextPart;
        }
        if (!editParts.isEmpty()) {
            diagramPart.getDiagramGraphicalViewer().reveal(firstPrimary != null ? firstPrimary : editParts.get(0));
        }
    }

    public static boolean closeSubdiagramEditors(State state) {
        IEditorReference[] refs;
        Diagram diagram = DiagramPartitioningUtil.getSubDiagram((CompositeElement)state);
        if (diagram == null) {
            return true;
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = refs = activePage.getEditorReferences();
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            try {
                IDiagramEditorInput diagramInput;
                if (ref.getEditorInput() instanceof IDiagramEditorInput && (diagramInput = (IDiagramEditorInput)ref.getEditorInput()).getDiagram().equals(diagram)) {
                    boolean close = MessageDialog.openQuestion((Shell)activePage.getActivePart().getSite().getShell(), (String)"Close subdiagram editor?", (String)"The subdiagram is still open in another editor. Do you want to close it?");
                    if (close) {
                        activePage.closeEditor(ref.getEditor(false), false);
                    }
                    return close;
                }
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return true;
    }

    public static List<Diagram> getDiagramContainerHierachy(Diagram diagram) {
        ArrayList<Diagram> result = new ArrayList<Diagram>();
        if (diagram == null) {
            return result;
        }
        result.add(diagram);
        while (diagram != null && diagram.getElement() instanceof State) {
            if ((diagram = DiagramPartitioningUtil.getDiagramContaining((EObject)((State)diagram.getElement()))) == null) continue;
            result.add(diagram);
        }
        Collections.reverse(result);
        return result;
    }

    public static List<Diagram> getSubDiagramHierachy(Diagram diagram) {
        Assert.isNotNull((Object)diagram);
        ArrayList<Diagram> result = new ArrayList<Diagram>();
        result.add(diagram);
        while (diagram.getElement() instanceof State) {
            diagram = DiagramPartitioningUtil.getSubDiagram((CompositeElement)diagram.getElement());
            result.add(diagram);
        }
        Collections.reverse(result);
        return result;
    }
}

