/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.launch;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.debug.core.launch.CoreBuildLaunchConfigDelegate;
import org.eclipse.cdt.debug.core.launch.NullProcess;
import org.eclipse.cdt.debug.internal.core.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;

public class CoreBuildGenericLaunchConfigDelegate
extends CoreBuildLaunchConfigDelegate {
    public static final String TYPE_ID = "org.eclipse.cdt.debug.core.genericLaunchConfigType";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        File workingDir;
        String workingDirectory;
        IStringVariableManager varManager = VariablesPlugin.getDefault().getStringVariableManager();
        String location = configuration.getAttribute("org.eclipse.cdt.launch.ATTR_LOCATION", "");
        if (location.isEmpty()) {
            launch.addProcess((IProcess)new NullProcess(launch, Messages.CoreBuildGenericLaunchConfigDelegate_NoAction));
            return;
        }
        String substLocation = varManager.performStringSubstitution(location);
        if (substLocation.isEmpty()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.debug.core", String.format(Messages.CoreBuildGenericLaunchConfigDelegate_SubstitutionFailed, location)));
        }
        location = substLocation;
        if (!new File(location).canExecute()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.debug.core", String.format(Messages.CoreBuildGenericLaunchConfigDelegate_CommandNotValid, location)));
        }
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(location);
        String arguments = configuration.getAttribute("org.eclipse.cdt.launch.ATTR_TOOL_ARGUMENTS", "");
        if (!arguments.isEmpty()) {
            commands.addAll(Arrays.asList(varManager.performStringSubstitution(arguments).split(" ")));
        }
        if ((workingDirectory = configuration.getAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", "")).isEmpty()) {
            workingDir = new File(CoreBuildGenericLaunchConfigDelegate.getProject(configuration).getLocationURI());
        } else {
            workingDir = new File(varManager.performStringSubstitution(workingDirectory));
            if (!workingDir.isDirectory()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.debug.core", String.format(Messages.CoreBuildGenericLaunchConfigDelegate_WorkingDirNotExists, location)));
            }
        }
        String[] envp = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
        Process p = DebugPlugin.exec((String[])commands.toArray(new String[0]), (File)workingDir, (String[])envp);
        DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)String.join((CharSequence)" ", commands));
    }
}

