/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.java.ui.simulation;

import com.yakindu.base.types.PrimitiveType;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.sct.model.sruntime.ExecutionSlot;
import com.yakindu.sct.model.sruntime.ExecutionVariable;
import com.yakindu.sct.model.sruntime.impl.CompositeSlotImpl;
import com.yakindu.sct.model.sruntime.impl.ExecutionVariableImpl;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;

public class JavaObjectSlot
extends CompositeSlotImpl
implements ExecutionVariable {
    private boolean resolved = false;
    private ITypeSystem typeSystem;

    public List<ExecutionSlot> getSlots() {
        return this.getSlots(true);
    }

    public List<ExecutionSlot> getSlots(boolean doResolve) {
        if (!this.resolved) {
            this.slots = new EObjectContainmentEList(ExecutionSlot.class, (InternalEObject)this, 7);
            if (!doResolve) {
                return this.slots;
            }
            Object myValue = this.getValue();
            if (myValue == null) {
                return this.slots;
            }
            this.addMethodSlots(myValue);
            this.addFieldSlots(myValue);
            this.resolved = true;
        }
        return this.slots;
    }

    protected void addMethodSlots(Object myValue) {
        Method[] methodArray = myValue.getClass().getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers())) {
                JavaObjectSlot newSlot = new JavaObjectSlot();
                newSlot.setValue(null);
                newSlot.setName(method.getName());
                newSlot.setFqName(method.getName());
                newSlot.setType(null);
                newSlot.setWritable(false);
                newSlot.setTypeSystem(this.typeSystem);
                this.slots.add((Object)newSlot);
            }
            ++n2;
        }
    }

    protected void addFieldSlots(Object myValue) {
        Field[] fieldArray = myValue.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object newSlot;
            Field field = fieldArray[n2];
            if (this.isSimpleType(this.getJavaType(field))) {
                newSlot = new ExecutionVariableImpl();
            } else {
                newSlot = new JavaObjectSlot();
                ((JavaObjectSlot)((Object)newSlot)).setTypeSystem(this.typeSystem);
            }
            newSlot.setName(field.getName());
            newSlot.setFqName(field.getName());
            newSlot.setType(this.getJavaType(field));
            newSlot.setWritable(Modifier.isPublic(field.getModifiers()));
            newSlot.setValue(this.getJavaValue(field));
            this.slots.add(newSlot);
            ++n2;
        }
    }

    private Type getJavaType(Field field) {
        return this.typeSystem.getType(field.getType().getName());
    }

    protected Object getJavaValue(Field field) {
        try {
            field.setAccessible(true);
            return field.get(this.getValue());
        }
        catch (IllegalAccessException | IllegalArgumentException | InaccessibleObjectException e) {
            if (this.getValue() instanceof Integer) {
                return (int)((Integer)this.getValue());
            }
            if (this.getValue() instanceof Long) {
                return (long)((Long)this.getValue());
            }
            if (this.getValue() instanceof Double) {
                return (double)((Double)this.getValue());
            }
            if (this.getValue() instanceof Float) {
                return Float.valueOf(((Float)this.getValue()).floatValue());
            }
            if (this.getValue() instanceof Short) {
                return (short)((Short)this.getValue());
            }
            if (this.getValue() instanceof Byte) {
                return (byte)((Byte)this.getValue());
            }
            if (this.getValue() instanceof Boolean) {
                return (boolean)((Boolean)this.getValue());
            }
            if (this.getValue() instanceof Character) {
                return Character.valueOf(((Character)this.getValue()).charValue());
            }
            if (this.getValue() instanceof String) {
                return this.getValue();
            }
            return null;
        }
    }

    protected boolean isSimpleType(Type type) {
        return type instanceof PrimitiveType;
    }

    public void setValue(Object newValue) {
        super.setValue(newValue);
        this.resolved = false;
    }

    public ITypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    public void setTypeSystem(ITypeSystem typeSystem) {
        this.typeSystem = typeSystem;
    }
}

