/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.sgraph.naming;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.Parameter;
import com.yakindu.sct.model.sgraph.Choice;
import com.yakindu.sct.model.sgraph.CompositeElement;
import com.yakindu.sct.model.sgraph.Entry;
import com.yakindu.sct.model.sgraph.Exit;
import com.yakindu.sct.model.sgraph.FinalState;
import com.yakindu.sct.model.sgraph.Region;
import com.yakindu.sct.model.sgraph.RegularState;
import com.yakindu.sct.model.sgraph.Scope;
import com.yakindu.sct.model.sgraph.ScopedElement;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.Synchronization;
import com.yakindu.sct.model.sgraph.Vertex;
import com.yakindu.sct.model.sgraph.naming.IdentifierConverter;
import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.SimpleAttributeResolver;
import org.eclipse.xtext.util.Strings;

public class SGraphNameProvider
extends DefaultDeclarativeQualifiedNameProvider {
    protected static final QualifiedName DEFAULT_ENTRY_NAME = QualifiedName.create((String)"_entry_Default");
    protected static final QualifiedName DEFAULT_EXIT_NAME = QualifiedName.create((String)"_exit_Default");
    protected static final String _FINAL_STATE_NAME = "_final_";
    protected static final String _CHOICE_NAME = "_choice_";
    protected static final String _SYNC_NAME = "_sync";
    @Inject
    private IQualifiedNameConverter nameConverter;

    protected Function<EObject, String> getResolver() {
        return SimpleAttributeResolver.NAME_RESOLVER;
    }

    public QualifiedName qualifiedName(Statechart ele) {
        String scName = ele.getName();
        if (Strings.isEmpty((String)scName)) {
            return null;
        }
        QualifiedName name = QualifiedName.create((String)IdentifierConverter.toIdentifier(ele.getName()));
        if (!Strings.isEmpty((String)ele.getNamespace())) {
            name = this.nameConverter.toQualifiedName(ele.getNamespace()).append(name);
        }
        return name;
    }

    public QualifiedName qualifiedName(Synchronization ele) {
        QualifiedName qualifiedNameFromConverter = null;
        if (!Strings.isEmpty((String)ele.getName())) {
            qualifiedNameFromConverter = QualifiedName.create((String)ele.getName());
        } else {
            LinkedList list = new LinkedList();
            Iterables.addAll(list, (Iterable)Iterables.filter(((Region)ele.eContainer()).getVertices(), Synchronization.class));
            qualifiedNameFromConverter = QualifiedName.create((String)(_SYNC_NAME + list.indexOf(ele)));
        }
        return this.getParentQualifiedName((EObject)ele, qualifiedNameFromConverter);
    }

    public QualifiedName qualifiedName(Choice ele) {
        QualifiedName qualifiedNameFromConverter = null;
        if (!Strings.isEmpty((String)ele.getName())) {
            qualifiedNameFromConverter = QualifiedName.create((String)ele.getName());
        } else {
            ArrayList choiceList = new ArrayList();
            choiceList.addAll(Collections2.filter(((Region)ele.eContainer()).getVertices(), (Predicate)new Predicate<Vertex>(){

                public boolean apply(Vertex input) {
                    return input instanceof Choice;
                }
            }));
            int index = choiceList.indexOf(ele);
            qualifiedNameFromConverter = QualifiedName.create((String)(_CHOICE_NAME + index));
        }
        return this.getParentQualifiedName((EObject)ele, qualifiedNameFromConverter);
    }

    public QualifiedName qualifiedName(Entry ele) {
        QualifiedName name = DEFAULT_ENTRY_NAME;
        if (ele.getName() != null && !ele.getName().isEmpty()) {
            name = QualifiedName.create((String)ele.getName());
        }
        return this.getParentQualifiedName((EObject)ele, name);
    }

    public QualifiedName qualifiedName(Exit ele) {
        QualifiedName name = DEFAULT_EXIT_NAME;
        if (ele.getName() != null && !ele.getName().isEmpty()) {
            name = QualifiedName.create((String)ele.getName());
        }
        return this.getParentQualifiedName((EObject)ele, name);
    }

    protected QualifiedName getParentQualifiedName(EObject ele, QualifiedName childName) {
        EObject temp = ele;
        while (temp.eContainer() != null) {
            QualifiedName parentsQualifiedName = this.getFullyQualifiedName(temp = temp.eContainer());
            if (parentsQualifiedName == null) continue;
            return parentsQualifiedName.append(childName);
        }
        return childName;
    }

    public QualifiedName qualifiedName(Scope ele) {
        QualifiedName namespace;
        QualifiedName name = null;
        String nameString = (String)SimpleAttributeResolver.NAME_RESOLVER.apply((EObject)ele);
        if (!Strings.isEmpty((String)nameString)) {
            name = this.nameConverter.toQualifiedName(nameString);
        }
        if ((namespace = this.getNamespace(ele)) != null && name != null) {
            name = namespace.append(name);
        }
        return name;
    }

    public QualifiedName qualifiedName(FinalState ele) {
        QualifiedName qfn = null;
        qfn = Strings.isEmpty((String)ele.getName()) ? QualifiedName.create((String)_FINAL_STATE_NAME) : QualifiedName.create((String)IdentifierConverter.toIdentifier(ele.getName()));
        return this.getParentQualifiedName((EObject)ele, qfn);
    }

    public QualifiedName qualifiedName(RegularState ele) {
        if (ele.getName() == null) {
            return null;
        }
        QualifiedName qualifiedNameFromConverter = QualifiedName.create((String)IdentifierConverter.toIdentifier(ele.getName()));
        return this.getParentQualifiedName((EObject)ele, qualifiedNameFromConverter);
    }

    public QualifiedName qualifiedName(Region ele) {
        QualifiedName qualifiedNameFromConverter = null;
        if (ele.getName() == null || ele.getName().isEmpty()) {
            CompositeElement parent;
            int index;
            if (ele.eContainer() instanceof CompositeElement && (index = (parent = (CompositeElement)ele.eContainer()).getRegions().indexOf((Object)ele)) != -1) {
                qualifiedNameFromConverter = QualifiedName.create((String)("_region" + index));
            }
            if (qualifiedNameFromConverter == null) {
                return null;
            }
        } else {
            qualifiedNameFromConverter = QualifiedName.create((String)IdentifierConverter.toIdentifier(ele.getName()));
        }
        return this.getParentQualifiedName((EObject)ele, qualifiedNameFromConverter);
    }

    public QualifiedName qualifiedName(Declaration ele) {
        QualifiedName name = null;
        QualifiedName namespace = this.getNamespace((EObject)ele);
        if (!Strings.isEmpty((String)ele.getName())) {
            name = this.nameConverter.toQualifiedName(ele.getName());
        }
        if (namespace != null && name != null) {
            return namespace.append(name);
        }
        if (namespace == null && name != null && ele instanceof ComplexType) {
            return this.getParentQualifiedName((EObject)ele, name);
        }
        return name;
    }

    public QualifiedName qualifiedName(Parameter param) {
        return super.qualifiedName((Object)param);
    }

    protected QualifiedName getNamespace(EObject child) {
        ScopedElement interfaceScope;
        QualifiedName name = null;
        if (!(child instanceof ScopedElement) && (interfaceScope = (ScopedElement)EcoreUtil2.getContainerOfType((EObject)child, ScopedElement.class)) != null && !Strings.isEmpty((String)interfaceScope.getNamespace())) {
            name = this.nameConverter.toQualifiedName(interfaceScope.getNamespace());
        }
        return name;
    }
}

