/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.sgraph.util;

import com.yakindu.base.base.NamedElement;
import com.yakindu.sct.model.sgraph.Region;
import com.yakindu.sct.model.sgraph.Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class SGgraphUtil {
    public static EObject commonAncestor(EObject o1, EObject o2) {
        List<EObject> o1Anchestors = SGgraphUtil.collectAncestors(o1, new ArrayList<EObject>());
        List<EObject> o2Anchestors = SGgraphUtil.collectAncestors(o2, new ArrayList<EObject>());
        return SGgraphUtil.findCommonAncestor(o1Anchestors, o2Anchestors);
    }

    public static EObject findCommonAncestor(List<EObject> o1Anchestors, List<EObject> o2Anchestors) {
        int max = Math.min(o1Anchestors.size(), o2Anchestors.size());
        EObject commonAncestor = null;
        int i = 0;
        while (i < max) {
            if (o1Anchestors.get(i) != o2Anchestors.get(i)) break;
            commonAncestor = o1Anchestors.get(i);
            ++i;
        }
        return commonAncestor;
    }

    public static List<EObject> collectAncestors(EObject o1, List<EObject> al) {
        if (o1 != null && o1.eContainer() != null) {
            SGgraphUtil.collectAncestors(o1.eContainer(), al);
            al.add(o1.eContainer());
        }
        return al;
    }

    public static boolean areOrthogonal(List<Vertex> vertices) {
        if (vertices == null || vertices.isEmpty()) {
            return true;
        }
        ArrayList<List<EObject>> ancestorLists = new ArrayList<List<EObject>>();
        for (Vertex vertex : vertices) {
            ancestorLists.add(SGgraphUtil.collectAncestors((EObject)vertex, new ArrayList<EObject>()));
        }
        int i = 0;
        while (i < vertices.size() - 1) {
            int j = i + 1;
            while (j < vertices.size()) {
                EObject commonAncestor = SGgraphUtil.findCommonAncestor((List)ancestorLists.get(i), (List)ancestorLists.get(j));
                if (commonAncestor instanceof Region) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static <T extends NamedElement> T firstNamed(Collection<T> coll, String name) {
        for (NamedElement t : coll) {
            if (!name.equals(t.getName())) continue;
            return (T)t;
        }
        return null;
    }
}

