/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.types.validation;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.GenericElement;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Parameter;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypeParameter;
import com.yakindu.base.types.TypeSpecifier;
import com.yakindu.base.types.TypesPackage;
import com.yakindu.base.types.typesystem.ITypeSystem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringJoiner;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;

public class TypesJavaValidator
extends AbstractDeclarativeValidator {
    @Inject
    private ITypeSystem typeSystem;
    public static final String WARNING_IS_RAW_CODE = "WarningRaw";
    public static final String WARNING_IS_RAW_MSG = "%s is a raw type. References to generic type %s should be parameterized.";
    public static final String ERROR_NOT_GENERIC_CODE = "TypeNotGeneric";
    public static final String ERROR_NOT_GENERIC_MSG = "The type %s is not generic; it cannot be parameterized with arguments %s.";
    public static final String ERROR_ARGUMENTED_SPECIFIER_INCORRECT_ARGUMENT_NR_CODE = "IncorrectNrOfArguments";
    public static final String ERROR_ARGUMENTED_SPECIFIER_INCORRECT_ARGUMENT_NR_MSG = "Incorrect number of arguments for type %s; it cannot be parameterized with arguments %s.";
    public static final String ERROR_BOUND_MISSMATCH_CODE = "TypeParameterBoundMissmatch";
    public static final String ERROR_BOUND_MISSMATCH_MSG = "Bound mismatch: The type %s is not a valid substitute for the bounded parameter %s of the type %s.";
    public static final String ERROR_CYCLE_DETECTED_CODE = "TypeExtendsItself";
    public static final String ERROR_CYCLE_DETECTED_MSG = "Cycle detected: the type %s cannot extend itself.";
    public static final String ERROR_DUPLICATE_TYPE_PARAMETER_CODE = "DuplicateTypeParameter";
    public static final String ERROR_DUPLICATE_TYPE_PARAMETER_MSG = "Duplicate type parameter %s.";
    public static final String ERROR_VAR_ARGS_LAST_CODE = "VarArgsMustBeLast";
    public static final String ERROR_VAR_ARGS_LAST_MSG = "The variable argument type must be the last argument.";
    public static final String ERROR_OPTIONAL_MUST_BE_LAST_CODE = "OptionalParametersLast";
    public static final String ERROR_OPTIONAL_MUST_BE_LAST_MSG = "Required parameters must not be defined after optional parameters.";

    @Check
    public void checkIsRaw(TypeSpecifier typedElement) {
        Type type = typedElement.getType();
        if (!(type instanceof GenericElement)) {
            return;
        }
        EList<TypeParameter> typeParameter = ((GenericElement)((Object)type)).getTypeParameters();
        if (typedElement.getTypeArguments().size() == 0 && typeParameter.size() > 0) {
            String s1 = typedElement.getType().getName();
            String s2 = s1 + this.prettyPrintTypes((List<TypeParameter>)typeParameter);
            this.warning(String.format(WARNING_IS_RAW_MSG, s1, s2), typedElement, (EStructuralFeature)TypesPackage.Literals.TYPE_SPECIFIER__TYPE, WARNING_IS_RAW_CODE, new String[0]);
        }
    }

    @Check
    public void checkTypedElementNotGeneric(TypeSpecifier typedElement) {
        if (!(typedElement.getTypeArguments().size() <= 0 || typedElement.getType() instanceof GenericElement && ((GenericElement)((Object)typedElement.getType())).getTypeParameters().size() != 0)) {
            String s1 = typedElement.getType().getName();
            String s2 = this.prettyPrintArguments((List<TypeSpecifier>)typedElement.getTypeArguments());
            this.error(String.format(ERROR_NOT_GENERIC_MSG, s1, s2), typedElement, (EStructuralFeature)TypesPackage.Literals.TYPE_SPECIFIER__TYPE, ERROR_NOT_GENERIC_CODE, new String[0]);
        }
    }

    @Check
    public void checkNofArguments(TypeSpecifier typedElement) {
        if (!(typedElement.getType() instanceof GenericElement)) {
            return;
        }
        GenericElement type = (GenericElement)((Object)typedElement.getType());
        EList<TypeParameter> typeParameter = type.getTypeParameters();
        if (typedElement.getTypeArguments().size() > 0 && typedElement.getTypeArguments().size() != typeParameter.size() && typeParameter.size() > 0) {
            String s1 = type.getName() + this.prettyPrintTypes((List<TypeParameter>)typeParameter);
            String s2 = this.prettyPrintArguments((List<TypeSpecifier>)typedElement.getTypeArguments());
            this.error(String.format(ERROR_ARGUMENTED_SPECIFIER_INCORRECT_ARGUMENT_NR_MSG, s1, s2), typedElement, (EStructuralFeature)TypesPackage.Literals.TYPE_SPECIFIER__TYPE, ERROR_ARGUMENTED_SPECIFIER_INCORRECT_ARGUMENT_NR_CODE, new String[0]);
        }
    }

    @Check
    public void checkTypeParameterBounds(TypeSpecifier typedElement) {
        if (!(typedElement.getType() instanceof GenericElement)) {
            return;
        }
        GenericElement type = (GenericElement)((Object)typedElement.getType());
        EList<TypeParameter> typeParameter = type.getTypeParameters();
        if (typedElement.getTypeArguments().size() == 0 || typedElement.getTypeArguments().size() != typeParameter.size()) {
            return;
        }
        int i = 0;
        while (i < typeParameter.size()) {
            Type argument;
            TypeParameter parameter = (TypeParameter)typeParameter.get(i);
            if (parameter.getBound() != null && !this.typeSystem.isSuperType(argument = ((TypeSpecifier)typedElement.getTypeArguments().get(i)).getType(), parameter.getBound())) {
                this.error(String.format(ERROR_BOUND_MISSMATCH_MSG, argument.getName(), parameter.getBound().getName(), type.getName()), typedElement, (EStructuralFeature)TypesPackage.Literals.TYPE_SPECIFIER__TYPE_ARGUMENTS, i, ERROR_BOUND_MISSMATCH_CODE, new String[0]);
            }
            ++i;
        }
    }

    @Check
    public void checkTypeNotExtendsItself(ComplexType type) {
        EList<TypeSpecifier> superTypes = type.getSuperTypes();
        for (TypeSpecifier superType : superTypes) {
            if (!superType.getType().equals(type)) continue;
            this.error(String.format(ERROR_CYCLE_DETECTED_MSG, type.getName()), type, (EStructuralFeature)TypesPackage.Literals.TYPE__SUPER_TYPES, ERROR_CYCLE_DETECTED_CODE, new String[0]);
        }
    }

    @Check
    public void checkDuplicateTypeParameter(GenericElement type) {
        HashSet names = Sets.newHashSet();
        EList<TypeParameter> typeParameter = type.getTypeParameters();
        for (TypeParameter param : typeParameter) {
            String name = param.getName();
            if (names.contains(name)) {
                this.error(String.format(ERROR_DUPLICATE_TYPE_PARAMETER_MSG, name), type, (EStructuralFeature)TypesPackage.Literals.GENERIC_ELEMENT__TYPE_PARAMETERS, ERROR_DUPLICATE_TYPE_PARAMETER_CODE, new String[0]);
            }
            names.add(name);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkVarArgParameterIsLast(Operation operation) {
        if (operation.isVariadic() && operation.getVarArgIndex() != operation.getParameters().size() - 1) {
            this.error(ERROR_VAR_ARGS_LAST_MSG, (EObject)operation.getParameters().get(operation.getVarArgIndex()), null, ERROR_VAR_ARGS_LAST_CODE, new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkOptionalArgumentsAreLast(Operation op) {
        boolean foundOptional = false;
        for (Parameter p : op.getParameters()) {
            if (foundOptional && !p.isOptional()) {
                this.error(ERROR_OPTIONAL_MUST_BE_LAST_MSG, p, null, ERROR_OPTIONAL_MUST_BE_LAST_CODE, new String[0]);
            }
            if (!p.isOptional()) continue;
            foundOptional = true;
        }
    }

    protected String prettyPrintTypes(List<TypeParameter> typeParameters) {
        StringJoiner joiner = new StringJoiner(", ");
        for (TypeParameter typeParameter : typeParameters) {
            joiner.add(typeParameter.getName());
        }
        return "<" + joiner.toString() + ">";
    }

    protected String prettyPrintArguments(List<TypeSpecifier> specifiers) {
        StringJoiner joiner = new StringJoiner(", ");
        for (TypeSpecifier specifier : specifiers) {
            joiner.add(specifier.getType().getName());
        }
        return "<" + joiner.toString() + ">";
    }

    protected List<EPackage> getEPackages() {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        result.add(EPackage.Registry.INSTANCE.getEPackage("http://www.yakindu.org/base/types/2.0.0"));
        return result;
    }
}

