/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.python;

import com.google.inject.Inject;
import com.yakindu.sct.generator.core.IExecutionFlowGenerator;
import com.yakindu.sct.generator.core.filesystem.ISCTFileSystemAccess;
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper;
import com.yakindu.sct.generator.python.GenmodelEntries;
import com.yakindu.sct.generator.python.files.DefaultTimer;
import com.yakindu.sct.generator.python.files.PyPSetup;
import com.yakindu.sct.generator.python.files.RXPython;
import com.yakindu.sct.generator.python.files.RuntimeTemplate;
import com.yakindu.sct.generator.python.files.Statemachine;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sexec.extensions.SExecExtensions;
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions;
import com.yakindu.sct.model.sexec.naming.INamingService;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class PythonGenerator
implements IExecutionFlowGenerator {
    @Inject
    @Extension
    private GenmodelEntries _genmodelEntries;
    @Inject
    @Extension
    private SExecExtensions _sExecExtensions;
    @Inject
    @Extension
    private ICoreLibraryHelper _iCoreLibraryHelper;
    @Inject
    @Extension
    private ShadowEventExtensions _shadowEventExtensions;
    @Inject
    @Extension
    private DefaultTimer _defaultTimer;
    @Inject
    @Extension
    private RXPython _rXPython;
    @Inject
    @Extension
    private RuntimeTemplate _runtimeTemplate;
    @Inject
    @Extension
    private PyPSetup _pyPSetup;
    @Inject
    @Extension
    private Statemachine _statemachine;
    @Inject
    private INamingService namingService;

    public void generate(ExecutionFlow flow, GeneratorEntry entry, ISCTFileSystemAccess fsa) {
        boolean _createRuntimeTemplate;
        boolean _createPyPackage;
        boolean _createDefaultTimer;
        this.namingService.initializeNamingService(flow);
        boolean _isTimed = this._sExecExtensions.isTimed(flow);
        if (_isTimed && (_createDefaultTimer = this._genmodelEntries.createDefaultTimer(entry))) {
            this._defaultTimer.generateTimer(flow, entry, (IFileSystemAccess)fsa);
        }
        if (_createPyPackage = this._genmodelEntries.createPyPackage(entry)) {
            this._pyPSetup.generatePythonPackagingSetup(flow, entry, (IFileSystemAccess)fsa);
        }
        if (_createRuntimeTemplate = this._genmodelEntries.createRuntimeTemplate(entry)) {
            this._runtimeTemplate.generateRuntimeTemplate(flow, entry, (IFileSystemAccess)fsa);
        }
        if (this._iCoreLibraryHelper.getOutEventObservablesUsed(entry) && this._sExecExtensions.hasOutgoingEvents(flow) || !IterableExtensions.isNullOrEmpty((Iterable)this._shadowEventExtensions.getShadowEvents(flow))) {
            this._rXPython.generateObserver(flow, entry, (IFileSystemAccess)fsa);
        }
        this._statemachine.generateStatemachine(flow, entry, fsa);
    }
}

