/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.gmf.runtime.router;

public class MaxMoveDelta {
    public boolean isVerticalMove;
    public double minDeltaPos;
    public double maxDeltaPos;

    public MaxMoveDelta() {
    }

    public MaxMoveDelta(boolean isVertical) {
        this.isVerticalMove = isVertical;
    }

    public MaxMoveDelta(boolean isVerticalMove, double minDelta, double maxDelta) {
        if (minDelta > 0.0) {
            minDelta = 0.0;
        }
        if (maxDelta < 0.0) {
            maxDelta = 0.0;
        }
        this.isVerticalMove = isVerticalMove;
        this.minDeltaPos = minDelta;
        this.maxDeltaPos = maxDelta;
    }

    public MaxMoveDelta(double minDelta, double maxDelta) {
        this(true, minDelta, maxDelta);
    }

    public void merge(MaxMoveDelta mmd) {
        if (this.isVerticalMove != mmd.isVerticalMove) {
            throw new IllegalArgumentException("Cannot merge MaxMoveDelta with different direction.");
        }
        if (this.minDeltaPos == 0.0 || mmd.minDeltaPos < 0.0 && mmd.minDeltaPos > this.minDeltaPos) {
            this.minDeltaPos = mmd.minDeltaPos;
        }
        if (this.maxDeltaPos == 0.0 || mmd.maxDeltaPos > 0.0 && mmd.maxDeltaPos < this.maxDeltaPos) {
            this.maxDeltaPos = mmd.maxDeltaPos;
        }
    }

    public double reqDelta(double deltaPos, double deltaSize) {
        double dt = deltaPos + (deltaSize < 0.0 ? deltaSize : 0.0);
        if (dt < this.minDeltaPos) {
            return dt - this.minDeltaPos;
        }
        if (dt > this.maxDeltaPos) {
            return dt - this.maxDeltaPos;
        }
        return 0.0;
    }

    public String toString() {
        return this.isVerticalMove ? "{minDy=" + this.minDeltaPos + ",maxDy=" + this.maxDeltaPos + "}" : "{minDx=" + this.minDeltaPos + ",maxDx=" + this.maxDeltaPos + "}";
    }
}

