/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.sexec.transformation;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.expressions.ExpressionBuilder;
import com.yakindu.base.expressions.expressions.AssignmentExpression;
import com.yakindu.base.expressions.expressions.BoolLiteral;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.expressions.expressions.NumericalAddSubtractExpression;
import com.yakindu.base.expressions.expressions.PostFixOperator;
import com.yakindu.base.expressions.expressions.PostFixUnaryExpression;
import com.yakindu.base.expressions.expressions.PrimitiveValueExpression;
import com.yakindu.base.expressions.expressions.ReturnExpression;
import com.yakindu.base.expressions.util.ExpressionExtensions;
import com.yakindu.base.types.Argument;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Parameter;
import com.yakindu.base.types.Property;
import com.yakindu.sct.model.sexec.Call;
import com.yakindu.sct.model.sexec.Check;
import com.yakindu.sct.model.sexec.CheckRef;
import com.yakindu.sct.model.sexec.ExecutionChoice;
import com.yakindu.sct.model.sexec.ExecutionEntry;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sexec.ExecutionRegion;
import com.yakindu.sct.model.sexec.ExecutionState;
import com.yakindu.sct.model.sexec.HistoryEntry;
import com.yakindu.sct.model.sexec.If;
import com.yakindu.sct.model.sexec.LocalVariableDefinition;
import com.yakindu.sct.model.sexec.Method;
import com.yakindu.sct.model.sexec.Reaction;
import com.yakindu.sct.model.sexec.Sequence;
import com.yakindu.sct.model.sexec.SexecFactory;
import com.yakindu.sct.model.sexec.StateCase;
import com.yakindu.sct.model.sexec.StateSwitch;
import com.yakindu.sct.model.sexec.Statement;
import com.yakindu.sct.model.sexec.Step;
import com.yakindu.sct.model.sexec.concepts.StateMachineBehaviorConcept;
import com.yakindu.sct.model.sexec.extensions.SExecExtensions;
import com.yakindu.sct.model.sgraph.SGraphFactory;
import com.yakindu.sct.model.sgraph.util.StatechartUtil;
import com.yakindu.sct.model.stext.stext.StextFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class FlowOptimizer {
    @Inject
    @Extension
    private SExecExtensions sexec;
    @Inject
    @Extension
    private StateMachineBehaviorConcept concept;
    @Inject
    @Extension
    private ExpressionExtensions _expressionExtensions;
    @Inject
    @Extension
    private StatechartUtil _statechartUtil;
    @Inject
    @Extension
    private ExpressionBuilder _expressionBuilder;
    private boolean _inlineReactions;
    private boolean _inlineEntryActions;
    private boolean _inlineExitActions;
    private boolean _inlineEnterSequences;
    private boolean _inlineEnterRegion;
    private boolean _inlineExitRegion;
    private boolean _inlineExitSequences;
    private boolean _inlineChoices;
    private boolean _inlineEntries;

    public boolean inlineReactions(boolean b) {
        this._inlineReactions = b;
        return this._inlineReactions;
    }

    public boolean inlineEntryActions(boolean b) {
        this._inlineEntryActions = b;
        return this._inlineEntryActions;
    }

    public boolean inlineExitActions(boolean b) {
        this._inlineExitActions = b;
        return this._inlineExitActions;
    }

    public boolean inlineEnterSequences(boolean b) {
        this._inlineEnterSequences = b;
        return this._inlineEnterSequences;
    }

    public boolean inlineEnterRegion(boolean b) {
        this._inlineEnterRegion = b;
        return this._inlineEnterRegion;
    }

    public boolean inlineExitRegion(boolean b) {
        this._inlineExitRegion = b;
        return this._inlineExitRegion;
    }

    public boolean inlineExitSequences(boolean b) {
        this._inlineExitSequences = b;
        return this._inlineExitSequences;
    }

    public boolean inlineChoices(boolean b) {
        this._inlineChoices = b;
        return this._inlineChoices;
    }

    public boolean inlineEntries(boolean b) {
        this._inlineEntries = b;
        return this._inlineEntries;
    }

    public ExecutionFlow optimize(ExecutionFlow flow) {
        this.replaceTrueIfs(flow);
        this.transformPostFixUnaryExpressionsOnSubmachineCalls(flow);
        if (this._inlineReactions) {
            this.inlineReactionChecks(flow);
            this.inlineReactionEffects(flow);
        }
        this.inline(flow.getEntryAction());
        this.inline(flow.getExitAction());
        if (this._inlineEntryActions) {
            Consumer<ExecutionState> _function = state -> this.inline(state.getEntryAction());
            flow.getStates().forEach(_function);
        }
        if (this._inlineExitActions) {
            Consumer<ExecutionState> _function_1 = state -> this.inline(state.getExitAction());
            flow.getStates().forEach(_function_1);
        }
        if (this._inlineEnterSequences) {
            Consumer<ExecutionState> _function_2 = state -> {
                Consumer<Sequence> _function_3 = s -> this.inline((Step)s);
                state.getEnterSequences().forEach(_function_3);
            };
            flow.getStates().forEach(_function_2);
        }
        if (this._inlineExitSequences) {
            Consumer<ExecutionState> _function_3 = state -> this.inline(state.getExitSequence());
            flow.getStates().forEach(_function_3);
        }
        if (this._inlineExitRegion) {
            Procedures.Procedure1 _function_4 = region -> this.inline(region.getExitSequence());
            IteratorExtensions.forEach((Iterator)Iterators.filter((Iterator)flow.eAllContents(), ExecutionRegion.class), (Procedures.Procedure1)_function_4);
        }
        if (this._inlineEnterRegion) {
            Procedures.Procedure1 _function_5 = region -> {
                Consumer<Sequence> _function_6 = s -> this.inline((Step)s);
                region.getEnterSequences().forEach(_function_6);
            };
            IteratorExtensions.forEach((Iterator)Iterators.filter((Iterator)flow.eAllContents(), ExecutionRegion.class), (Procedures.Procedure1)_function_5);
        }
        if (this._inlineChoices) {
            Consumer<ExecutionChoice> _function_6 = node -> {
                Consumer<Reaction> _function_7 = r -> {
                    this.inline(r.getCheck());
                    this.inline(r.getEffect());
                };
                node.getReactions().forEach(_function_7);
            };
            Iterables.filter(flow.getNodes(), ExecutionChoice.class).forEach(_function_6);
        }
        if (this._inlineEntries) {
            Consumer<ExecutionEntry> _function_7 = node -> {
                Consumer<Reaction> _function_8 = r -> {
                    this.inline(r.getCheck());
                    this.inline(r.getEffect());
                };
                node.getReactions().forEach(_function_8);
            };
            Iterables.filter(flow.getNodes(), ExecutionEntry.class).forEach(_function_7);
            Consumer<ExecutionEntry> _function_8 = node -> this.inline(node.getReactSequence());
            Iterables.filter(flow.getNodes(), ExecutionEntry.class).forEach(_function_8);
        }
        Consumer<Method> _function_9 = it -> this.inlineChecks((Method)it);
        this.sexec.reactMethods(flow).forEach(_function_9);
        Consumer<Method> _function_10 = it -> this.inlineEffects((Method)it);
        this.sexec.reactMethods(flow).forEach(_function_10);
        this.optimizeMethods(flow);
        return flow;
    }

    public void optimizeMethods(ExecutionFlow flow) {
        boolean optimized = false;
        do {
            optimized = (optimized = false) || this.eliminateEmptySequenceBlocks(flow);
            optimized = optimized || this.eliminateEmptyNamedSequences(flow);
            optimized = optimized || this.eliminateOnlyReturningMethod(flow);
        } while (optimized = optimized || this.eliminateOnlyAssigningMethod(flow));
    }

    public void replaceTrueIfs(ExecutionFlow flow) {
        Functions.Function1 _function = i -> this.alwaysTrue(i.getCheck());
        Procedures.Procedure1 _function_1 = i -> {
            Check _check = i.getCheck();
            if (_check instanceof CheckRef) {
                Check _check_1 = i.getCheck();
                ((CheckRef)_check_1).setCheck(null);
            }
            i.setCheck(null);
            this.substituteBy((Step)i, i.getThenStep());
        };
        IteratorExtensions.forEach((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)flow.eAllContents(), If.class), (Functions.Function1)_function), (Procedures.Procedure1)_function_1);
    }

    public boolean eliminateEmptyNamedSequences(ExecutionFlow flow) {
        Functions.Function1 _function = s -> this.empty((Step)s) && !this.concept.isStateMachineConcept((NamedElement)s);
        Functions.Function1 _function_1 = it -> {
            int _size = it.getCaller().size();
            return _size > 0;
        };
        List emptySeqences = IteratorExtensions.toList((Iterator)IteratorExtensions.filter((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)flow.eAllContents(), Sequence.class), (Functions.Function1)_function), (Functions.Function1)_function_1));
        Functions.Function1 _function_2 = state -> state.getReactSequence();
        emptySeqences.removeAll(ListExtensions.map(flow.getStates(), (Functions.Function1)_function_2));
        Functions.Function1 _function_3 = node -> node.getReactSequence();
        emptySeqences.removeAll(ListExtensions.map(flow.getNodes(), (Functions.Function1)_function_3));
        Consumer<Sequence> _function_4 = s -> {
            Call[] callList = (Call[])((Call[])Conversions.unwrapArray((Object)IterableExtensions.toList(s.getCaller()), Call.class)).clone();
            Consumer<Call> _function_5 = c -> {
                this.substituteCall(c.eContainer(), (Call)c, null);
                Consumer<Call> _function_6 = call -> call.setStep(null);
                ((List)Conversions.doWrapArray((Object)callList)).forEach(_function_6);
            };
            ((List)Conversions.doWrapArray((Object)callList)).forEach(_function_5);
        };
        emptySeqences.forEach(_function_4);
        int _size = emptySeqences.size();
        return _size > 0;
    }

    public boolean eliminateEmptySequenceBlocks(ExecutionFlow flow) {
        List<Sequence> sequences = this.allSequences(flow);
        List garbage = null;
        long count = 0L;
        do {
            Functions.Function1 _function = seq -> this.empty((Step)seq) && !this.concept.isStateMachineConcept((NamedElement)seq) && (this.isInSequence((Step)seq) || this.isElseStep((Step)seq));
            garbage = IterableExtensions.toList((Iterable)IterableExtensions.filter(sequences, (Functions.Function1)_function));
            Consumer<Sequence> _function_1 = seq -> this.eliminate((Step)seq);
            garbage.forEach(_function_1);
            long _count = count;
            int _size = garbage.size();
            count = _count + (long)_size;
        } while (!garbage.isEmpty());
        return count > 0L;
    }

    public boolean eliminateOnlyReturningMethod(ExecutionFlow flow) {
        boolean _not;
        Functions.Function1 _function = it -> {
            boolean _equals;
            boolean _xblockexpression = false;
            Functions.Function1 _function_1 = it_1 -> {
                Expression _expression = it_1.getExpression();
                return _expression instanceof ReturnExpression;
            };
            Statement returnStatement = (Statement)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter(it.getBody().getSteps(), Statement.class), (Functions.Function1)_function_1));
            boolean _or = false;
            int _size = it.getBody().getSteps().size();
            boolean bl = _equals = _size == 0;
            if (_equals) {
                _or = true;
            } else {
                boolean _and = false;
                if (it.getBody().getSteps().size() != 1 || it.getBody().getSteps().get(0) != returnStatement) {
                    _and = false;
                } else {
                    ReturnExpression _expression = this.expression(returnStatement, ReturnExpression.class);
                    Expression _expression_1 = null;
                    if (_expression != null) {
                        _expression_1 = _expression.getExpression();
                    }
                    EObject _featureOrReference = this._expressionExtensions.featureOrReference(_expression_1);
                    _and = _featureOrReference instanceof Parameter;
                }
                _or = _and;
            }
            _xblockexpression = _or;
            return _xblockexpression;
        };
        List retMethods = IteratorExtensions.toList((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)flow.eAllContents(), Method.class), (Functions.Function1)_function));
        boolean _isEmpty = retMethods.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            this.replaceReferences(flow, retMethods);
            return true;
        }
        return false;
    }

    public boolean eliminateOnlyAssigningMethod(ExecutionFlow flow) {
        boolean _not;
        List<Method> retMethods = this.collectOnlyAssigningMethods(flow);
        boolean _isEmpty = retMethods.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            this.replaceReferences(flow, retMethods);
            return true;
        }
        return false;
    }

    protected List<Method> collectOnlyAssigningMethods(ExecutionFlow flow) {
        Functions.Function1 _function = it -> {
            Step _get_1;
            boolean _tripleEquals_2;
            Step _get;
            boolean _tripleEquals;
            boolean _xblockexpression = false;
            List bodySteps = IterableExtensions.toList(this.flatten(it.getBody()));
            LocalVariableDefinition localVariableDefinition = (LocalVariableDefinition)IterableExtensions.head((Iterable)Iterables.filter((Iterable)bodySteps, LocalVariableDefinition.class));
            Functions.Function1 _function_1 = it_1 -> {
                Expression _expression = it_1.getExpression();
                return _expression instanceof AssignmentExpression;
            };
            Statement assignmentStatement = (Statement)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)bodySteps, Statement.class), (Functions.Function1)_function_1));
            Functions.Function1 _function_2 = it_1 -> {
                Expression _expression = it_1.getExpression();
                return _expression instanceof ReturnExpression;
            };
            Statement returnStatement = (Statement)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)bodySteps, Statement.class), (Functions.Function1)_function_2));
            boolean _and = false;
            boolean _and_1 = false;
            boolean _and_2 = false;
            boolean _and_3 = false;
            boolean _and_4 = false;
            if (bodySteps.size() != 3 || bodySteps.get(0) != localVariableDefinition) {
                _and_4 = false;
            } else {
                Expression _initialValue = localVariableDefinition.getInitialValue();
                EObject _featureOrReference = null;
                if (_initialValue != null) {
                    _featureOrReference = this._expressionExtensions.featureOrReference(_initialValue);
                }
                _and_4 = _featureOrReference instanceof Parameter;
            }
            _and_3 = !_and_4 ? false : (_tripleEquals = (_get = (Step)bodySteps.get(1)) == assignmentStatement);
            if (!_and_3) {
                _and_2 = false;
            } else {
                EObject _featureOrReference_2;
                EObject _featureOrReference_1;
                boolean _tripleEquals_1;
                AssignmentExpression _expression = this.expression(assignmentStatement, AssignmentExpression.class);
                Expression _expression_1 = null;
                if (_expression != null) {
                    _expression_1 = _expression.getExpression();
                }
                _and_2 = _tripleEquals_1 = (_featureOrReference_1 = this._expressionExtensions.featureOrReference(_expression_1)) == (_featureOrReference_2 = this._expressionExtensions.featureOrReference(localVariableDefinition.getInitialValue()));
            }
            _and_1 = !_and_2 ? false : (_tripleEquals_2 = (_get_1 = (Step)bodySteps.get(2)) == returnStatement);
            if (!_and_1) {
                _and = false;
            } else {
                Property _variable;
                EObject _featureOrReference_3;
                boolean _tripleEquals_3;
                ReturnExpression _expression_2 = this.expression(returnStatement, ReturnExpression.class);
                Expression _expression_3 = null;
                if (_expression_2 != null) {
                    _expression_3 = _expression_2.getExpression();
                }
                _and = _tripleEquals_3 = (_featureOrReference_3 = this._expressionExtensions.featureOrReference(_expression_3)) == (_variable = localVariableDefinition.getVariable());
            }
            _xblockexpression = _and;
            return _xblockexpression;
        };
        return IteratorExtensions.toList((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)flow.eAllContents(), Method.class), (Functions.Function1)_function));
    }

    protected <T extends EObject> T expression(Statement it, Class<T> type) {
        Expression _expression;
        Expression _xifexpression = null;
        boolean _isAssignableFrom = type.isAssignableFrom(it.getExpression().getClass());
        _xifexpression = _isAssignableFrom ? (_expression = it.getExpression()) : null;
        return (T)_xifexpression;
    }

    protected Iterable<Step> _flatten(Sequence it) {
        Functions.Function1 _function = step -> this.flatten((Step)step);
        return Iterables.concat((Iterable)ListExtensions.map(it.getSteps(), (Functions.Function1)_function));
    }

    protected Iterable<Step> _flatten(Step it) {
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Step[]{it}));
    }

    protected void replaceReferences(ExecutionFlow flow, List<Method> retMethods) {
        Functions.Function1 _function = ere -> {
            Functions.Function1 _function_1 = retMet -> {
                EObject _reference = ere.getReference();
                return _reference == retMet;
            };
            return IterableExtensions.exists((Iterable)retMethods, (Functions.Function1)_function_1);
        };
        Functions.Function1 _function_1 = it -> it.eContainer();
        List eleref = IteratorExtensions.toList((Iterator)IteratorExtensions.map((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)flow.eAllContents(), ElementReferenceExpression.class), (Functions.Function1)_function), (Functions.Function1)_function_1));
        Consumer<EObject> _function_2 = ere -> {
            if (ere instanceof Statement) {
                EcoreUtil2.remove((EObject)ere);
            }
            if (ere instanceof LocalVariableDefinition) {
                Expression _initialValue = ((LocalVariableDefinition)ere).getInitialValue();
                Expression arg = ((Argument)IterableExtensions.head((Iterable)((ElementReferenceExpression)_initialValue).getArguments())).getValue();
                EcoreUtil2.replace((EObject)((LocalVariableDefinition)ere).getInitialValue(), (EObject)arg);
            }
            if (ere instanceof ReturnExpression) {
                EcoreUtil2.remove((EObject)((ReturnExpression)ere).eContainer());
            }
            if (ere instanceof AssignmentExpression) {
                EObject _eContainer = ((AssignmentExpression)ere).eContainer().eContainer();
                if (_eContainer instanceof StateCase) {
                    EcoreUtil2.remove((EObject)((AssignmentExpression)ere).eContainer());
                } else {
                    Expression _expression = ((AssignmentExpression)ere).getExpression();
                    Expression arg_1 = ((Argument)IterableExtensions.head((Iterable)((ElementReferenceExpression)_expression).getArguments())).getValue();
                    EcoreUtil2.replace((EObject)((AssignmentExpression)ere).getExpression(), (EObject)arg_1);
                }
            }
        };
        eleref.forEach(_function_2);
        int i = 0;
        while (i < retMethods.size()) {
            EcoreUtil2.remove((EObject)((EObject)retMethods.get(i)));
            ++i;
        }
    }

    public void transformPostFixUnaryExpressionsOnSubmachineCalls(ExecutionFlow it) {
        Functions.Function1 _function = it_1 -> this._statechartUtil.isMultiSM(this._expressionExtensions.featureOrReference(it_1.getOperand()).eContainer());
        Consumer<PostFixUnaryExpression> _function_1 = it_1 -> {
            Expression _operand = it_1.getOperand();
            NumericalAddSubtractExpression _switchResult = null;
            PostFixOperator _operator = it_1.getOperator();
            if (_operator != null) {
                switch (_operator) {
                    case INCREMENT: {
                        _switchResult = this._expressionBuilder._plus((Expression)EcoreUtil.copy((EObject)it_1.getOperand()), (Expression)this._expressionBuilder._integer(Integer.valueOf(1)));
                        break;
                    }
                    case DECREMENT: {
                        _switchResult = this._expressionBuilder._minus((Expression)EcoreUtil.copy((EObject)it_1.getOperand()), (Expression)this._expressionBuilder._integer(Integer.valueOf(1)));
                        break;
                    }
                }
            }
            EcoreUtil.replace((EObject)it_1, (EObject)this._expressionBuilder._assignment(_operand, _switchResult));
        };
        IteratorExtensions.toList((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)it.eAllContents(), PostFixUnaryExpression.class), (Functions.Function1)_function)).forEach(_function_1);
    }

    public boolean isElseStep(Step it) {
        return it.eContainer() instanceof If && ((If)it.eContainer()).getElseStep() == it;
    }

    public boolean isInSequence(Step it) {
        EObject _eContainer = it.eContainer();
        return _eContainer instanceof Sequence;
    }

    public List<Sequence> allSequences(ExecutionFlow it) {
        return IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)it.eAllContents(), Sequence.class));
    }

    public Boolean eliminate(Step it) {
        return this.eliminate(it.eContainer(), it);
    }

    protected Boolean _eliminate(Object parent, Step step) {
        return null;
    }

    protected Boolean _eliminate(Sequence parent, Step step) {
        boolean _xifexpression = false;
        boolean _contains = parent.getSteps().contains((Object)step);
        if (_contains) {
            _xifexpression = parent.getSteps().remove((Object)step);
        }
        return _xifexpression;
    }

    protected Boolean _eliminate(If parent, Step step) {
        boolean _tripleEquals;
        Step _elseStep = parent.getElseStep();
        boolean bl = _tripleEquals = _elseStep == step;
        if (_tripleEquals) {
            parent.setElseStep(null);
        }
        return null;
    }

    public Step substituteBy(Step orig, Step substitute) {
        return this.substitute(orig.eContainer(), orig, substitute);
    }

    protected Step _substitute(Object parent, Step orig, Step subst) {
        return null;
    }

    protected Step _substitute(Sequence parent, Step orig, Step subst) {
        Step _xifexpression = null;
        boolean _contains = parent.getSteps().contains((Object)orig);
        if (_contains) {
            _xifexpression = (Step)parent.getSteps().set(parent.getSteps().indexOf((Object)orig), (Object)subst);
        }
        return _xifexpression;
    }

    protected Step _substitute(If parent, Step orig, Step subst) {
        Step _xblockexpression = null;
        Step _thenStep = parent.getThenStep();
        boolean _equals = Objects.equals(_thenStep, orig);
        if (_equals) {
            parent.setThenStep(subst);
        } else {
            Step _elseStep = parent.getElseStep();
            boolean _equals_1 = Objects.equals(_elseStep, orig);
            if (_equals_1) {
                parent.setElseStep(subst);
            }
        }
        _xblockexpression = subst;
        return _xblockexpression;
    }

    public boolean alwaysTrue(Check check) {
        if (check != null && check.getCondition() instanceof PrimitiveValueExpression) {
            Expression _condition = check.getCondition();
            PrimitiveValueExpression pve = (PrimitiveValueExpression)_condition;
            return pve.getValue() instanceof BoolLiteral && ((BoolLiteral)pve.getValue()).isValue();
        }
        return false;
    }

    protected boolean _empty(Step step) {
        return false;
    }

    protected boolean _empty(Sequence seq) {
        int _size = seq.getSteps().size();
        return _size == 0;
    }

    public void inlineReactionChecks(ExecutionFlow flow) {
        Consumer<ExecutionState> _function = state -> this.inlineReactionChecks((ExecutionState)state);
        flow.getStates().forEach(_function);
    }

    public ExecutionState inlineReactionChecks(ExecutionState state) {
        ExecutionState _xblockexpression = null;
        Functions.Function1 _function = r -> r.getCheck();
        List checks = IterableExtensions.toList((Iterable)ListExtensions.map(state.getReactions(), (Functions.Function1)_function));
        Consumer<Check> _function_1 = c -> this.inline((Check)c);
        checks.forEach(_function_1);
        _xblockexpression = state;
        return _xblockexpression;
    }

    public void inlineChecks(Method m) {
        if (m != null) {
            Consumer<CheckRef> _function = cr -> this.inline((CheckRef)cr);
            IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)m.eAllContents(), CheckRef.class)).forEach(_function);
        }
    }

    public void inlineEffects(Method m) {
        if (m != null) {
            Consumer<Call> _function = call -> this.inline((Call)call);
            IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)m.eAllContents(), Call.class)).forEach(_function);
        }
    }

    public Check inline(Check c) {
        Check _xblockexpression = null;
        if (c != null) {
            ArrayList<CheckRef> cRefs = new ArrayList<CheckRef>();
            cRefs.addAll((Collection<CheckRef>)c.getRefs());
            for (CheckRef ref : cRefs) {
                Check clone = (Check)EcoreUtil.copy((EObject)c);
                this.substitute(ref.eContainer(), ref, clone);
                ref.setCheck(null);
            }
        }
        _xblockexpression = c;
        return _xblockexpression;
    }

    public void inline(CheckRef it) {
        Check clone = (Check)EcoreUtil.copy((EObject)it.getCheck());
        this.substitute(it.eContainer(), it, clone);
        it.setCheck(null);
    }

    protected Step _substitute(EObject owner, Check pre, Check post) {
        return null;
    }

    protected Step _substitute(If owner, Check pre, Check post) {
        Check _xblockexpression = null;
        Check _check = owner.getCheck();
        boolean _equals = Objects.equals(_check, pre);
        if (_equals) {
            owner.setCheck(post);
        }
        _xblockexpression = post;
        return _xblockexpression;
    }

    public void inlineReactionEffects(ExecutionFlow flow) {
        Consumer<ExecutionState> _function = state -> this.inlineReactionEffects((ExecutionState)state);
        flow.getStates().forEach(_function);
    }

    public ExecutionState inlineReactionEffects(ExecutionState state) {
        ExecutionState _xblockexpression = null;
        Functions.Function1 _function = r -> r.getEffect();
        List effects = IterableExtensions.toList((Iterable)ListExtensions.map(state.getReactions(), (Functions.Function1)_function));
        Consumer<Step> _function_1 = e -> this.inline((Step)e);
        effects.forEach(_function_1);
        _xblockexpression = state;
        return _xblockexpression;
    }

    public void inlineEntryAndExitActions(ExecutionFlow flow) {
        Consumer<ExecutionState> _function = state -> this.inline(state.getEntryAction());
        flow.getStates().forEach(_function);
        Consumer<ExecutionState> _function_1 = state -> this.inline(state.getExitAction());
        flow.getStates().forEach(_function_1);
    }

    public Step inline(Step step) {
        Step _xblockexpression = null;
        if (step != null) {
            ArrayList<Call> calls = new ArrayList<Call>();
            calls.addAll((Collection<Call>)step.getCaller());
            for (Call caller : calls) {
                Step clone = this.stepCopy(step);
                boolean _substituteCall = this.substituteCall(caller.eContainer(), caller, clone);
                if (_substituteCall) {
                    caller.setStep(null);
                    continue;
                }
                EObject _eContainer = caller.eContainer();
                String _plus = "Did not substitute '" + String.valueOf(step) + "' call from '" + String.valueOf(_eContainer);
                String _plus_1 = _plus + "'.";
                System.out.println(_plus_1);
            }
        }
        _xblockexpression = step;
        return _xblockexpression;
    }

    public void inline(Call it) {
        Step clone = this.stepCopy(it.getStep());
        boolean _substituteCall = this.substituteCall(it.eContainer(), it, clone);
        if (_substituteCall) {
            it.setStep(null);
        } else {
            Step _step = it.getStep();
            String _plus = "Did not substitute '" + String.valueOf(_step);
            String _plus_1 = _plus + "' call from '";
            EObject _eContainer = it.eContainer();
            String _plus_2 = _plus_1 + String.valueOf(_eContainer);
            String _plus_3 = _plus_2 + "'.";
            System.out.println(_plus_3);
        }
    }

    protected boolean _substituteCall(EObject owner, Call pre, Step post) {
        return false;
    }

    protected boolean _substituteCall(StateCase owner, Call pre, Step post) {
        Step _step = owner.getStep();
        boolean _equals = Objects.equals(_step, pre);
        if (_equals) {
            owner.setStep(post);
            return true;
        }
        return false;
    }

    protected boolean _substituteCall(HistoryEntry owner, Call pre, Step post) {
        Step _initialStep = owner.getInitialStep();
        boolean _equals = Objects.equals(_initialStep, pre);
        if (_equals) {
            owner.setInitialStep(post);
            return true;
        }
        Step _historyStep = owner.getHistoryStep();
        boolean _equals_1 = Objects.equals(_historyStep, pre);
        if (_equals_1) {
            owner.setHistoryStep(post);
            return true;
        }
        return false;
    }

    protected boolean _substituteCall(Sequence owner, Call call, Step step) {
        boolean _contains = owner.getSteps().contains((Object)call);
        if (_contains) {
            if (step != null) {
                owner.getSteps().set(owner.getSteps().indexOf((Object)call), (Object)step);
            } else {
                owner.getSteps().remove(owner.getSteps().indexOf((Object)call));
            }
            return true;
        }
        return false;
    }

    protected boolean _substituteCall(If owner, Call call, Step step) {
        Step _thenStep = owner.getThenStep();
        boolean _equals = Objects.equals(_thenStep, call);
        if (_equals) {
            owner.setThenStep(step);
            return true;
        }
        Step _elseStep = owner.getElseStep();
        boolean _equals_1 = Objects.equals(_elseStep, call);
        if (_equals_1) {
            owner.setElseStep(step);
            return true;
        }
        return false;
    }

    protected Step _stepCopy(Step step) {
        return (Step)EcoreUtil.copy((EObject)step);
    }

    protected Step _stepCopy(Sequence seq) {
        Sequence _xblockexpression = null;
        Sequence _copy = this.sexecFactory().createSequence();
        _copy.setName(seq.getName());
        _copy.setComment(seq.getComment());
        Functions.Function1 _function = s -> this.stepCopy((Step)s);
        _copy.getSteps().addAll((Collection)ListExtensions.map(seq.getSteps(), (Functions.Function1)_function));
        _xblockexpression = _copy;
        return _xblockexpression;
    }

    protected Step _stepCopy(If _if) {
        If _xblockexpression = null;
        If _copy = this.sexecFactory().createIf();
        _copy.setName(_if.getName());
        _copy.setComment(_if.getComment());
        Step _stepCopy = this.stepCopy(_if.getCheck());
        _copy.setCheck((Check)_stepCopy);
        Step _xifexpression = null;
        Step _thenStep = _if.getThenStep();
        boolean _tripleNotEquals = _thenStep != null;
        _xifexpression = _tripleNotEquals ? this.stepCopy(_if.getThenStep()) : null;
        _copy.setThenStep(_xifexpression);
        Step _xifexpression_1 = null;
        Step _elseStep = _if.getElseStep();
        boolean _tripleNotEquals_1 = _elseStep != null;
        _xifexpression_1 = _tripleNotEquals_1 ? this.stepCopy(_if.getElseStep()) : null;
        _copy.setElseStep(_xifexpression_1);
        _xblockexpression = _copy;
        return _xblockexpression;
    }

    protected Step _stepCopy(Call call) {
        Call _xblockexpression = null;
        Call _copy = this.sexecFactory().createCall();
        _copy.setName(call.getName());
        _copy.setComment(call.getComment());
        _copy.setStep(call.getStep());
        _xblockexpression = _copy;
        return _xblockexpression;
    }

    protected Step _stepCopy(CheckRef cref) {
        CheckRef _xblockexpression = null;
        CheckRef _copy = this.sexecFactory().createCheckRef();
        _copy.setName(cref.getName());
        _copy.setComment(cref.getComment());
        _copy.setCheck(cref.getCheck());
        _xblockexpression = _copy;
        return _xblockexpression;
    }

    protected Step _stepCopy(HistoryEntry cref) {
        HistoryEntry _xblockexpression = null;
        HistoryEntry _copy = this.sexecFactory().createHistoryEntry();
        _copy.setName(cref.getName());
        _copy.setComment(cref.getComment());
        _copy.setDeep(cref.isDeep());
        _copy.setRegion(cref.getRegion());
        Step _initialStep = cref.getInitialStep();
        Step _stepCopy = null;
        if (_initialStep != null) {
            _stepCopy = this.stepCopy(_initialStep);
        }
        _copy.setInitialStep(_stepCopy);
        _copy.setHistoryStep(this.stepCopy(cref.getHistoryStep()));
        _xblockexpression = _copy;
        return _xblockexpression;
    }

    protected Step _stepCopy(StateSwitch _switch) {
        StateSwitch _xblockexpression = null;
        StateSwitch _copy = this.sexecFactory().createStateSwitch();
        _copy.setName(_switch.getName());
        _copy.setComment(_switch.getComment());
        _copy.setStateConfigurationIdx(_switch.getStateConfigurationIdx());
        Functions.Function1 _function = c -> this.caseCopy((StateCase)c);
        _copy.getCases().addAll((Collection)ListExtensions.map(_switch.getCases(), (Functions.Function1)_function));
        _xblockexpression = _copy;
        return _xblockexpression;
    }

    public StateCase caseCopy(StateCase _case) {
        StateCase _xblockexpression = null;
        StateCase _copy = this.sexecFactory().createStateCase();
        _copy.setState(_case.getState());
        _copy.setStep(this.stepCopy(_case.getStep()));
        _xblockexpression = _copy;
        return _xblockexpression;
    }

    public SexecFactory sexecFactory() {
        return SexecFactory.eINSTANCE;
    }

    public SGraphFactory sgraphFactory() {
        return SGraphFactory.eINSTANCE;
    }

    public StextFactory stextFactory() {
        return StextFactory.eINSTANCE;
    }

    @XbaseGenerated
    protected Iterable<Step> flatten(Step it) {
        if (it instanceof Sequence) {
            return this._flatten((Sequence)it);
        }
        if (it != null) {
            return this._flatten(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    public Boolean eliminate(Object parent, Step step) {
        if (parent instanceof If) {
            return this._eliminate((If)parent, step);
        }
        if (parent instanceof Sequence) {
            return this._eliminate((Sequence)parent, step);
        }
        if (parent != null) {
            return this._eliminate(parent, step);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(parent, step).toString());
    }

    @XbaseGenerated
    public Step substitute(Object owner, Step pre, Step post) {
        if (owner instanceof If && pre instanceof Check && post instanceof Check) {
            return this._substitute((If)owner, (Check)pre, (Check)post);
        }
        if (owner instanceof If && pre != null && post != null) {
            return this._substitute((If)owner, pre, post);
        }
        if (owner instanceof Sequence && pre != null && post != null) {
            return this._substitute((Sequence)owner, pre, post);
        }
        if (owner instanceof EObject && pre instanceof Check && post instanceof Check) {
            return this._substitute((EObject)owner, (Check)pre, (Check)post);
        }
        if (owner != null && pre != null && post != null) {
            return this._substitute(owner, pre, post);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(owner, pre, post).toString());
    }

    @XbaseGenerated
    public boolean empty(Step seq) {
        if (seq instanceof Sequence) {
            return this._empty((Sequence)seq);
        }
        if (seq != null) {
            return this._empty(seq);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(seq).toString());
    }

    @XbaseGenerated
    public boolean substituteCall(EObject owner, Call pre, Step post) {
        if (owner instanceof HistoryEntry) {
            return this._substituteCall((HistoryEntry)owner, pre, post);
        }
        if (owner instanceof If) {
            return this._substituteCall((If)owner, pre, post);
        }
        if (owner instanceof Sequence) {
            return this._substituteCall((Sequence)owner, pre, post);
        }
        if (owner instanceof StateCase) {
            return this._substituteCall((StateCase)owner, pre, post);
        }
        if (owner != null) {
            return this._substituteCall(owner, pre, post);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(owner, pre, post).toString());
    }

    @XbaseGenerated
    public Step stepCopy(Step cref) {
        if (cref instanceof CheckRef) {
            return this._stepCopy((CheckRef)cref);
        }
        if (cref instanceof Call) {
            return this._stepCopy((Call)cref);
        }
        if (cref instanceof HistoryEntry) {
            return this._stepCopy((HistoryEntry)cref);
        }
        if (cref instanceof If) {
            return this._stepCopy((If)cref);
        }
        if (cref instanceof Sequence) {
            return this._stepCopy((Sequence)cref);
        }
        if (cref instanceof StateSwitch) {
            return this._stepCopy((StateSwitch)cref);
        }
        if (cref != null) {
            return this._stepCopy(cref);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(cref).toString());
    }
}

