/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.ui.internal.utils;

import com.yakindu.licmgmt.internal.utils.LicenseHelper;
import com.yakindu.licmgmt.ui.AbstractLicenseFeature;
import com.yakindu.licmgmt.ui.internal.LicenseManagementUiActivator;
import com.yakindu.licmgmt.ui.internal.dialogs.ImportLicenseDialog;
import com.yakindu.licmgmt.ui.internal.utils.EclipseLicenseHelper;
import com.yakindu.licmgmt.utils.LicenseUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class LicenseUiHelper
extends LicenseHelper {
    public static boolean importLicense(Shell shell) {
        ImportLicenseDialog dialog = new ImportLicenseDialog(shell);
        int result = dialog.open();
        if (result == 0) {
            String copyResult = LicenseUtils.copyLicense((String)dialog.getLicensePath(), (String)dialog.getTargetPath());
            if (copyResult != null) {
                LicenseManagementUiActivator.logErrorMessage(copyResult);
            } else {
                File file = new File(dialog.getLicensePath());
                EclipseLicenseHelper.INSTANCE.acquireImportedLicenses(shell, String.valueOf(dialog.getTargetPath()) + File.separator + file.getName());
                return true;
            }
        }
        return false;
    }

    public static void createDiagnosticFile(Shell shell) {
        boolean withHostIds = MessageDialog.openQuestion((Shell)shell, (String)"Include Host IDs in license diagnostics?", (String)"Should the license diagnostic information contain Host ID information?");
        String infos = LicenseUiHelper.getSupportInfosWithProgressDialog(shell, withHostIds);
        if (infos == null) {
            return;
        }
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setFileName("yakindu-license-diagnostics.txt");
        dialog.setText("Save the license diagnostics result");
        String filePath = dialog.open();
        if (filePath != null) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (PrintWriter out = new PrintWriter(filePath);){
                    out.print(infos);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException e1) {
                MessageDialog.openError((Shell)shell, (String)"Failed to save file", (String)("Failed to save file: " + e1.getMessage()));
            }
        }
    }

    private static String getSupportInfosWithProgressDialog(Shell shell, boolean includeHostIds) {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        try {
            ArrayList result = new ArrayList(1);
            dialog.run(true, true, monitor -> {
                boolean bl2 = result.add(LicenseUiHelper.getSupportInfos((boolean)includeHostIds, LicenseUiHelper::getAllYakinduLicenseFeatures, (IProgressMonitor)monitor));
            });
            return result.isEmpty() ? null : (String)result.get(0);
        }
        catch (InvocationTargetException e) {
            String msg = "Failed to get diagnose information";
            Status status = new Status(4, "com.yakindu.licmgmt.ui", "Failed to get diagnose information", (Throwable)e);
            LicenseManagementUiActivator.getDefault().getLog().log((IStatus)status);
            MessageDialog.openError((Shell)shell, (String)"Failed to get diagnose information", (String)("Failed to get diagnose information: " + e.getMessage() + "\nSee Error Log for details."));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    private static List<String> getAllYakinduLicenseFeatures() {
        ArrayList<String> licenseFeatureNames = new ArrayList<String>();
        if (LicenseManagementUiActivator.getDefault() != null) {
            List<AbstractLicenseFeature> licenseFeatures = LicenseManagementUiActivator.getDefault().getLicenseFeatures();
            for (AbstractLicenseFeature licenseFeature : licenseFeatures) {
                String featureAndProductName = EclipseLicenseHelper.INSTANCE.getFeatureAndProductName(licenseFeature);
                String featureId = licenseFeature.getLicenseFeatureId();
                String licenseVersion = licenseFeature.getMinimalRequiredLicenseVersion();
                String info = String.format("%s (%s %s)", featureAndProductName, featureId, licenseVersion);
                licenseFeatureNames.add(info);
            }
        }
        return licenseFeatureNames;
    }
}

