/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.core.debug.communication;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.mwe.internal.core.debug.communication.Connection;
import org.eclipse.emf.mwe.internal.core.debug.communication.packages.AbstractPackage;

public class PackageSender
implements Runnable {
    private final ArrayList<AbstractPackage> outgoingPackages;
    private static final Log logger = LogFactory.getLog(PackageSender.class);
    private final Connection connection;
    private boolean interrupt = false;

    public static PackageSender newPackageSender(Connection connection) {
        PackageSender sender = new PackageSender(connection);
        Thread thread = new Thread((Runnable)sender, "PackageSender");
        thread.setDaemon(true);
        thread.start();
        return sender;
    }

    private PackageSender(Connection connection) {
        this.connection = connection;
        this.outgoingPackages = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendPackage(AbstractPackage packet) throws InterruptedIOException {
        if (!this.connection.isConnected()) {
            throw new InterruptedIOException();
        }
        ArrayList<AbstractPackage> arrayList = this.outgoingPackages;
        synchronized (arrayList) {
            this.outgoingPackages.add(packet);
            this.outgoingPackages.notifyAll();
        }
        return packet.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.interrupt = true;
        ArrayList<AbstractPackage> arrayList = this.outgoingPackages;
        synchronized (arrayList) {
            this.outgoingPackages.notifyAll();
        }
    }

    @Override
    public void run() {
        while (!this.interrupt && this.connection.isConnected()) {
            try {
                this.sendAvailablePackages();
            }
            catch (Exception e) {
                if (!(e instanceof IOException)) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                this.interrupt = true;
            }
        }
        this.connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendAvailablePackages() throws IOException {
        ArrayList<AbstractPackage> packagesToSend;
        block9: {
            packagesToSend = new ArrayList<AbstractPackage>();
            ArrayList<AbstractPackage> arrayList = this.outgoingPackages;
            synchronized (arrayList) {
                while (true) {
                    while (true) {
                        if (this.interrupt || !this.outgoingPackages.isEmpty()) {
                            packagesToSend.addAll(this.outgoingPackages);
                            this.outgoingPackages.clear();
                            break block9;
                        }
                        try {
                            this.outgoingPackages.wait();
                        }
                        catch (InterruptedException e) {
                            this.interrupt = true;
                        }
                    }
                    break;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        for (AbstractPackage packet : packagesToSend) {
            this.connection.writePackage(packet);
        }
    }
}

