/**
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
* 
* Contributors:
* 	Finlay Weegen - itemis AG
*
*/

package com.yakindu.sct.model.sgraph.util

import com.yakindu.sct.model.sgraph.CompositeElement
import com.yakindu.sct.model.sgraph.Region
import com.yakindu.sct.model.sgraph.SGraphFactory
import com.yakindu.sct.model.sgraph.Vertex

class StatechartBuilder {

	extension SGraphFactory factory = SGraphFactory.eINSTANCE 

	def _statechart() {
		createStatechart
	}
	
	def _statechart(String name) {
		createStatechart => [
			it.name = name 
		]
	}

	def _region(CompositeElement it, String regionName) {
		var region = createRegion => [
			name = regionName
		]
		it.regions += region
		region
	}

	def _state(Region it, String stateName) {
		var state = createState => [
			name = stateName
		]
		it.vertices += state
		state
	}

	def _entryNode(Region region, String entryNodeName) {
		var entryNode = createEntry => [
			name = entryNodeName
			parentRegion = region
		]
		region.vertices += entryNode
		entryNode
	}

	def _exitNode(Region region, String exitNodeName) {
		var exitNode = createExit => [
			name = exitNodeName
			parentRegion = region
		]
		region.vertices += exitNode
		exitNode
	}

	def _finalState(Region it) {
		var finalState = createFinalState
		it.vertices += finalState
		finalState
	}

	def _choice(Region it) {
		var choice = createChoice
		it.vertices += choice
		choice
	}

	def _synchronization(Region it) {
		var sync = createSynchronization
		it.vertices += sync
		sync
	}

	def _transition(Vertex it, Vertex targetVertex, String transitionName) {
		var transition = createTransition => [
			target = targetVertex
		]
		it.outgoingTransitions += transition
		transition
	}
}
