/**
 * Copyright (c) 2021 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.extensions

import com.google.inject.Inject
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgen.GeneratorModel
import com.yakindu.sct.model.sgraph.Statechart
import org.eclipse.xtext.EcoreUtil2

class GeneratorEntryProvider {
	
	@Inject protected extension SExecExtensions
	@Inject protected GeneratorEntry contextEntry
	
	/**
	 * Finds the generator entry corresponding to given statechart in the generator model of contextEntry.
	 */
	def getEntry(Statechart statechart) {
		val GeneratorModel model = EcoreUtil2.getContainerOfType(contextEntry, GeneratorModel)
		return model.entries.findFirst[e | e.elementRef.eResource.URI == statechart?.eResource.URI] ?: contextEntry
	}
	
	def getEntry(ExecutionFlow flow) {
		return getEntry(flow.statechart)
	}

}