/**
 * Copyright (c) 2022-2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * 	Axel Terfloth - itemis AG
 * 
 */
package com.yakindu.sctunit.generator.java.extensions

import com.google.inject.Inject
import com.yakindu.base.base.NamedElement
import com.yakindu.base.expressions.expressions.ArgumentExpression
import com.yakindu.base.expressions.expressions.AssignmentExpression
import com.yakindu.base.expressions.expressions.AssignmentOperator
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.EventRaisingExpression
import com.yakindu.base.expressions.expressions.EventValueReferenceExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.EnumerationType
import com.yakindu.base.types.Enumerator
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Operation
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.model.sgraph.util.StatechartUtil
import com.yakindu.sct.model.stext.stext.ActiveStateReferenceExpression
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sctunit.generator.base.extensions.BaseExpressionExtensions
import com.yakindu.sctunit.sCTUnit.EnterExpression
import com.yakindu.sctunit.sCTUnit.ExitExpression
import com.yakindu.sctunit.sCTUnit.ProceedExpression
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.sCTUnit.StatechartActiveExpression
import com.yakindu.sctunit.sCTUnit.StatechartFinalExpression
import com.yakindu.sctunit.sCTUnit.TriggerWithoutEventExpression
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.EcoreUtil2
import com.yakindu.base.types.Property
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.types.resource.Statechart2TypeTransformation
import com.yakindu.sct.model.stext.stext.VariableDefinition

/**
 * 
 * @author andreas muelder - Initial contribution and API
 * @author axel terfloth - additional features
 * 
 */
class JavaExpressionExtensions extends BaseExpressionExtensions {

	@Inject extension StatechartUtil
	@Inject extension Naming
	@Inject extension INamingService
	@Inject extension SCTUnitJavaNaming
	@Inject extension Statechart2TypeTransformation
	
	def dispatch CharSequence code(EventValueReferenceExpression exp) {
		'''«exp.value.context»get«exp.value.referenceName.toFirstUpper»Value()'''
	}

	override dispatch CharSequence code(EventRaisingExpression exp) {
		'''«exp.event.context»raise«exp.event.referenceName.toFirstUpper»(«exp.value.code»)'''
	}

	override dispatch CharSequence code(ActiveStateReferenceExpression it) {
		'''«context»isStateActive(«stateAccess»)'''
	}
	
	def private stateAccess(ActiveStateReferenceExpression it) {
		'''«statemachineType».State.«value.stateName»'''
	} 
	
	def private statemachineType(Expression exp) {
		EcoreUtil2.getContainerOfType(exp, typeof(SCTUnitClass)).statechart.statemachineClassName
	}

	override generateNotLocalElemRefExpr(ElementReferenceExpression it) {
		'''«context»«reference.valueGetter»()'''
	}

	override CharSequence generateNotLocalAssignment(AssignmentExpression it) {
		if (AssignmentOperator.ASSIGN.equals(operator))
			'''«varRef.context»«varRef.valueSetter»(«expression.code»)'''
		else
			'''«varRef.context»«varRef.valueSetter»(«varRef.code» «operator.toString» «expression.code»)'''
	}

	override dispatch CharSequence code(FeatureCall fc) {
		'''«fc.context»«codeDeclaration(fc.feature as Declaration, fc)»'''
	}
	
	def dispatch CharSequence context(ElementReferenceExpression it) {
		if (reference.isStatechartLocal) {
			val scope = reference.eContainer
			if (scope instanceof InterfaceScope && !(scope as InterfaceScope).name.nullOrEmpty) {
				return '''statemachine.«scope.valueGetter»().'''
			} else {
				return '''statemachine.'''
			}
		}
		return ''''''
	}
	
	def dispatch CharSequence context(FeatureCall it) {
		if (feature instanceof EnumerationType) {
			''''''
		} else if (feature.isChildState) {
			'''«(feature.eContainer as EnumerationType).codeDeclaration(it)».'''
		} else {
			'''«owner.code».'''
		}
	}
	
	def protected isChildState(EObject feature) {
		feature instanceof Enumerator && feature.eContainer.isOriginStateEnum
	}
	
	def dispatch CharSequence context(Expression it) '''statemachine.'''
	
	def dispatch CharSequence codeDeclaration(Declaration decl, ArgumentExpression exp) {
		'''«decl.valueGetter»()'''
	}
	
	def dispatch CharSequence codeDeclaration(VariableDefinition decl, ArgumentExpression exp) {
		'''«decl.valueGetter»()'''
	}
	
	def dispatch CharSequence codeDeclaration(Property decl, ArgumentExpression exp) {
		if (!decl.eContainer.isStatechartType && !decl.eContainer.isStatechartStateEnum && ! decl.eContainer.isInNamedIface)
			'''«decl.name.asEscapedIdentifier»'''
		else 
			'''«decl.valueGetter»()'''
	}
	
	def dispatch CharSequence codeDeclaration(EnumerationType decl, ArgumentExpression exp) {
		val statechart = decl.getOriginStatechart
		if (statechart !== null) {
			'''«statechart.statemachineClassName».State'''
		} else {
			decl.referenceName
		}
	}
	
	def dispatch CharSequence codeDeclaration(Enumerator it, ArgumentExpression exp) {
		if (eContainer.isOriginStateEnum) {
			return if (originState === null) nullStateName else originState.stateName
		}
		return referenceName
	}
	
	def dispatch CharSequence codeDeclaration(Operation op, ArgumentExpression exp) {
		'''«op.name»(«FOR arg : exp.expressions SEPARATOR ", "»«arg.code»«ENDFOR»)'''
	}
	
	override dispatch CharSequence code(StatechartActiveExpression exp) '''«exp.context»isActive()'''

	override dispatch CharSequence code(StatechartFinalExpression exp) '''«exp.context»isFinal()'''
	
	def dispatch CharSequence code(TriggerWithoutEventExpression exp) '''«exp.context»triggerWithoutEvent()'''

	def dispatch CharSequence code(EnterExpression exp) '''«exp.context»enter()'''

	def dispatch CharSequence code(ExitExpression exp) '''«exp.context»exit()'''
	
		
	override CharSequence proceedCycles(ProceedExpression it) '''timer.cycleLeap(«value.code»);'''

	override CharSequence proceedTime(ProceedExpression it) '''timer.timeLeap(«value.toMilliseconds(unit).code»);'''
	
	
	def dispatch String referenceName(NamedElement it) { name }
	
}
