/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java.submodules

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.sct.generator.java.GeneratorPredicate
import com.yakindu.sct.generator.java.GenmodelEntries
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations
import com.yakindu.sct.model.stext.stext.InterfaceScope

@Singleton
class InterfaceFunctionsGenerator {
	
	@Inject extension Naming
	@Inject extension SExecExtensions
	@Inject extension EventCode
	@Inject extension VariableCode
	@Inject extension OperationCallbackCode
	@Inject extension ShadowEventExtensions
	@Inject extension StatechartAnnotations
	@Inject extension GeneratorPredicate
	@Inject extension GenmodelEntries
	
	def interfaceClasses(ExecutionFlow it, GeneratorEntry entry) '''
		«FOR scope : flow.namedInterfaceScopes»
			«scope.toImplementation(entry)»
			
		«ENDFOR»
	'''
	
	def toImplementation(InterfaceScope scope, GeneratorEntry entry) '''
		public static class «scope.interfaceTypeName» {
			«IF scope.needsStatemachineReference(entry)»
				«scope.constructor»
			«ENDIF»
			«IF scope.hasOperations»
				«scope.generateOperationCallback»
			«ENDIF»
			«FOR event : scope.eventDefinitions»
				«generateEventDefinition(event, entry, scope)»
				
			«ENDFOR»
			«FOR variable : scope.variableDefinitions»
				«variable.code»
				
			«ENDFOR»
		}
	'''
	
	protected def constructor(InterfaceScope scope) '''
		private «scope.flow.statechart.statemachineClassName» «parentStatemachineInstance»;
		
		public «scope.interfaceTypeName»(«scope.flow.statechart.statemachineClassName» «parentStatemachineInstance») {
			this.«parentStatemachineInstance» = «parentStatemachineInstance»;
		}
	'''
	//TODO: Source this out
	def needsStatemachineReference(InterfaceScope scope, GeneratorEntry entry) {
		(scope.flow.statechart.isEventDriven && scope.hasIncomingEvents) || 
		scope.variableDefinitions.exists[needsShadowEventMapping] || 
		needsSynchronized ||
		(entry.tracingGeneric && scope.eventAndVariableDefinitions.size > 0) ||
		scope.outgoingEvents.exists[getLocalOutEvent() !== null]
	}
}