/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.sunit.generator.csharp.nunit.codemodel
/**
 * This extension defines the state machine class. 
 * 
 * @author axel terfloth - Initial contribution.
 */

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.csharp.codemodel.CsharpClass
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypeSpecifier
import com.yakindu.base.expressions.ExpressionBuilder

@Singleton
class NUnitClass {
	
	@Inject protected extension TypeBuilder
	@Inject protected extension ExpressionBuilder
	@Inject protected extension CsharpClass
	
			
	def _nunitClass(String name) {
		
		_public(_csharpClass(name)) => [
			_no_namespace
			_annotate(NUnitAnnotations.NUNIT_TEST_FIXTURE)
		]
	}	
		
	def _nunitTest(String name, TypeSpecifier returnType) {
		
		_public(_csharpMethod(name, returnType)) => [
			_annotate(NUnitAnnotations.NUNIT_TEST)
		]
		
	}
	
	def _nunitSetUp(String name, TypeSpecifier returnType) {
		
		_public(_csharpMethod(name, returnType)) => [
			_annotate(NUnitAnnotations.NUNIT_SETUP)
		]
		
	}
	
	def _nunitTearDown(String name, TypeSpecifier returnType) {
		
		_public(_csharpMethod(name, returnType)) => [
			_annotate(NUnitAnnotations.NUNIT_TEAR_DOWN)
		]
		
	}	
}
