/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * 
 */
package com.yakindu.sct.generator.scxml.modifications

import com.google.inject.Inject
import java.util.List
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.util.EcoreUtil
import com.yakindu.base.expressions.util.ExpressionExtensions
import com.yakindu.base.types.Property
import com.yakindu.sct.model.sgraph.Region
import com.yakindu.sct.model.sgraph.State
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.stext.stext.InternalScope
import com.yakindu.sct.model.stext.stext.StextFactory
import com.yakindu.sct.model.stext.stext.SubmachineReferenceExpression
import static extension com.yakindu.sct.model.sgraph.util.SubchartDFS.*

/**
 * 
 * @author andreas muelder - Initial contribution and API
 * 
 */
class SubmachineModification implements IModification {

	@Inject
	extension ExpressionExtensions

	override modify(Statechart statechart) {
		statechart.eAllContents.filter(State).filter(state|state.submachineDefinitions.length > 0).forEach [
			expandSubmachine(statechart)
		]
	}

	def expandSubmachine(State state, Statechart statechart) {
		mergeDataModel(state, statechart)
		mergeRegions(state, statechart)
	}

	def mergeRegions(State state, Statechart statechart) {
		state.submachineDefinitions.forEach [ submachine |
			(submachine.featureOrReference as Property).statechart.regions.forEach [ region |
				val clone = region.clone as Region
				state.regions += clone
			]
		]
	}

	protected def void mergeDataModel(State state, Statechart statechart) {
		val List<EObject> result = newArrayList
		state.submachineDefinitions.forEach [ submachine |
			(submachine.featureOrReference as Property).statechart.scopes.map[members].flatten.forEach [ member |
				result += member.clone
			]
		]
		state.internalScope.members += result
	}

	def clone(EObject it) {
		EcoreUtil.copy(it)
	}

	def protected getSubmachineDefinitions(State state) {
		state.scopes.map[members].flatten.filter(SubmachineReferenceExpression).map[submachine]
	}

	def protected getInternalScope(State it) {
		scopes.findFirst[it instanceof InternalScope] ?: {
			val internalScope = StextFactory.eINSTANCE.createInternalScope
			scopes += internalScope
			internalScope
		}
	}

}
