/**
 * Copyright (c) 2021-2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.core.codemodel

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.core.codepattern.IVariableCode
import com.itemis.create.base.generator.core.concepts.Documentation
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.types.TypeBuilder
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.ExecutionState
import com.yakindu.sct.model.sexec.naming.INamingService

/**
 * Defines class members which provide meta information about the state machines states. 
 * 
 * @author axel terfloth - Initial contribution.
 */
@Singleton class StateMetaInformation {
	
	public static final String STATE_COUNT_CONST_NAME = "numStates"

	@Inject protected extension TypeBuilder
	@Inject protected extension ExpressionBuilder
	@Inject protected extension StatemachineClass
	@Inject protected extension Documentation
	
	@Inject protected extension GeneratorAssignment
	@Inject protected extension IVariableCode
	@Inject protected extension INamingService
	
	def defineStateMetaInformation(ExecutionFlow flow) {
		
		val smClass = flow.stateMachineClass
		
		smClass.features += _variable(STATE_COUNT_CONST_NAME, _integer) => [
			documentation("The number of states.")
			_public
			const = true
			static = true
			initialValue = flow.states.size._integer
			generateDeclarationWith[ variableDeclarationCode ]
			
		]
		
		
		flow.states.forEach[ state |
			
			smClass.features += _variable(state.stateVectorDefine, _integer) => [
				_public
				const = true
				static = true
				initialValue = state.stateVector.offset._integer
				generateDeclarationWith[ variableDeclarationCode ]
			]
		]
	}
	
	def String stateVectorDefine(ExecutionState it) {
		'''scvi_«shortName»'''
	}
	
}