/**
 * Copyright (c) 2023-2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.core.extensions

import com.google.inject.Inject
import com.google.inject.Provider
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.types.Enumerator
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.sct.generator.core.execution.FlowOptimizerFactory
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.transformation.IModelSequencer
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.sgraph.util.StatechartUtil
import java.util.HashSet
import java.util.Set
import org.eclipse.emf.ecore.EObject

/**
 * @author Axel Terfloth - Initial contribution.
 */
class CodeModelGeneratorExtension {
	
	@Inject Provider<IModelSequencer> sequencerProvider;
	@Inject protected extension ICodeModel
	@Inject protected extension StatechartUtil
	@Inject protected extension SExecExtensions
	@Inject FlowOptimizerFactory optimizerFactory;
	
	def defineClass(ExecutionFlow it, GeneratorEntry entry){
		
		extension val optimizer = optimizerFactory.create(entry);

		defineImplementationClass

		flow.statechart.referencedStatecharts.forEach[ 
			extension val sequencer = sequencerProvider.get
			
			transform
			.optimize
		]
	}
	
	def referencedStatecharts(EObject it) {
		val Set<Statechart> resultSet = new HashSet
		
		eAllContents.forEach[collectReferencedStatecharts(resultSet)]
		
		return resultSet
	}
	
	
	def protected dispatch void collectReferencedStatecharts(EObject it, Set<Statechart> resultSet) {}


	def protected dispatch void collectReferencedStatecharts(TypedDeclaration it, Set<Statechart> resultSet) {
		type.collectReferencedStatecharts(resultSet)
	}
	
	def protected dispatch void collectReferencedStatecharts(ElementReferenceExpression it, Set<Statechart> resultSet) {
		reference.collectReferencedStatecharts(resultSet)
	}
	
	def protected dispatch void collectReferencedStatecharts(FeatureCall it, Set<Statechart> resultSet) {
		feature.collectReferencedStatecharts(resultSet)
	}
	
	def protected dispatch void collectReferencedStatecharts(Enumerator it, Set<Statechart> resultSet) {
		eContainer.collectReferencedStatecharts(resultSet)
	}
	
	def protected dispatch void collectReferencedStatecharts(Type it, Set<Statechart> resultSet) {
		it.getOriginStatechart.collectReferencedStatecharts(resultSet)
	}	
	
	def protected dispatch void collectReferencedStatecharts(Statechart it, Set<Statechart> resultSet) {
		resultSet += it
	}
	
	def protected dispatch void collectReferencedStatecharts(Void it, Set<Statechart> resultSet) {}
	
	
}