/**
 * Copyright (c) 2016 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Robert Rudi - itemis AG
 *  Robin Herrmann - itemis AG
 * 
 */

package com.yakindu.sctunit.generator.scxml.qt.files

import com.google.inject.Inject
import com.yakindu.sctunit.generator.base.extensions.BaseNavigationExtensions
import com.yakindu.sctunit.generator.scxml.qt.extensions.QtStatementExtensions
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation
import org.eclipse.xtext.generator.IFileSystemAccess
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sctunit.generator.scxml.qt.extensions.QtNamingExtensions

class TestClassSource {
	@Inject extension BaseNavigationExtensions
	@Inject extension QtNamingExtensions
	@Inject extension ICodegenTypeSystemAccess
	@Inject extension QtStatementExtensions

	protected GeneratorEntry entry

	def generate(GeneratorEntry it, IFileSystemAccess fsa) {
		var sctUnitElement = SCTUnitElement
		if (!(sctUnitElement instanceof SCTUnitClass)) {
			return
		}
		var it = sctUnitElement as SCTUnitClass

		generate(fsa)
	}

	def generate(SCTUnitClass it, IFileSystemAccess fsa) {
		fsa.generateFile(filename, content)
	}

	def filename(SCTUnitClass it) {
		'''QtSCTUnit/src/«testClassName.toLowerCase.cpp»'''.toString
	}

	def content(SCTUnitClass it) {
		'''
			#include "«testClassName.h.toLowerCase»"
			
			void «testClassName»::init(){
				sm = QSharedPointer<«statechart.name»>::create();
				AbstractQtUnitTest::init(sm);
			}
			
			«FOR operation : SCTUnitOperations.filter[!ignore]»
				«operation.type.targetLanguageName» «testClassName»::«operation.name»(«generateParameter(operation)»)
				{
					«IF operation.isTest»
						init();
					«ENDIF»
					«FOR statement : operation.body.code»
						«statement.generate»
					«ENDFOR»
				}
			«ENDFOR»
		'''
	}

	def generateParameter(SCTUnitOperation it) {
		'''«FOR param : parameters SEPARATOR ', '»«param.type.targetLanguageName» «param.name»«»«ENDFOR»'''
	}
}
