/**
 * Copyright (c) 2016 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Thomas Kutz - itemis AG
 * 
 */
package com.yakindu.sct.domain.c.runtime.exec

import com.google.inject.Inject
import com.yakindu.base.expressions.interpreter.context.DefaultExecutionSlotResolver
import com.yakindu.base.types.Property
import com.yakindu.base.types.Type
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.generator.c.typesystem.CTypeSystem
import com.yakindu.sct.model.sruntime.CompositeSlot
import com.yakindu.sct.model.sruntime.ExecutionSlot
import com.yakindu.sct.model.sruntime.ReferenceSlot

class CExecutionSlotResolver extends DefaultExecutionSlotResolver {

	@Inject ITypeSystem ts

	override protected dispatch ExecutionSlot resolveByFeature(CompositeSlot slot, Property feature) {

		if (feature.eContainer instanceof Type &&
			ts.isSame(feature.eContainer as Type, ts.getType(CTypeSystem.POINTER)) &&
			feature.getName == CTypeSystem.POINTER_VALUE_PROPERTY) {

			// this property is 'value' property from pointer type, so just return this slot
			return (slot as ReferenceSlot).reference
		}
		
		return super._resolveByFeature(slot, feature)
	}
}
