package com.yakindu.sct.domain.scxml.scoping

import com.google.common.collect.Lists
import com.google.inject.Inject
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Property
import com.yakindu.base.types.TypesFactory
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.model.sgraph.Region
import com.yakindu.sct.model.sgraph.RegularState
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.stext.naming.StextNameProvider
import com.yakindu.sct.model.stext.scoping.STextScopeProvider
import java.util.List
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.EReference
import org.eclipse.emf.ecore.resource.impl.ResourceImpl
import org.eclipse.xtext.EcoreUtil2
import org.eclipse.xtext.resource.impl.EObjectDescriptionLookUp
import org.eclipse.xtext.scoping.IScope
import org.eclipse.xtext.scoping.Scopes
import org.eclipse.xtext.scoping.impl.ImportNormalizer
import org.eclipse.xtext.scoping.impl.ImportScope
import org.eclipse.xtext.scoping.impl.SimpleScope

class SCXMLScopeProvider extends STextScopeProvider {

	extension TypesFactory = TypesFactory.eINSTANCE
	@Inject ITypeSystem ts
	var Property eventData
	var ComplexType math
	val resource = new ResourceImpl
	@Inject StextNameProvider delegate

	def getTypes() {
		if (resource.contents.empty) {
			math = TypesFactory.eINSTANCE.createComplexType => [
				name = "Math"
				visible = false

				features += createOperation => [
					name = "floor"
					static = true

					typeSpecifier = createTypeSpecifier => [
						type = ts.getType(ITypeSystem.REAL);
					]
				]
			]
			val eventType = createComplexType => [
				name = "Event"
				abstract = true
				visible = false
				features += createProperty => [
					name = "data"
					typeSpecifier = createTypeSpecifier => [
						type = ts.getType(ITypeSystem.ANY);
					]

				]
			]
			eventData = TypesFactory.eINSTANCE.createProperty => [
				name = "_event"
				typeSpecifier = TypesFactory.eINSTANCE.createTypeSpecifier => [
					type = eventType
				]
			]
			resource.contents += eventType;
			resource.contents += eventData;
			resource.contents += math;
		}
		return resource.contents
	}

	override scope_ElementReferenceExpression_reference(EObject context, EReference reference) {
		val parent = super.scope_ElementReferenceExpression_reference(context, reference)
		return new SimpleScope(parent, Scopes.scopedElementsFor(types));
	}
	
	override IScope scope_ActiveStateReferenceExpression_value(EObject context, EReference reference) {
		var Statechart statechart = getStatechart(context)
		if(statechart === null) return IScope.NULLSCOPE
		var List<RegularState> allStates = EcoreUtil2.getAllContentsOfType(statechart, RegularState)
		var IScope scope = Scopes.scopeFor(allStates, delegate, IScope.NULLSCOPE)
		return new ImportScope(getActiveStateNormalizer(context), scope,
			new EObjectDescriptionLookUp(Lists.newArrayList(scope.getAllElements())), reference.getEReferenceType(),
			false)
	}

	override protected List<ImportNormalizer> getActiveStateNormalizer(EObject context) {
		val List<ImportNormalizer> normalizer = Lists.newArrayList(super.getActiveStateNormalizer(context))
		val statechart = getStatechart(context);
		statechart.eAllContents.filter(Region).forEach [ region |
			normalizer.add(new ImportNormalizer(delegate.getFullyQualifiedName(region), true, false))
			normalizer.add(new ImportNormalizer(delegate.getFullyQualifiedName(region).skipFirst(1), true, false))
			println(delegate.getFullyQualifiedName(region))
		]
		return normalizer
	}
}
