/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Axel Terfloth - itemis AG
 * 
 */
package com.yakindu.sctunit.generator.cpp.extensions

import com.yakindu.sctunit.generator.c.extensions.MockClassExtension
import com.google.inject.Inject
import java.util.Set
import com.yakindu.sctunit.sCTUnit.MockingStatement
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.base.types.Operation

/**
 * Contributes mock return expression code generator required for generating mock return expressions
 */
class CppMockClassExtension extends MockClassExtension {
	@Inject CppExpressions.MockReturn mockReturnCode
	
	override protected mockReturnExpressionsGenerator(){
		mockReturnCode
	}
	
	override protected generateMockClassPublicInstanceVariables(Operation op, Set<MockingStatement> mocks, SCTUnitClass testClass, boolean verify, boolean mockReturn) '''
		«testClass.testClassName»* owner;
		«super.generateMockClassPublicInstanceVariables(op, mocks, testClass, verify, mockReturn)»
		
		«op.operationMockClassName»(«testClass.testClassName»* owner) : 
			owner(owner)«IF mockReturn»,
			«op.mockBehaviorName»Default(0)«ENDIF»«IF verify»,
			callCount(0)«ENDIF»
			{}
	'''
	
	override protected declareOperationMockInstance(Operation it) '''
		«operationMockClassName»* «operationMockObjectName»;
	'''
	
}