/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	René Beckmann - itemis AG
 * 
 */
package com.yakindu.sctunit.generator.cpp.extensions

import com.google.inject.Inject
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.CppPointers
import com.yakindu.sct.generator.cpp.CppSpecifiers
import com.yakindu.sct.generator.cpp.types.CppTypes
import com.yakindu.sct.model.sexec.transformation.config.IFlowConfiguration
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations
import com.yakindu.sctunit.generator.c.CSCTUnitFileSystemAccessFactory
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import org.eclipse.xtext.generator.IFileSystemAccess

/**
 * 
 * @author René Beckmann - Initial contribution and API
 * @author Axel Terfloth
 * 
 */

class TimerService extends GTest {

	@Inject protected GeneratorEntry entry
	@Inject protected extension StatechartAnnotations
	@Inject protected extension IFlowConfiguration
	@Inject protected extension CppNaming
	@Inject protected extension CppTypes
	@Inject protected extension Literals
	@Inject protected extension CppSpecifiers
	@Inject protected extension CppPointers

	def generateTimerService(SCTUnitClass it, IFileSystemAccess fsa, String outletFolder) {
		var timerServiceFileName = '''«timerServiceFileName.cpp»'''.toString
		var content = generateTimerService
		fsa.generateFile(timerServiceFileName, CSCTUnitFileSystemAccessFactory.LIBRARY_TARGET_FOLDER_OUTPUT,content)
	}
	
	def protected tasksArraySize(SCTUnitClass it) {
		if (!statechart.isCycleBased && (timed || statechart.hasTimedSubmachines)) {
			'''maximal_parallel_time_events_'''
		} else if (statechart.isCycleBased && (timed || statechart.hasTimedSubmachines)) {
			'''maximal_parallel_time_events_ + 1'''
		} else if (statechart.isCycleBased) {
			'''1'''
		} else {
			0
		}
	}
	
	def protected initializeTasksArrayMember(SCTUnitClass it)'''
	tasks(«makeSharedPtr»«scTimerNS»::«timerServiceImplementationTask»[«tasksArraySize»]),
	'''
	
	def protected passTasksArray(SCTUnitClass it)'''tasks'''

	def protected generateTimerService(SCTUnitClass it) {
		'''
			/*
			 * Timer Service Implementation for SCTUnit
			 */
			
			#include "«timerServiceFileName.h»"
			
			/**
			 * Implementation of a timer service that uses _virtual_ time to raise time events.
			 * It is solely meant for use with sctunit.
			 */
			
			«timerServiceClass»::«timerServiceClass»(
					«IF statechart.isCycleBased»«sharedPtr»«scNS»::«statechart.statemachineInterfaceName» «pointerType» statemachine_,
					«sc_integer.fqName» cycle_period_«IF timed || statechart.hasTimedSubmachines», «ENDIF»
					«ENDIF»«IF timed || statechart.hasTimedSubmachines»size_t maximal_parallel_time_events_«ENDIF»
					)«IF statechart.isCycleBased || timed || statechart.hasTimedSubmachines» :
					«IF statechart.isCycleBased»statemachine(statemachine_),
					cycle_period(cycle_period_),
					remaining_time_in_cycle(cycle_period),
					«ENDIF»«initializeTasksArrayMember»
					timerServiceImplementation(«passTasksArray», «tasksArraySize»)
					«ENDIF»
			{
				«IF statechart.isCycleBased»
				timerServiceImplementation.setRuncycleTimerFor(statemachine«lockIfNecessary», cycle_period);
				«ENDIF»
			}
			
			void «timerServiceClass»::proceed_time(«sc_time.fqName» time_ms)
			{
				«IF statechart.isCycleBased || timed || statechart.hasTimedSubmachines»
				timerServiceImplementation.proceed(time_ms);
				«IF statechart.isCycleBased»
				if (remaining_time_in_cycle > time_ms) {
					remaining_time_in_cycle -= time_ms;
				} else {
					«sc_time.fqName» consumed_time_after_cycle = time_ms - remaining_time_in_cycle;
					remaining_time_in_cycle = cycle_period - (consumed_time_after_cycle % cycle_period);
				}
				«ENDIF»
				«ELSE»
				(void) time_ms;
				«ENDIF»
			}
			
			void «timerServiceClass»::proceed_cycles(«sc_integer.fqName» cycles)
			{
				«IF statechart.isCycleBased»
				for («sc_integer.fqName» elapsed_cycles = 0; elapsed_cycles < cycles; ++elapsed_cycles) {
					proceed_time(remaining_time_in_cycle);
				}
				«ELSE»
				(void) cycles;
				«ENDIF»
			}
			«IF timed || statechart.hasTimedSubmachines»
			void «timerServiceClass»::setTimer(«sharedPtr»«scTimerNS»::«timedInterface»«pointerType» statemachine_, «sc_eventid.fqName» event, «sc_time.fqName» time_ms, «sc_bool.fqName» isPeriodic)
			{
				timerServiceImplementation.setTimer(statemachine_, event, time_ms, isPeriodic);
			}
			
			void «timerServiceClass»::unsetTimer(«sharedPtr»«scTimerNS»::«timedInterface»«pointerType» statemachine_, «sc_eventid.fqName» event)«_noexcept»
			{
				timerServiceImplementation.unsetTimer(statemachine_, event);
			}
			«ENDIF»
			
			void «timerServiceClass»::cancel()«_noexcept»
			{
				«IF statechart.isCycleBased || timed || statechart.hasTimedSubmachines»
				timerServiceImplementation.cancel();
				«IF statechart.isCycleBased»
				remaining_time_in_cycle = 0;
				«ENDIF»
				«ENDIF»
			}
		'''
	}
}
