/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.providers

import com.google.inject.Inject
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.core.submodules.lifecycle.IsActive
import com.yakindu.sct.generator.core.submodules.lifecycle.IsFinal
import com.yakindu.sct.generator.core.submodules.lifecycle.IsStateActive
import com.yakindu.sct.generator.cpp.submodules.CheckFunction
import com.yakindu.sct.generator.cpp.submodules.InterfaceFunctions
import com.yakindu.sct.generator.cpp.submodules.InternalFunctions
import com.yakindu.sct.generator.cpp.submodules.TimingFunctions
import com.yakindu.sct.model.sexec.ExecutionFlow

class DefaultFunctionProvider implements ISourceFragment {
	@Inject protected extension IsActive
	@Inject protected extension IsFinal
	@Inject protected extension IsStateActive
	
	@Inject protected extension InternalFunctions
	@Inject protected extension InterfaceFunctions
	@Inject protected extension TimingFunctions
	@Inject protected extension CheckFunction
	
	override get(ExecutionFlow it, IGenArtifactConfigurations artifactConfigs) {
		'''
		«isActive»
		
		«isFinal»
		
		«checkFunction»
		
		«timedStatemachineFunctions»

		«isStateActive»
		
		«interfaceFunctions»
		
		«functionImplementations»
		'''
	}
	
}