/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11

import com.yakindu.base.types.EnumerationType
import com.yakindu.base.types.TypeAlias
import com.yakindu.sct.generator.core.codemodel.NamedInterfaceClasses
import com.yakindu.sct.generator.core.codemodel.StatemachineClass
import com.yakindu.sct.generator.cpp.providers.ConstructorProvider
import com.yakindu.sct.generator.cpp11.codemodel.EventQueueImplementation
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.stext.stext.StatechartScope
import com.yakindu.sct.model.stext.stext.VariableDefinition
import java.util.List
import com.google.inject.Inject
import org.eclipse.emf.ecore.EObject

/**
 * Redefines the constructor definition to be compatible with the C++11 code model.
 * This especially effects the selection and order of initialization list.
 * 
 * @author Axel Terfloth - initial contributon 
 */
class Cpp11ConstructorProvider extends ConstructorProvider {
	
	
	@Inject protected extension StatemachineClass 
	@Inject protected extension NamedInterfaceClasses 
	@Inject protected extension EventQueueImplementation eventQueueImplementation

	override constructorDefinition(ExecutionFlow it) {
		'''
			«module»::«module»()«propertyThrowsException»
			{
				«constructorBody(it)»
			}
		'''
	}
	override CharSequence constructorBody(ExecutionFlow it) '''
		«super.constructorBody(it)»
	'''
	
	override protected initialisationList(ExecutionFlow flow, StatechartScope it) {
		val List<Pair<String, String>> toInit = newArrayList	
		toInit.add('''«parentMember»''', '''«parentArgument»''')
		if(hasOperations && !entry.useStaticOPC){
			toInit.add(OCB_Instance, NULL_LITERAL)
		}

		return toInit
	}
	
	override destructorDefinition(ExecutionFlow it) '''
		«module»::~«module»()
		{
			«eventQueueImplementation.deleteEventQueues(it)»
		}
	'''
	
	def dispatch String fqName(EnumerationType it){
		if(!multiSM)
			asLiteral + "::"
	}
	
	def dispatch String fqName(TypeAlias it){
		if(originType instanceof EnumerationType)
			asLiteral + "::"
		else
			""
	}
	
	def dispatch String fqName(EObject it){""}
	
	override dispatch provideValue(VariableDefinition it) {
		if (initialValue !== null) {
			return initialValue.code.toString
		}
		type.fqName + type.value
	}
	
	override dispatch value(EnumerationType it) {
		if (multiSM) {
			return enumerator.head.stateEnumerator
		} 
		enumerator.head.access.toString
	}
	
}
