/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11.codemodel

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.core.codepattern.IMethodCode
import com.yakindu.sct.generator.core.codemodel.NamedInterfaceClasses
import com.yakindu.sct.generator.core.codemodel.StateEnum
import com.yakindu.sct.generator.core.codemodel.StateMetaInformation
import com.yakindu.sct.generator.core.codemodel.StatemachineClass
import com.yakindu.sct.generator.core.extensions.ICodeModel
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventQueue

/**
 * The code model is created from the executution flow and consist of type system based model elements.
 * These model elements represent concrete C++ implementation artifacts which represent different implementation
 * concepts 
 * 
 * @author axel terfloth
 *
 */
@Singleton class CodeModel implements ICodeModel{

	@Inject protected extension EventQueue
	
	@Inject protected extension StatemachineClass
	@Inject protected extension NamedInterfaceClasses
	@Inject protected extension StateEnum
	@Inject protected extension StateMetaInformation
	@Inject protected extension EventEnum
	@Inject protected extension EventInstanceClasses
	@Inject protected extension EventQueueImplementation
	@Inject protected extension EventAccessors
	@Inject protected extension GeneratorAssignment
	@Inject protected extension IMethodCode
	
	

	override defineImplementationClass(ExecutionFlow it) {
		it.implementationClass
	}
	
	def create i : flow.stateMachineClass implementationClass(ExecutionFlow flow) {
		
		flow.namedInterfaceClasses
		
		flow.defineStateEnum(flow.stateMachineClass)
		flow.defineStateMetaInformation
		
		if (flow.requiresEventQueue) {
			flow.defineEventEnum
			flow.defineEventInstanceClasses
			flow.defineEventQueueImplementation
		}
		
		flow.defineEventAccessors
				
	}
	
}