/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.navigator;

import com.yakindu.base.xtext.utils.jface.viewers.util.ActiveEditorTracker;
import com.yakindu.sct.ui.navigator.DomainNavigatorItem;
import com.yakindu.sct.ui.navigator.utils.ComposedAdapterFactoryUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.navigator.ILinkHelper;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class NavigatorLinkHelper
implements ILinkHelper {
    private AdapterFactoryContentProvider myAdapterFactoryContentProvier = new AdapterFactoryContentProvider((AdapterFactory)ComposedAdapterFactoryUtil.FACTORY);

    private static IEditorInput getEditorInput(Diagram diagram) {
        Resource diagramResource = diagram.eResource();
        if (diagramResource == null) {
            return null;
        }
        for (EObject nextEObject : diagramResource.getContents()) {
            if (nextEObject == diagram) {
                return new FileEditorInput(WorkspaceSynchronizer.getFile((Resource)diagramResource));
            }
            if (nextEObject instanceof Diagram) break;
        }
        URI uri = EcoreUtil.getURI((EObject)diagram);
        String editorName = uri.lastSegment() + "#" + diagram.eResource().getContents().indexOf((Object)diagram);
        URIEditorInput editorInput = new URIEditorInput(uri, editorName);
        return editorInput;
    }

    public IStructuredSelection findSelection(IEditorInput anInput) {
        Diagram diagram;
        IFile file;
        IEditorPart activeEditor = ActiveEditorTracker.getLastActiveEditor();
        if (activeEditor instanceof DiagramDocumentEditor && (file = WorkspaceSynchronizer.getFile((Resource)(diagram = ((DiagramDocumentEditor)activeEditor).getDiagram()).eResource())) != null) {
            DomainNavigatorItem item = new DomainNavigatorItem((EObject)diagram, file, (IPropertySourceProvider)this.myAdapterFactoryContentProvier);
            return new StructuredSelection((Object)item);
        }
        return StructuredSelection.EMPTY;
    }

    public void activateEditor(IWorkbenchPage aPage, IStructuredSelection aSelection) {
        if (aSelection == null || aSelection.isEmpty()) {
            return;
        }
        if (!(aSelection.getFirstElement() instanceof DomainNavigatorItem)) {
            return;
        }
        DomainNavigatorItem abstractNavigatorItem = (DomainNavigatorItem)((Object)aSelection.getFirstElement());
        View navigatorView = abstractNavigatorItem.getView();
        if (navigatorView == null) {
            return;
        }
        IEditorInput editorInput = NavigatorLinkHelper.getEditorInput(navigatorView.getDiagram());
        if (editorInput == null) {
            return;
        }
        IEditorPart editor = aPage.findEditor(editorInput);
        if (editor == null) {
            return;
        }
        aPage.bringToTop((IWorkbenchPart)editor);
        if (editor instanceof DiagramEditor) {
            DiagramEditor diagramEditor = (DiagramEditor)editor;
            ResourceSet diagramEditorResourceSet = diagramEditor.getEditingDomain().getResourceSet();
            EObject selectedView = diagramEditorResourceSet.getEObject(EcoreUtil.getURI((EObject)navigatorView), true);
            if (selectedView == null) {
                return;
            }
            GraphicalViewer graphicalViewer = (GraphicalViewer)diagramEditor.getAdapter(GraphicalViewer.class);
            EditPart selectedEditPart = (EditPart)graphicalViewer.getEditPartRegistry().get(selectedView);
            if (selectedEditPart != null) {
                graphicalViewer.select(selectedEditPart);
                graphicalViewer.reveal(selectedEditPart);
            }
        }
    }
}

