/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.generator.scxml.qt.files;

import com.google.inject.Inject;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sctunit.generator.base.extensions.BaseNavigationExtensions;
import com.yakindu.sctunit.generator.scxml.qt.extensions.QtNamingExtensions;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.SCTUnitElement;
import com.yakindu.sctunit.sCTUnit.SCTUnitSuite;
import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class TestRunner {
    @Inject
    @Extension
    private BaseNavigationExtensions _baseNavigationExtensions;
    @Inject
    @Extension
    private QtNamingExtensions _qtNamingExtensions;

    public void generate(GeneratorEntry entry, IFileSystemAccess fsa) {
        fsa.generateFile(this.filename(entry), this.content(entry));
    }

    public String filename(GeneratorEntry entry) {
        return "QtSCTUnit/src/testrunner.cpp";
    }

    public CharSequence content(GeneratorEntry entry) {
        StringConcatenation _xblockexpression = null;
        List<SCTUnitClass> classes = this.getClasses(this._baseNavigationExtensions.getSCTUnitElement(entry));
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#include <QtTest/QtTest>");
        _builder.newLine();
        _builder.append("#include \"abstractqtunittest.h\"");
        _builder.newLine();
        for (SCTUnitClass clazz : classes) {
            _builder.append("#include \"");
            String _lowerCase = this._qtNamingExtensions.h(this._qtNamingExtensions.testClassName((SCTUnitElement)clazz)).toLowerCase();
            _builder.append(_lowerCase);
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("int main(int argc, char *argv[])");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        for (SCTUnitClass clazz_1 : classes) {
            _builder.append("    ");
            String _testClassName = this._qtNamingExtensions.testClassName((SCTUnitElement)clazz_1);
            _builder.append(_testClassName, "    ");
            _builder.append(" ");
            String _firstLower = StringExtensions.toFirstLower((String)this._qtNamingExtensions.testClassName((SCTUnitElement)clazz_1));
            _builder.append(_firstLower, "    ");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("    ");
        _builder.append("QCoreApplication a(argc, argv);");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("int status = 0;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("auto test = [&status, argc, argv](QObject *obj) {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("status |= QTest::qExec(obj, argc, argv);");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("if(status != 0)");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("QFAIL(QString(\"Error while executing tests in %1\").arg(obj->objectName()).toStdString().c_str());");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("auto &suite = AbstractQtUnitTest::suite();");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("for (auto it = suite.begin(); it != suite.end(); ++it) {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("test(*it);");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("return status;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public List<SCTUnitClass> getClasses(SCTUnitElement element) {
        if (element instanceof SCTUnitSuite) {
            return IterableExtensions.toList((Iterable)this._baseNavigationExtensions.getSCTUnitClasses((SCTUnitSuite)element));
        }
        return CollectionLiterals.newArrayList((Object[])new SCTUnitClass[]{(SCTUnitClass)element});
    }
}

