/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.python.files;

import com.google.inject.Inject;
import com.yakindu.sct.generator.python.GenmodelEntries;
import com.yakindu.sct.generator.python.naming.Naming;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sexec.extensions.SExecExtensions;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;

public class PyPSetup {
    @Inject
    @Extension
    private GenmodelEntries _genmodelEntries;
    @Inject
    @Extension
    private Naming _naming;
    @Inject
    @Extension
    private SExecExtensions _sExecExtensions;

    public void generatePythonPackagingSetup(ExecutionFlow flow, GeneratorEntry entry, IFileSystemAccess fsa) {
        String _basePackagePath = this._genmodelEntries.getBasePackagePath(entry);
        String _plus = _basePackagePath + "/";
        String _py = this._naming.py("setup");
        String _plus_1 = _plus + _py;
        fsa.generateFile(_plus_1, this.contentSetupFile(flow, entry));
        String _basePackagePath_1 = this._genmodelEntries.getBasePackagePath(entry);
        String _plus_2 = _basePackagePath_1 + "/";
        String _plus_3 = _plus_2 + "MANIFEST.in";
        fsa.generateFile(_plus_3, this.contentManifest());
        String _basePackagePath_2 = this._genmodelEntries.getBasePackagePath(entry);
        String _plus_4 = _basePackagePath_2 + "/";
        String _plus_5 = _plus_4 + "LICENSE.txt";
        fsa.generateFile(_plus_5, this.contentLicense(entry));
        String _basePackagePath_3 = this._genmodelEntries.getBasePackagePath(entry);
        String _plus_6 = _basePackagePath_3 + "/";
        String _plus_7 = _plus_6 + "README.rst";
        fsa.generateFile(_plus_7, this.contentReadMe(flow));
    }

    private CharSequence contentSetupFile(ExecutionFlow flow, GeneratorEntry entry) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("from distutils.core import setup");
        _builder.newLine();
        _builder.newLine();
        _builder.append("with open('README.rst') as f:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("readme = f.read()");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("with open('LICENSE.txt') as f:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("license = f.read()");
        _builder.newLine();
        _builder.newLine();
        _builder.append("setup(");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("name = '");
        String _statemachineName = this._naming.statemachineName(flow);
        _builder.append(_statemachineName, "\t");
        _builder.append("',");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("version = '");
        String _pyPackageVersion = this._genmodelEntries.getPyPackageVersion(entry);
        _builder.append(_pyPackageVersion, "\t");
        _builder.append("',");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("author = '");
        String _pyPackageAuthor = this._genmodelEntries.getPyPackageAuthor(entry);
        _builder.append(_pyPackageAuthor, "\t");
        _builder.append("',");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("packages = [");
        String _lowerCase = this._naming.statemachineName(flow).toLowerCase();
        _builder.append(_lowerCase, "\t");
        _builder.append(",],");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#scripts = [],");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#url = ");
        String _pyPackageURL = this._genmodelEntries.getPyPackageURL(entry);
        _builder.append(_pyPackageURL, "\t");
        String _statemachineName_1 = this._naming.statemachineName(flow);
        _builder.append(_statemachineName_1, "\t");
        _builder.append("',");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("license = license,");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("description='");
        String _pyPackageDescription = this._genmodelEntries.getPyPackageDescription(entry);
        _builder.append(_pyPackageDescription, "\t");
        _builder.append("',");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("long_description = readme,");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#install_requires = [");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#\t\"django >= 1.1.1\",");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#\t\"caldav == 0.1.4\",");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#],");
        _builder.newLine();
        _builder.append(")");
        _builder.newLine();
        return _builder;
    }

    private CharSequence contentManifest() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("include *.txt");
        _builder.newLine();
        _builder.append("recursive-include docs *.txt");
        _builder.newLine();
        return _builder;
    }

    private CharSequence contentLicense(GeneratorEntry entry) {
        StringConcatenation _builder = new StringConcatenation();
        String _pyPackageLicense = this._genmodelEntries.getPyPackageLicense(entry);
        _builder.append(_pyPackageLicense);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence contentReadMe(ExecutionFlow flow) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("========");
        _builder.newLine();
        String _statemachineName = this._naming.statemachineName(flow);
        _builder.append(_statemachineName);
        _builder.newLineIfNotEmpty();
        _builder.append("========");
        _builder.newLine();
        _builder.newLine();
        _builder.append("Short description of your project / statemachine.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("Short description of usage:");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#!/usr/bin/env python");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("import ");
        String _lowerCase = this._naming.statemachineName(flow).toLowerCase();
        _builder.append(_lowerCase, "\t");
        _builder.newLineIfNotEmpty();
        boolean _isTimed = this._sExecExtensions.isTimed(flow);
        if (_isTimed) {
            _builder.append("\t");
            _builder.append("from ");
            String _lowerCase_1 = this._naming.statemachineName(flow).toLowerCase();
            _builder.append(_lowerCase_1, "\t");
            _builder.append(".timer import sct.timer ");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("Paragraphs are separated by blank lines. *Italic*, **bold**, and");
        _builder.newLine();
        _builder.append("``monospace`` look like this.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("A Section");
        _builder.newLine();
        _builder.append("=========");
        _builder.newLine();
        _builder.newLine();
        _builder.append("List look like this:");
        _builder.newLine();
        _builder.newLine();
        _builder.append("* First");
        _builder.newLine();
        _builder.newLine();
        _builder.append("* Second. Can be multiple lines");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("but must be indented properly.");
        _builder.newLine();
        _builder.append("  ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("A Sub-Section");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("-------------");
        _builder.newLine();
        _builder.append(" ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("Numbered lists look like you'd expect:");
        _builder.newLine();
        _builder.append(" ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("1. first");
        _builder.newLine();
        _builder.append(" ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("2. second");
        _builder.newLine();
        _builder.append(" ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("URLs are http://like.this and links can be");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("written `like this <http:// www.example.com/foo/bar>`_.");
        _builder.newLine();
        _builder.append(" ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("Contributers");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("============");
        _builder.newLine();
        _builder.append(" ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("name someone.");
        _builder.newLine();
        return _builder;
    }
}

