/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.python.files;

import com.google.inject.Inject;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.expressions.expressions.AssignmentExpression;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.types.Event;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.TypesUtil;
import com.yakindu.base.types.typesystem.ITypeValueProvider;
import com.yakindu.sct.generator.core.extensions.StringHelper;
import com.yakindu.sct.generator.core.filesystem.ISCTFileSystemAccess;
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper;
import com.yakindu.sct.generator.python.FlowCode;
import com.yakindu.sct.generator.python.GenmodelEntries;
import com.yakindu.sct.generator.python.InitialValueProvider;
import com.yakindu.sct.generator.python.PythonObservables;
import com.yakindu.sct.generator.python.PythonStatechartIncludeProvider;
import com.yakindu.sct.generator.python.files.PackageInit;
import com.yakindu.sct.generator.python.naming.Naming;
import com.yakindu.sct.generator.python.naming.PythonNamingService;
import com.yakindu.sct.generator.python.submodules.InternalFunctionsGenerator;
import com.yakindu.sct.generator.python.submodules.InternalTypes;
import com.yakindu.sct.generator.python.submodules.ScopeGenerator;
import com.yakindu.sct.generator.python.submodules.TimingFunctions;
import com.yakindu.sct.model.sexec.Execution;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sexec.ExecutionScope;
import com.yakindu.sct.model.sexec.ExecutionState;
import com.yakindu.sct.model.sexec.Sequence;
import com.yakindu.sct.model.sexec.Step;
import com.yakindu.sct.model.sexec.extensions.SExecExtensions;
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions;
import com.yakindu.sct.model.sexec.extensions.StateVectorExtensions;
import com.yakindu.sct.model.sgen.FeatureParameterValue;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sct.model.sgraph.Scope;
import com.yakindu.sct.model.stext.stext.InterfaceScope;
import com.yakindu.sct.model.stext.stext.InternalScope;
import com.yakindu.sct.model.stext.stext.StatechartScope;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class Statemachine {
    @Inject
    @Extension
    private Naming _naming;
    @Inject
    @Extension
    private PythonNamingService _pythonNamingService;
    @Inject
    @Extension
    private GenmodelEntries _genmodelEntries;
    @Inject
    @Extension
    private SExecExtensions _sExecExtensions;
    @Inject
    @Extension
    private StateVectorExtensions _stateVectorExtensions;
    @Inject
    @Extension
    private PythonObservables _pythonObservables;
    @Inject
    @Extension
    private ShadowEventExtensions _shadowEventExtensions;
    @Inject
    @Extension
    private InternalTypes _internalTypes;
    @Inject
    @Extension
    private InternalFunctionsGenerator _internalFunctionsGenerator;
    @Inject
    @Extension
    private ITypeValueProvider _iTypeValueProvider;
    @Inject
    @Extension
    private InitialValueProvider _initialValueProvider;
    @Inject
    @Extension
    private FlowCode _flowCode;
    @Inject
    @Extension
    private ICoreLibraryHelper _iCoreLibraryHelper;
    @Inject
    @Extension
    private ScopeGenerator _scopeGenerator;
    @Inject
    @Extension
    private TimingFunctions _timingFunctions;
    @Inject
    @Extension
    private StringHelper _stringHelper;
    @Inject
    @Extension
    private PackageInit _packageInit;
    @Inject
    @Extension
    protected TypesUtil _typesUtil;
    @Inject
    protected PythonStatechartIncludeProvider imports;
    @Inject
    protected GeneratorEntry entry;

    public void generateStatemachine(ExecutionFlow flow, GeneratorEntry entry, ISCTFileSystemAccess fsa) {
        boolean _not;
        CharSequence content = this.content(flow, entry, fsa);
        String path = this._genmodelEntries.getBasePackagePath(entry);
        String _py = this._naming.py(this._naming.statemachineClassName((Notifier)flow));
        String _plus = path + "/" + _py;
        fsa.generateFile(_plus, content);
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)path);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            this._packageInit.generatePyPackageInit((IFileSystemAccess)fsa, path, entry);
        }
    }

    protected CharSequence content(ExecutionFlow flow, GeneratorEntry entry, ISCTFileSystemAccess fsa) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\"\"\"Implementation of statechart ");
        String _statemachineClassName = this._naming.statemachineClassName((Notifier)flow);
        _builder.append(_statemachineClassName);
        _builder.append(".");
        _builder.newLineIfNotEmpty();
        String _licenseText = this._genmodelEntries.getLicenseText(entry);
        _builder.append(_licenseText);
        _builder.newLineIfNotEmpty();
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.newLine();
        CharSequence _imports = this.imports(flow, fsa);
        _builder.append((Object)_imports);
        _builder.newLineIfNotEmpty();
        CharSequence _observerClass = this._pythonObservables.observerClass(flow);
        _builder.append((Object)_observerClass);
        _builder.newLineIfNotEmpty();
        _builder.append("class ");
        String _statemachineName = this._naming.statemachineName(flow);
        _builder.append(_statemachineName);
        _builder.append(":");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\"\"\"Implementation of the state machine ");
        String _statemachineName_1 = this._naming.statemachineName(flow);
        _builder.append(_statemachineName_1, "\t");
        _builder.append(".");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _statesEnum = this.statesEnum(flow);
        _builder.append((Object)_statesEnum, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        String _internalTypes = this._internalTypes.internalTypes(flow);
        _builder.append(_internalTypes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _interfaceTypes = this.interfaceTypes(flow);
        _builder.append((Object)_interfaceTypes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _constructor = this.constructor(flow);
        _builder.append((Object)_constructor, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _isActiveFunction = this.isActiveFunction(flow);
        _builder.append((Object)_isActiveFunction, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _isFinalFunction = this.isFinalFunction(flow);
        _builder.append(_isFinalFunction, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _isStateActiveFunction = this.isStateActiveFunction(flow);
        _builder.append((Object)_isStateActiveFunction, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _timingFunctions = this._timingFunctions.timingFunctions(flow);
        _builder.append((Object)_timingFunctions, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _internalScopeFunctions = this.internalScopeFunctions(flow);
        _builder.append((Object)_internalScopeFunctions, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _interfaceScopeFunctions = this.interfaceScopeFunctions(flow);
        _builder.append((Object)_interfaceScopeFunctions, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _functionImplementations = this._internalFunctionsGenerator.functionImplementations(flow);
        _builder.append((Object)_functionImplementations, "\t");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence imports(ExecutionFlow it, ISCTFileSystemAccess fsa) {
        boolean _isNullOrEmpty;
        boolean _not;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        FeatureParameterValue _libraryTargetFolderValue = this._iCoreLibraryHelper.getLibraryTargetFolderValue(this.entry);
        boolean bl = _tripleNotEquals = _libraryTargetFolderValue != null;
        if (_tripleNotEquals) {
            _builder.append("import sys, os");
            _builder.newLine();
            _builder.append("sys.path.insert(0, os.path.abspath(os.path.join(os.path.dirname(__file__), '");
            String _relativeLibFolder = this.getRelativeLibFolder(fsa);
            _builder.append(_relativeLibFolder);
            _builder.append("')))");
            _builder.newLineIfNotEmpty();
        }
        if (this._iCoreLibraryHelper.getOutEventObservablesUsed(this.entry) && this._sExecExtensions.hasOutgoingEvents(it)) {
            _builder.append("from ");
            String _dot = this._stringHelper.dot(this._genmodelEntries.getLibraryPackage(this.entry), this._naming.rxpyModule());
            _builder.append(_dot);
            _builder.append(" import Observable");
            _builder.newLineIfNotEmpty();
        }
        boolean bl2 = _not = !(_isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)this._shadowEventExtensions.getShadowEvents(it)));
        if (_not) {
            _builder.append("from ");
            String _dot_1 = this._stringHelper.dot(this._genmodelEntries.getLibraryPackage(this.entry), this._naming.rxpyModule());
            _builder.append(_dot_1);
            _builder.append(" import Observer");
            _builder.newLineIfNotEmpty();
        }
        CharSequence _submachineImports = this.submachineImports(this._sExecExtensions.flow((EObject)it));
        _builder.append((Object)_submachineImports);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    protected String getRelativeLibFolder(ISCTFileSystemAccess fsa) {
        boolean _notEquals;
        boolean _not;
        String _xblockexpression = null;
        Path base = Paths.get(this._genmodelEntries.getBasePackagePath(this.entry), new String[0]);
        Object rel = "";
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this._genmodelEntries.getBasePackagePath(this.entry));
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            int _nameCount = base.getNameCount();
            Functions.Function1 _function = it -> "../";
            rel = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)new IntegerRange(1, _nameCount), (Functions.Function1)_function));
        }
        String defaultTarget = ((OutputConfiguration)fsa.getOutputConfigurations().get("DEFAULT_OUTPUT")).getOutputDirectory();
        String libTarget = ((OutputConfiguration)fsa.getOutputConfigurations().get("LIBRARY_TARGET_FOLDER")).getOutputDirectory();
        boolean bl2 = _notEquals = !Objects.equals(libTarget, defaultTarget);
        if (_notEquals) {
            String _rel = rel;
            rel = _rel + "../" + libTarget;
        }
        _xblockexpression = rel;
        return _xblockexpression;
    }

    protected CharSequence statesEnum(ExecutionFlow it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("class ");
        String _stateEnumName = this._naming.stateEnumName();
        _builder.append(_stateEnumName);
        _builder.append(":");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\"\"\" State Enum");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("(");
        _builder.newLine();
        EList _states = this._sExecExtensions.flow((EObject)it).getStates();
        for (ExecutionState state : _states) {
            _builder.append("\t\t");
            String _stateName = this._naming.stateName((NamedElement)state);
            _builder.append(_stateName, "\t\t");
            _builder.append(",");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        String _nullStateName = this._naming.getNullStateName();
        _builder.append(_nullStateName, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(") = range(");
        int _length = ((Object[])Conversions.unwrapArray((Object)this._sExecExtensions.flow((EObject)it).getStates(), Object.class)).length;
        int _plus = _length + 1;
        _builder.append((Object)_plus, "\t");
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    protected CharSequence interfaceTypes(ExecutionFlow flow) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable _namedInterfaceScopes = this._sExecExtensions.getNamedInterfaceScopes(flow);
        for (InterfaceScope scope : _namedInterfaceScopes) {
            CharSequence _interfaceScopeClass = this._scopeGenerator.interfaceScopeClass(scope, flow);
            _builder.append((Object)_interfaceScopeClass);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence submachineImports(ExecutionFlow flow) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable<String> _imports = this.imports.getImports(flow, this.entry);
        for (String i : _imports) {
            _builder.append(i);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence constructor(ExecutionFlow flow) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("def __init__(self):");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\" Declares all necessary variables including list of states, histories etc. ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _interfaceProperties = this.interfaceProperties(flow);
        _builder.append((Object)_interfaceProperties, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _interfaceScopeMembers = this.interfaceScopeMembers(flow);
        _builder.append((Object)_interfaceScopeMembers, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _internalScopeMembers = this.internalScopeMembers(flow);
        _builder.append((Object)_internalScopeMembers, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _shadowEventProperties = this.shadowEventProperties(flow);
        _builder.append((Object)_shadowEventProperties, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _stateProperties = this.stateProperties(flow);
        _builder.append((Object)_stateProperties, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _timedProperties = this.timedProperties(flow);
        _builder.append((Object)_timedProperties, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _historyProperties = this.historyProperties(flow);
        _builder.append((Object)_historyProperties, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("# initializations:");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _code = this._flowCode.code((NamedElement)this.removeStateConfFromInit(flow.getInitSequence()));
        _builder.append((Object)_code, "\t");
        _builder.newLineIfNotEmpty();
        Iterable _properties = this._sExecExtensions.getProperties(flow);
        for (Property p : _properties) {
            _builder.append("\t");
            _builder.append("self.");
            String _identifier = this._naming.identifier((EObject)p);
            _builder.append(_identifier, "\t");
            _builder.append(" = ");
            CharSequence _initialValue = this._initialValueProvider.initialValue(this._iTypeValueProvider.defaultValue(p.getType()), p.getType());
            _builder.append((Object)_initialValue, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        return _builder;
    }

    protected Sequence removeStateConfFromInit(Sequence seq) {
        Sequence _xblockexpression = null;
        ArrayList stepForStateConf = CollectionLiterals.newArrayList();
        Consumer<Step> _function = step -> {
            Expression _varRef_1;
            ElementReferenceExpression stepVarref;
            Expression _statement_1;
            AssignmentExpression stepsAsignmentExpr;
            Expression _varRef;
            Expression _statement;
            if (step instanceof Execution && (_statement = ((Execution)step).getStatement()) instanceof AssignmentExpression && (_varRef = (stepsAsignmentExpr = (AssignmentExpression)(_statement_1 = ((Execution)step).getStatement())).getVarRef()) instanceof ElementReferenceExpression && (stepVarref = (ElementReferenceExpression)(_varRef_1 = stepsAsignmentExpr.getVarRef())).getReference() instanceof NamedElement && Objects.equals(((NamedElement)stepVarref.getReference()).getName(), "stateVector")) {
                stepForStateConf.add((Execution)step);
            }
        };
        seq.getSteps().forEach(_function);
        Consumer<Execution> _function_1 = step -> seq.getSteps().remove(step);
        stepForStateConf.forEach(_function_1);
        _xblockexpression = seq;
        return _xblockexpression;
    }

    protected CharSequence interfaceProperties(ExecutionFlow flow) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable _namedInterfaceScopes = this._sExecExtensions.getNamedInterfaceScopes(flow);
        for (InterfaceScope scope : _namedInterfaceScopes) {
            _builder.append("self.");
            String _interfaceVariableName = this._naming.interfaceVariableName(scope);
            _builder.append(_interfaceVariableName);
            _builder.append(" = ");
            String _statemachineName = this._naming.statemachineName(flow);
            _builder.append(_statemachineName);
            _builder.append(".");
            CharSequence _interfaceTypeName = this._naming.interfaceTypeName((Scope)scope);
            _builder.append((Object)_interfaceTypeName);
            _builder.append("(self)");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        return _builder;
    }

    protected CharSequence shadowEventProperties(ExecutionFlow flow) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable _shadowEvents = this._shadowEventExtensions.getShadowEvents(flow);
        for (Event event : _shadowEvents) {
            _builder.append("self.");
            String _identifier = this._naming.identifier((EObject)event);
            _builder.append(_identifier);
            _builder.append(" = None");
            _builder.newLineIfNotEmpty();
            _builder.append("self.");
            CharSequence _asObserver = this._naming.asObserver(event);
            _builder.append((Object)_asObserver);
            _builder.append(" = ");
            CharSequence _asObserverClass = this._naming.asObserverClass(event);
            _builder.append((Object)_asObserverClass);
            _builder.append("(self)");
            _builder.newLineIfNotEmpty();
            boolean _hasValue = this._sExecExtensions.hasValue((Object)event);
            if (_hasValue) {
                _builder.append("self.");
                String _valueIdentifier = this._naming.getValueIdentifier((EObject)event);
                _builder.append(_valueIdentifier);
                _builder.append(" = None");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence stateProperties(ExecutionFlow flow) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("# enumeration of all states:");
        _builder.newLine();
        _builder.append("self.");
        String _stateInstance = this._naming.stateInstance();
        _builder.append(_stateInstance);
        _builder.append(" = ");
        String _statemachineName = this._naming.statemachineName(flow);
        _builder.append(_statemachineName);
        _builder.append(".");
        String _stateEnumName = this._naming.stateEnumName();
        _builder.append(_stateEnumName);
        _builder.newLineIfNotEmpty();
        _builder.append("self.__state_conf_vector_changed = None");
        _builder.newLine();
        _builder.append("self.");
        String _stateVector = this._naming.stateVector();
        _builder.append(_stateVector);
        _builder.append(" = [None] * ");
        int _size = flow.getStateVector().getSize();
        _builder.append((Object)_size);
        _builder.newLineIfNotEmpty();
        _builder.append("for ");
        String _stateIndex = this._naming.stateIndex();
        _builder.append(_stateIndex);
        _builder.append(" in range(");
        int _size_1 = flow.getStateVector().getSize();
        _builder.append((Object)_size_1);
        _builder.append("):");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("self.");
        String _stateVector_1 = this._naming.stateVector();
        _builder.append(_stateVector_1, "\t");
        _builder.append("[");
        String _stateIndex_1 = this._naming.stateIndex();
        _builder.append(_stateIndex_1, "\t");
        _builder.append("] = self.");
        String _stateEnumName_1 = this._naming.stateEnumName();
        _builder.append(_stateEnumName_1, "\t");
        _builder.append(".");
        String _nullStateName = this._naming.getNullStateName();
        _builder.append(_nullStateName, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    protected CharSequence timedProperties(ExecutionFlow flow) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isTimed = this._sExecExtensions.isTimed(flow);
        if (_isTimed) {
            _builder.append("# for timed statechart:");
            _builder.newLine();
            _builder.append("self.");
            String _timerService = this._naming.timerService();
            _builder.append(_timerService);
            _builder.append(" = None");
            _builder.newLineIfNotEmpty();
            _builder.append("self.");
            String _timeEvents = this._naming.timeEvents();
            _builder.append(_timeEvents);
            _builder.append(" = [None] * ");
            int _size = this._sExecExtensions.getTimeEvents(flow).size();
            _builder.append((Object)_size);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence historyProperties(ExecutionFlow flow) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasHistory = this._sExecExtensions.hasHistory(flow);
        if (_hasHistory) {
            _builder.append("# history vector:");
            _builder.newLine();
            _builder.append("self.");
            String _historyVector = this._naming.historyVector();
            _builder.append(_historyVector);
            _builder.append(" = [None] * ");
            int _size = flow.getHistoryVector().getSize();
            _builder.append((Object)_size);
            _builder.newLineIfNotEmpty();
            _builder.append("for ");
            String _historyIndex = this._naming.historyIndex();
            _builder.append(_historyIndex);
            _builder.append(" in range(");
            int _size_1 = flow.getHistoryVector().getSize();
            _builder.append((Object)_size_1);
            _builder.append("):");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("self.");
            String _historyVector_1 = this._naming.historyVector();
            _builder.append(_historyVector_1, "\t");
            _builder.append("[");
            String _historyIndex_1 = this._naming.historyIndex();
            _builder.append(_historyIndex_1, "\t");
            _builder.append("] = self.");
            String _stateEnumName = this._naming.stateEnumName();
            _builder.append(_stateEnumName, "\t");
            _builder.append(".");
            String _nullStateName = this._naming.getNullStateName();
            _builder.append(_nullStateName, "\t");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence internalScopeMembers(ExecutionFlow flow) {
        StringConcatenation _builder = new StringConcatenation();
        InternalScope _internalScope = this._sExecExtensions.getInternalScope(flow);
        CharSequence _properties = null;
        if (_internalScope != null) {
            _properties = this._scopeGenerator.properties((StatechartScope)_internalScope);
        }
        _builder.append(_properties);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence interfaceScopeMembers(ExecutionFlow flow) {
        StringConcatenation _builder = new StringConcatenation();
        InterfaceScope _defaultScope = this._sExecExtensions.getDefaultScope(flow);
        CharSequence _properties = null;
        if (_defaultScope != null) {
            _properties = this._scopeGenerator.properties((StatechartScope)_defaultScope);
        }
        _builder.append(_properties);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence isStateActiveFunction(ExecutionFlow flow) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("def ");
        String _isStateActive = this._naming.isStateActive();
        _builder.append(_isStateActive);
        _builder.append("(self, state):");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\"\"\"Checks if the state is currently active.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("s = state");
        _builder.newLine();
        EList _states = flow.getStates();
        for (ExecutionState state : _states) {
            _builder.append("\t");
            _builder.append("if s == self.");
            String _stateInstance = this._naming.stateInstance();
            _builder.append(_stateInstance, "\t");
            _builder.append(".");
            String _asEscapedIdentifier = this._pythonNamingService.asEscapedIdentifier(this._naming.stateName((NamedElement)state));
            _builder.append(_asEscapedIdentifier, "\t");
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return ");
            boolean _isLeaf = state.isLeaf();
            if (_isLeaf) {
                _builder.append("self.");
                String _stateVector = this._naming.stateVector();
                _builder.append(_stateVector, "\t\t");
                _builder.append("[");
                int _offset = state.getStateVector().getOffset();
                _builder.append((Object)_offset, "\t\t");
                _builder.append("] == self.");
                String _stateInstance_1 = this._naming.stateInstance();
                _builder.append(_stateInstance_1, "\t\t");
                _builder.append(".");
                String _asEscapedIdentifier_1 = this._pythonNamingService.asEscapedIdentifier(this._naming.stateName((NamedElement)state));
                _builder.append(_asEscapedIdentifier_1, "\t\t");
            } else {
                _builder.append("(self.");
                String _stateVector_1 = this._naming.stateVector();
                _builder.append(_stateVector_1, "\t\t");
                _builder.append("[");
                int _offset_1 = state.getStateVector().getOffset();
                _builder.append((Object)_offset_1, "\t\t");
                _builder.append("] >= self.");
                String _stateInstance_2 = this._naming.stateInstance();
                _builder.append(_stateInstance_2, "\t\t");
                _builder.append(".");
                String _asEscapedIdentifier_2 = this._pythonNamingService.asEscapedIdentifier(this._naming.stateName((NamedElement)state));
                _builder.append(_asEscapedIdentifier_2, "\t\t");
                _builder.append(")\\");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("and (self.");
                String _stateVector_2 = this._naming.stateVector();
                _builder.append(_stateVector_2, "\t\t\t");
                _builder.append("[");
                int _offset_2 = state.getStateVector().getOffset();
                _builder.append((Object)_offset_2, "\t\t\t");
                _builder.append("] <= self.");
                String _stateInstance_3 = this._naming.stateInstance();
                _builder.append(_stateInstance_3, "\t\t\t");
                _builder.append(".");
                String _asEscapedIdentifier_3 = this._pythonNamingService.asEscapedIdentifier(this._naming.stateName((NamedElement)this._typesUtil.lastOrNull((Iterable)this._sExecExtensions.subStates((ExecutionScope)state))));
                _builder.append(_asEscapedIdentifier_3, "\t\t\t");
                _builder.append(")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("return False");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence isActiveFunction(ExecutionFlow flow) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("def ");
        String _isActive = this._naming.isActive();
        _builder.append(_isActive);
        _builder.append("(self):");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\"\"\"Checks if the state machine is active.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return ");
        int _size = flow.getStateVector().getSize();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
        boolean _hasElements = false;
        for (Integer i : _doubleDotLessThan) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" or ", "\t");
            }
            _builder.append("self.");
            String _stateVector = this._naming.stateVector();
            _builder.append(_stateVector, "\t");
            _builder.append("[");
            _builder.append((Object)i, "\t");
            _builder.append("] is not self.");
            String _stateInstance = this._naming.stateInstance();
            _builder.append(_stateInstance, "\t");
            _builder.append(".");
            String _nullStateName = this._naming.getNullStateName();
            _builder.append(_nullStateName, "\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    protected String isFinalFunction(ExecutionFlow flow) {
        boolean _not;
        String _xblockexpression = null;
        List[] finalStateImpactVector = this._stateVectorExtensions.finalStateImpactVector(flow);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("def ");
        String _isFinal = this._naming.isFinal();
        _builder.append(_isFinal);
        _builder.append("(self):");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\"\"\"Checks if the statemachine is final.");
        boolean _isCompletelyCovered = this._stateVectorExtensions.isCompletelyCovered(finalStateImpactVector);
        boolean bl = _not = !_isCompletelyCovered;
        if (_not) {
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("Always returns 'false' since this state machine can never become final.");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        StringConcatenation _xifexpression = null;
        boolean _isCompletelyCovered_1 = this._stateVectorExtensions.isCompletelyCovered(finalStateImpactVector);
        if (_isCompletelyCovered_1) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("\t");
            _builder_1.append("return ");
            int _size = ((List)Conversions.doWrapArray((Object)finalStateImpactVector)).size();
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
            boolean _hasElements = false;
            for (Integer i : _doubleDotLessThan) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder_1.appendImmediate((Object)" and ", "\t");
                }
                _builder_1.append("(");
                List _get = finalStateImpactVector[i];
                boolean _hasElements_1 = false;
                for (ExecutionState fs : _get) {
                    boolean _equals;
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder_1.appendImmediate((Object)" or ", "\t");
                    }
                    _builder_1.append("self.");
                    String _stateVector = this._naming.stateVector();
                    _builder_1.append(_stateVector, "\t");
                    _builder_1.append("[");
                    _builder_1.append((Object)i, "\t");
                    _builder_1.append("] == ");
                    int _offset = fs.getStateVector().getOffset();
                    boolean bl2 = _equals = _offset == i;
                    if (_equals) {
                        _builder_1.append("self.");
                        String _stateInstance = this._naming.stateInstance();
                        _builder_1.append(_stateInstance, "\t");
                        _builder_1.append(".");
                        String _asEscapedIdentifier = this._pythonNamingService.asEscapedIdentifier(this._naming.stateName((NamedElement)fs));
                        _builder_1.append(_asEscapedIdentifier, "\t");
                        continue;
                    }
                    _builder_1.append("self.");
                    String _stateInstance_1 = this._naming.stateInstance();
                    _builder_1.append(_stateInstance_1, "\t");
                    _builder_1.append(".");
                    String _nullStateName = this._naming.getNullStateName();
                    _builder_1.append(_nullStateName, "\t");
                }
                _builder_1.append(")");
            }
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t\t\t\t\t\t\t");
            _builder_1.newLine();
            _xifexpression = _builder_1;
        } else {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("\t");
            _builder_2.append("return False");
            _builder_2.newLine();
            _builder_2.append("\t\t");
            _builder_2.newLine();
            _xifexpression = _builder_2;
        }
        _xblockexpression = _builder.toString() + String.valueOf(_xifexpression);
        return _xblockexpression;
    }

    protected CharSequence internalScopeFunctions(ExecutionFlow flow) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable _internalScopes = this._sExecExtensions.getInternalScopes(flow);
        for (InternalScope scope : _internalScopes) {
            CharSequence _methods = this._scopeGenerator.methods((StatechartScope)scope);
            _builder.append((Object)_methods);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence interfaceScopeFunctions(ExecutionFlow flow) {
        StringConcatenation _builder = new StringConcatenation();
        InterfaceScope _defaultScope = this._sExecExtensions.getDefaultScope(flow);
        CharSequence _methods = null;
        if (_defaultScope != null) {
            _methods = this._scopeGenerator.methods((StatechartScope)_defaultScope);
        }
        _builder.append(_methods);
        _builder.newLineIfNotEmpty();
        return _builder;
    }
}

