/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.scxml.simulation;

import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.yakindu.base.expressions.interpreter.IExpressionInterpreter;
import com.yakindu.base.expressions.interpreter.context.IExecutionSlotResolver;
import com.yakindu.base.expressions.interpreter.scheduling.ITimeTaskScheduler;
import com.yakindu.base.types.Expression;
import com.yakindu.sct.domain.scxml.simulation.BiDiExecutionContextAdapter;
import com.yakindu.sct.generator.builder.console.EclipseConsoleLogger;
import com.yakindu.sct.generator.scxml.SCXMLGenerator;
import com.yakindu.sct.generator.scxml.modifications.NamedInterfaceModification;
import com.yakindu.sct.model.sgen.SGenFactory;
import com.yakindu.sct.model.sgraph.SGraphPackage;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.util.ContextElementAdapter;
import com.yakindu.sct.model.sruntime.ExecutionContext;
import com.yakindu.sct.model.sruntime.ExecutionVariable;
import com.yakindu.sct.model.stext.resource.StextResource;
import com.yakindu.sct.simulation.core.engine.ISimulationEngine;
import com.yakindu.sct.simulation.core.sexec.container.AbstractSimulationEngine;
import java.io.File;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.scxml2.Context;
import org.apache.commons.scxml2.ErrorReporter;
import org.apache.commons.scxml2.Evaluator;
import org.apache.commons.scxml2.EventBuilder;
import org.apache.commons.scxml2.EventDispatcher;
import org.apache.commons.scxml2.SCXMLExecutionContext;
import org.apache.commons.scxml2.SCXMLExecutor;
import org.apache.commons.scxml2.SCXMLExpressionException;
import org.apache.commons.scxml2.SCXMLIOProcessor;
import org.apache.commons.scxml2.SCXMLListener;
import org.apache.commons.scxml2.env.AbstractBaseEvaluator;
import org.apache.commons.scxml2.env.SimpleContext;
import org.apache.commons.scxml2.env.SimpleErrorReporter;
import org.apache.commons.scxml2.io.SCXMLReader;
import org.apache.commons.scxml2.model.ModelException;
import org.apache.commons.scxml2.model.Observable;
import org.apache.commons.scxml2.model.SCXML;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.XtextFactory;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.InMemoryFileSystemAccess;
import org.eclipse.xtext.linking.ILinker;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.resource.impl.ListBasedDiagnosticConsumer;
import org.eclipse.xtext.serializer.ISerializer;

public class SCXMLSimulationEngine
extends AbstractSimulationEngine
implements ISimulationEngine,
EventDispatcher {
    public static final int TIME_OUT = 7;
    @Inject
    protected SCXMLGenerator generator;
    @Inject
    protected EclipseConsoleLogger logger;
    @Inject
    protected IParser parser;
    @Inject
    protected ILinker linker;
    @Inject
    protected IExpressionInterpreter interpreter;
    @Inject
    protected Provider<StextResource> resourceProvider;
    @Inject
    protected BiDiExecutionContextAdapter context;
    @Inject
    protected ITimeTaskScheduler timeTaskScheduler;
    @Inject
    protected NamedInterfaceModification mod;
    @Inject
    protected ISerializer serializer;
    @Inject
    protected IExecutionSlotResolver resolver;
    protected SCXML scxml;
    protected SCXMLExecutor executor;
    protected Statechart statechart;
    protected Statechart modified;
    protected ExecutionContext restoreContext;
    protected boolean externalTimeControl = false;
    private static final int MAX_SUPER_STEP = 100;
    private int superStepCounter = 0;

    public SCXMLSimulationEngine(Statechart statechart) {
        this.statechart = statechart;
        this.modified = (Statechart)EcoreUtil.copy((EObject)statechart);
    }

    public void init() {
        try {
            this.initSCXML();
            this.executor = new SCXMLExecutor((Evaluator)new ExpressionsEvaluator(), null, (ErrorReporter)new SimpleErrorReporter());
            this.executor.setEventdispatcher((EventDispatcher)this);
            this.executor.setStateMachine(this.scxml);
            this.executor.addListener((Observable)this.scxml, (SCXMLListener)this.context);
            this.context.init(this.statechart, this.executor);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected void initSCXML() throws Exception {
        InMemoryFileSystemAccess access = new InMemoryFileSystemAccess();
        this.generator.generate(this.statechart, SGenFactory.eINSTANCE.createGeneratorEntry(), (IFileSystemAccess)access);
        CharSequence textFile = access.readTextFile(this.statechart.getName() + ".scxml");
        String content = textFile.toString();
        this.logger.log(content);
        File tmpfile = File.createTempFile(this.statechart.getName(), "scxml");
        tmpfile.deleteOnExit();
        PrintWriter writer = new PrintWriter(tmpfile);
        writer.write(content);
        writer.flush();
        writer.close();
        this.scxml = SCXMLReader.read((URL)tmpfile.toURI().toURL());
    }

    public boolean getExternalTimeControl() {
        return this.externalTimeControl;
    }

    public void setExternalTimeControl(boolean b) {
        this.externalTimeControl = b;
    }

    public BiDiExecutionContextAdapter getExecutionContext() {
        return this.context;
    }

    protected String getUri() {
        return "path";
    }

    public void start() {
        if (!this.externalTimeControl) {
            this.timeTaskScheduler.start();
        }
        try {
            if (this.restoreContext != null) {
                this.context.restore(this.restoreContext);
            } else {
                this.execute();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void execute() {
        ExecutorService executorService = Executors.newCachedThreadPool();
        Callable<Void> task = new Callable<Void>(){

            @Override
            public Void call() {
                try {
                    SCXMLSimulationEngine.this.executor.go(SCXMLSimulationEngine.this.executor.getGlobalContext().getVars());
                }
                catch (ModelException e) {
                    SCXMLSimulationEngine.this.handleException(e);
                }
                return null;
            }
        };
        Future<Void> future = executorService.submit(task);
        try {
            try {
                future.get(7L, TimeUnit.SECONDS);
            }
            catch (TimeoutException ex) {
                this.throwEndlessLoopException();
                future.cancel(true);
            }
            catch (InterruptedException | ExecutionException exception) {
                future.cancel(true);
            }
        }
        finally {
            future.cancel(true);
        }
    }

    public void suspend() {
        super.suspend();
        this.getTimeTaskScheduler().suspend();
    }

    public void stepForward() {
        this.getTimeTaskScheduler().step();
    }

    public void stepBackward() {
    }

    public void resume() {
        super.resume();
        this.getTimeTaskScheduler().resume();
    }

    public void terminate() {
        super.terminate();
        if (this.executor == null) {
            return;
        }
        try {
            Field field = this.executor.getClass().getDeclaredField("exctx");
            field.setAccessible(true);
            SCXMLExecutionContext context = (SCXMLExecutionContext)field.get(this.executor);
            context.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.context.getActiveStates().clear();
    }

    public void setExecutionContext(ExecutionContext context) {
        this.restoreContext = context;
    }

    public ITimeTaskScheduler getTimeTaskScheduler() {
        return this.timeTaskScheduler;
    }

    public void send(Map<String, SCXMLIOProcessor> ioProcessors, String id, String target, String type, final String event, Object data, Object hints, long delay) {
        if (delay <= 0L) {
            ++this.superStepCounter;
            ioProcessors.get("#_internal").addEvent(new EventBuilder(event, 1).build());
            --this.superStepCounter;
        } else {
            ITimeTaskScheduler.TimeTask task = new ITimeTaskScheduler.TimeTask(event, new Runnable(){

                @Override
                public void run() {
                    try {
                        if (SCXMLSimulationEngine.this.superStepCounter >= 100) {
                            SCXMLSimulationEngine.this.throwEndlessLoopException();
                        }
                        ++SCXMLSimulationEngine.this.superStepCounter;
                        SCXMLSimulationEngine.this.executor.triggerEvent(new EventBuilder(event, 1).build());
                        --SCXMLSimulationEngine.this.superStepCounter;
                    }
                    catch (ModelException e) {
                        e.printStackTrace();
                    }
                }
            });
            this.timeTaskScheduler.scheduleTimeTask(task, false, delay);
        }
    }

    protected void throwEndlessLoopException() {
        this.handleException(new RuntimeException("Infinite run to completion step detected, terminating."));
    }

    public void cancel(String sendId) {
        this.timeTaskScheduler.unscheduleTimeTask(sendId);
    }

    public EventDispatcher newInstance() {
        throw new UnsupportedOperationException();
    }

    protected class ExpressionsEvaluator
    extends AbstractBaseEvaluator {
        private static final long serialVersionUID = 1L;
        public static final String SUPPORTED_DATA_MODEL = "ecmascript";
        protected StextResource resource = this.createResource();

        public ExpressionsEvaluator() {
            Statechart copy = (Statechart)EcoreUtil.copy((EObject)SCXMLSimulationEngine.this.statechart);
            this.resource.getContents().add((Object)copy);
            this.resource.setSerializerEnabled(true);
            SCXMLSimulationEngine.this.mod.modify(copy);
        }

        public void evalAssign(Context ctx, String location, Object data) throws SCXMLExpressionException {
            try {
                ExecutionVariable variable = SCXMLSimulationEngine.this.context.getVariable(location);
                if (variable == null) {
                    variable = SCXMLSimulationEngine.this.context.getVariable(location.replaceAll("_", "."));
                }
                if (variable == null) {
                    throw new RuntimeException("Variable with name " + location + " not found!");
                }
                variable.setValue(data);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }

        public Object eval(Context context, String strExp) throws SCXMLExpressionException {
            strExp = strExp.replaceAll("In\\('", "active(").replaceAll("'\\)", ")");
            try {
                ParserRule parserRule = XtextFactory.eINSTANCE.createParserRule();
                parserRule.setName(Expression.class.getSimpleName());
                IParseResult parseResult = SCXMLSimulationEngine.this.parser.parse(parserRule, (Reader)new StringReader(strExp));
                Expression expression = (Expression)parseResult.getRootASTElement();
                this.resource.getContents().add((Object)expression);
                ListBasedDiagnosticConsumer diagnosticsConsumer = new ListBasedDiagnosticConsumer();
                SCXMLSimulationEngine.this.linker.linkModel((EObject)expression, (IDiagnosticConsumer)diagnosticsConsumer);
                Multimap diagnostics = this.resource.getLinkingDiagnostics();
                if (diagnostics.size() > 0) {
                    throw new RuntimeException(diagnostics.toString());
                }
                Object result = SCXMLSimulationEngine.this.interpreter.evaluate(expression, (ExecutionContext)SCXMLSimulationEngine.this.context);
                this.resource.getContents().remove((Object)expression);
                return result;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                throw ex;
            }
        }

        public StextResource createResource() {
            final StextResource resource = (StextResource)SCXMLSimulationEngine.this.resourceProvider.get();
            resource.eAdapters().add((Object)new ContextElementAdapter(){

                public EObject getElement() {
                    return (EObject)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)SGraphPackage.Literals.STATECHART);
                }
            });
            ResourceSetImpl set = new ResourceSetImpl();
            set.getResources().add((Object)resource);
            resource.setURI(URI.createURI((String)"statechart"));
            return resource;
        }

        public Boolean evalCond(Context context, String expression) throws SCXMLExpressionException {
            return (Boolean)this.eval(context, expression);
        }

        public Object evalScript(Context context, String expression) throws SCXMLExpressionException {
            return this.eval(context, expression);
        }

        public String getSupportedDatamodel() {
            return SUPPORTED_DATA_MODEL;
        }

        public Context newContext(Context parent) {
            return new SimpleContext(parent);
        }

        public boolean requiresGlobalContext() {
            return true;
        }
    }
}

