/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.ui.notification.dialog;

import com.yakindu.licmgmt.ui.notification.dialog.LicenseDialogActionLabelProvider;
import com.yakindu.licmgmt.ui.notification.internal.NotificationUIActivator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class LicenseErrorDialog
extends MessageDialog {
    private static final String TITLE = "itemis License Management";
    private static final String MESSAGE = "The following licenses are not available for you to use:";
    private final Runnable detailsButtonPressed;
    private List<LicenseDialogContent> content = new ArrayList<LicenseDialogContent>();
    private Consumer<Optional<LicenseErrorDialog>> closeOrRenew;
    private TableViewer tableViewer;

    public LicenseErrorDialog(Shell parentShell, Consumer<Optional<LicenseErrorDialog>> closeOrRenew, Runnable detailsButtonPressed) {
        super(parentShell, TITLE, null, MESSAGE, 1, new String[]{"Open License Preferences", "Close"}, 0);
        this.closeOrRenew = closeOrRenew;
        this.detailsButtonPressed = detailsButtonPressed;
        this.setBlockOnOpen(false);
        this.setShellStyle(this.getShellStyle() & 0x7FFEFFFF);
        parentShell.addDisposeListener(e -> this.handleDispose(e));
    }

    private void handleDispose(DisposeEvent e) {
        Composite newParentShell;
        if (e.widget instanceof Shell && this.getShell() != null && (newParentShell = ((Shell)e.widget).getParent()) instanceof Shell) {
            LicenseErrorDialog newDialog = new LicenseErrorDialog((Shell)newParentShell, this.closeOrRenew, this.detailsButtonPressed);
            newDialog.addAll(this.content);
            this.closeOrRenew.accept(Optional.of(newDialog));
            this.closeOrRenew = null;
            Rectangle oldBounds = this.getShell().getBounds();
            newDialog.create();
            newDialog.getShell().setBounds(oldBounds);
            newDialog.open();
        }
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialSize() {
        return new Point(1000, 300);
    }

    protected Control createCustomArea(Composite parent) {
        ((GridLayout)parent.getLayout()).marginWidth = 10;
        ((GridLayout)parent.getLayout()).marginHeight = 10;
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        composite.setLayout((Layout)tableColumnLayout);
        this.tableViewer = new TableViewer(composite, 67584);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getTable().setHeaderVisible(true);
        TableViewerColumn licenseColumn = new TableViewerColumn(this.tableViewer, 16384);
        licenseColumn.getColumn().setText("License");
        licenseColumn.setLabelProvider((CellLabelProvider)this.createEntryColumnLabelProvider(e -> e.getLicenseName()));
        tableColumnLayout.setColumnData((Widget)licenseColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(40, 300, true));
        TableViewerColumn messageColumn = new TableViewerColumn(this.tableViewer, 16384);
        messageColumn.getColumn().setText("Reason");
        messageColumn.setLabelProvider((CellLabelProvider)this.createEntryColumnLabelProvider(e -> e.getReason()));
        tableColumnLayout.setColumnData((Widget)messageColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(60, 300, true));
        TableViewerColumn solutionColumn = new TableViewerColumn(this.tableViewer, 16384);
        solutionColumn.getColumn().setText("Solution");
        solutionColumn.getColumn().setResizable(true);
        solutionColumn.setLabelProvider((CellLabelProvider)new LicenseDialogActionLabelProvider());
        tableColumnLayout.setColumnData((Widget)solutionColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(25, 100, true));
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput(this.content);
        parent.layout(true);
        return composite;
    }

    private ColumnLabelProvider createEntryColumnLabelProvider(final Function<LicenseDialogContent, String> entryToString) {
        return new ColumnLabelProvider(){

            public String getText(Object element) {
                return (String)entryToString.apply((LicenseDialogContent)element);
            }
        };
    }

    public boolean close() {
        boolean returnValue = super.close();
        if (returnValue && this.closeOrRenew != null) {
            this.closeOrRenew.accept(Optional.empty());
        }
        return returnValue;
    }

    private void addAll(List<LicenseDialogContent> newContent) {
        this.content.clear();
        this.content.addAll(newContent);
        this.refreshViewer();
    }

    public void add(Runnable dialog, String licenseName, String reason) {
        this.content.removeIf(c -> c.licenseName.equals(licenseName));
        this.content.add(0, new LicenseDialogContent(dialog, licenseName, reason));
        this.refreshViewer();
    }

    private void refreshViewer() {
        if (this.tableViewer != null && !this.tableViewer.getTable().isDisposed()) {
            this.tableViewer.refresh();
        }
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == 0) {
            this.detailsButtonPressed.run();
        }
    }

    public Image getImage() {
        return NotificationUIActivator.getDefault().getImage("com.yakindu.licmgmt.ui.notification.YAKINDU_Image");
    }

    public static class LicenseDialogContent {
        private Runnable licenseDialog;
        private String licenseName;
        private String reason;

        public LicenseDialogContent(Runnable dialog, String licenseName, String reason) {
            this.licenseDialog = dialog;
            this.licenseName = licenseName;
            this.reason = reason;
        }

        public Runnable getLicenseDialog() {
            return this.licenseDialog;
        }

        public String getLicenseName() {
            return this.licenseName;
        }

        public String getReason() {
            return this.reason;
        }
    }
}

