/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.ui.notification.popup;

import com.yakindu.licmgmt.ui.notification.internal.NotificationUIActivator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class NotificationPopup {
    private static final Image INFO_IMAGE = NotificationUIActivator.getImage(2);
    private static final Image WARNING_IMAGE = NotificationUIActivator.getImage(8);
    private static final Image ERROR_IMAGE = NotificationUIActivator.getImage(1);
    private static final Image CLOSE_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_REMOVE");
    private static final int WIDTH_DIV = 5;
    private static final int DISPLAY_TIME = 15000;
    private static final int FADE_TIMER = 100;
    private static final int FADE_IN_STEP = 20;
    private static final int FADE_OUT_STEP = 20;
    private static final int MOVE_REFRESH_TIMER = 60;
    private static final int MOVE_TIMER = 500;
    private static final int DIRECTION_UP = 0;
    private static final int DIRECTION_DOWN = 1;
    private static final int FINAL_ALPHA = 220;
    private static final int SHELL_MARGIN = 5;
    private static final int MENU_OFFSET = 80;
    private static List<Shell> ACTIVE_SHELLS = new ArrayList<Shell>();
    private static Image OLD_IMAGE;

    public static void notify(String title, String message, final Map<String, Runnable> actions, int severity) {
        Color titleFgColor;
        Display display = Display.getDefault();
        Color fgColor = titleFgColor = display.getSystemColor(10);
        final Color bgFgGradient = display.getSystemColor(15);
        final Color bgBgGradient = display.getSystemColor(1);
        final Color borderColor = display.getSystemColor(10);
        final Shell shell = NotificationPopup.createShellForPopUp(display);
        shell.setLayout((Layout)new FillLayout());
        shell.setForeground(fgColor);
        shell.setBackgroundMode(1);
        Composite composite = new Composite((Composite)shell, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.marginLeft = 5;
        gl.marginTop = 0;
        gl.marginRight = 5;
        gl.marginBottom = 5;
        composite.setLayout((Layout)gl);
        shell.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                try {
                    Rectangle rect = shell.getClientArea();
                    Image newImage = new Image((Device)Display.getDefault(), Math.max(1, rect.width), rect.height);
                    GC gc = new GC((Drawable)newImage);
                    gc.setForeground(bgFgGradient);
                    gc.setBackground(bgBgGradient);
                    gc.fillGradientRectangle(rect.x, rect.y, rect.width, rect.height, true);
                    gc.setLineWidth(2);
                    gc.setForeground(borderColor);
                    gc.drawRectangle(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
                    gc.dispose();
                    shell.setBackgroundImage(newImage);
                    if (OLD_IMAGE != null) {
                        OLD_IMAGE.dispose();
                    }
                    OLD_IMAGE = newImage;
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        });
        Label imgLabel = new Label(composite, 0);
        imgLabel.setLayoutData((Object)new GridData(36));
        imgLabel.setImage(NotificationPopup.getImageForSeverity(severity));
        CLabel titleLabel = new CLabel(composite, 64);
        titleLabel.setLayoutData((Object)new GridData(772));
        titleLabel.setText(title);
        titleLabel.setForeground(titleFgColor);
        Font f = titleLabel.getFont();
        FontData fd = f.getFontData()[0];
        fd.setHeight(12);
        titleLabel.setFont(new Font((Device)display, fd));
        Label closeLabel = new Label(composite, 0);
        closeLabel.setLayoutData((Object)new GridData(132));
        closeLabel.setImage(CLOSE_IMAGE);
        closeLabel.setToolTipText("Close Notification");
        closeLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.getSource() instanceof Label) {
                    Label label = (Label)e.getSource();
                    Shell shell = label.getShell();
                    Display.getDefault().timerExec(50, NotificationPopup.createFadeOutRunnable(shell, 50));
                }
            }
        });
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(1, 2, true, true, 3, 1));
        separator.setBackground(borderColor);
        Label text = new Label(composite, 64);
        Font tf = text.getFont();
        FontData tfd = tf.getFontData()[0];
        tfd.setHeight(9);
        text.setFont(new Font((Device)display, tfd));
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        Rectangle primaryBounds = display.getPrimaryMonitor().getBounds();
        gd.widthHint = primaryBounds.width / 5;
        text.setLayoutData((Object)gd);
        text.setForeground(fgColor);
        text.setText(message);
        if (actions != null) {
            for (final String action : actions.keySet()) {
                Link actionLink = new Link(composite, 64);
                actionLink.setText("<A>" + action + "</A>");
                actionLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ((Runnable)actions.get(action)).run();
                        Display.getDefault().timerExec(50, NotificationPopup.createFadeOutRunnable(shell, 50));
                    }
                });
            }
        }
        composite.pack();
        Point size = composite.getSize();
        Rectangle r = separator.getBounds();
        r.x = 2;
        r.width = size.x - 4;
        separator.setBounds(r);
        shell.setSize(size.x, size.y);
        NotificationPopup.addShell(shell);
        NotificationPopup.openShell(shell);
    }

    private static Shell createShellForPopUp(Display display) {
        Shell activeShell = display.getActiveShell();
        boolean isParentModal = activeShell != null && (activeShell.getStyle() & 0x10000) == 65536;
        int popupFlags = 540680;
        return isParentModal ? new Shell(activeShell, 540680) : new Shell(display, 540680);
    }

    private static Image getImageForSeverity(int severity) {
        switch (severity) {
            case 4: {
                return ERROR_IMAGE;
            }
            case 2: {
                return WARNING_IMAGE;
            }
        }
        return INFO_IMAGE;
    }

    private static void addShell(Shell shell) {
        if (!ACTIVE_SHELLS.isEmpty()) {
            int offset = shell.getBounds().height + 5;
            Display.getDefault().timerExec(0, NotificationPopup.createMoveRunnable(new ArrayList<Shell>(ACTIVE_SHELLS), offset, 0));
        }
        Rectangle clientArea = shell.getDisplay().getPrimaryMonitor().getBounds();
        int startX = clientArea.x + clientArea.width - (shell.getBounds().width + 5);
        int startY = clientArea.y + clientArea.height - (shell.getBounds().height + 5 + 80);
        shell.setLocation(startX, startY);
        shell.setAlpha(0);
        shell.setVisible(true);
        ACTIVE_SHELLS.add(shell);
    }

    private static void removeShell(Shell shell) {
        int index = ACTIVE_SHELLS.indexOf(shell);
        if (index > 0) {
            int offset = shell.getBounds().height + 5;
            Display.getDefault().timerExec(0, NotificationPopup.createMoveRunnable(new ArrayList<Shell>(ACTIVE_SHELLS.subList(0, index)), offset, 1));
        }
        if (index != -1) {
            ACTIVE_SHELLS.remove(shell);
        }
        shell.dispose();
    }

    private static void openShell(Shell shell) {
        Display.getDefault().timerExec(100, NotificationPopup.createFadeInRunnable(shell, 100));
        Display.getDefault().timerExec(15000, NotificationPopup.createFadeOutRunnable(shell, 100));
    }

    private static Runnable createMoveRunnable(final List<Shell> shells, final int offset, final int direction) {
        int steps = 8;
        final int stepLength = offset / 8;
        final int remainder = offset % 8;
        return new Runnable(){
            private int step = 1;

            @Override
            public void run() {
                if (!shells.isEmpty() && offset > 0) {
                    for (Shell _shell : shells) {
                        if (_shell.isDisposed()) continue;
                        Point curLoc = _shell.getLocation();
                        int delta = this.step == 8 ? stepLength + remainder : stepLength;
                        _shell.setLocation(curLoc.x, direction == 0 ? curLoc.y - delta : curLoc.y + delta);
                        if (curLoc.y >= 0) continue;
                        ACTIVE_SHELLS.remove(_shell);
                        _shell.dispose();
                    }
                    ++this.step;
                    if (this.step <= 8) {
                        Display.getDefault().timerExec(60, (Runnable)this);
                    }
                }
            }
        };
    }

    private static Runnable createFadeInRunnable(final Shell shell, final int fadeTime) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    if (shell == null || shell.isDisposed()) {
                        return;
                    }
                    int cur = shell.getAlpha();
                    if ((cur += 20) > 220) {
                        shell.setAlpha(220);
                        return;
                    }
                    shell.setAlpha(cur);
                    Display.getDefault().timerExec(fadeTime, (Runnable)this);
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        };
    }

    private static Runnable createFadeOutRunnable(final Shell shell, final int fadeTime) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    if (shell == null || shell.isDisposed()) {
                        return;
                    }
                    int alpha = shell.getAlpha();
                    if ((alpha -= 20) <= 0) {
                        shell.setAlpha(0);
                        if (OLD_IMAGE != null) {
                            OLD_IMAGE.dispose();
                        }
                        NotificationPopup.removeShell(shell);
                        return;
                    }
                    shell.setAlpha(alpha);
                    Display.getDefault().timerExec(fadeTime, (Runnable)this);
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        };
    }
}

