/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.examples.wizard.pages;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class MessageArea
extends Composite {
    private static final String DOWNLOAD_LINK = "http://www.statecharts.org/examples.html";
    private static final String PREF_PAGE_ID = "com.yakindu.sct.examples";
    private static final String DISPLAY_ID = "com.yakindu.sct.examples";
    private Label imageLabel;
    private Link textLabel;
    public Button button;
    private Group group;
    private State state = State.HIDE;

    public MessageArea(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.createControls();
    }

    protected void createControls() {
        this.group = new Group((Composite)this, 0);
        this.group.setLayout((Layout)new GridLayout(3, false));
        this.imageLabel = new Label((Composite)this.group, 0);
        GridDataFactory.fillDefaults().grab(false, false).align(1, 0x1000000).applyTo((Control)this.imageLabel);
        this.textLabel = new Link((Composite)this.group, 64);
        this.textLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageArea.DOWNLOAD_LINK.equals(e.text)) {
                    Program.launch((String)MessageArea.DOWNLOAD_LINK);
                } else {
                    PreferenceDialog dialog = MessageArea.this.createPreferencePageDialog();
                    dialog.open();
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)this.textLabel);
        this.button = new Button((Composite)this.group, 0x800000);
        this.button.setText("Download");
        GridDataFactory.fillDefaults().grab(false, false).align(0x1000008, 0x1000000).applyTo((Control)this.button);
    }

    public PreferenceDialog createPreferencePageDialog() {
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)"com.yakindu.sct.examples", (String[])new String[]{"com.yakindu.sct.examples"}, null);
        dialog.setSelectedNode("DISPLAY_ID");
        return dialog;
    }

    public void showNoExamplesFound() {
        this.state = State.DOWNLOAD;
        this.imageLabel.setImage(Display.getDefault().getSystemImage(2));
        this.textLabel.setText("No examples found, please download the latest examples.\nYou can <a>change the storage location here.</a>");
        this.textLabel.requestLayout();
        this.button.setText("Download");
        this.button.setVisible(true);
        this.button.requestLayout();
        this.show();
    }

    public void showUpdateAvailable() {
        this.state = State.UPDATE;
        this.imageLabel.setImage(Display.getDefault().getSystemImage(4));
        this.textLabel.setText("Updates available. Do you want to download the new examples?");
        this.textLabel.requestLayout();
        this.button.setText("Update");
        this.button.setVisible(true);
        this.button.requestLayout();
        this.show();
    }

    public void showInvalidConfigurationError() {
        this.state = State.INVALID_CONFIG;
        this.imageLabel.setImage(Display.getDefault().getSystemImage(1));
        this.textLabel.setText("Invalid configuration");
        this.textLabel.requestLayout();
        this.button.setText("Open preference page");
        this.button.setVisible(true);
        this.button.requestLayout();
        this.show();
    }

    public void showRemoteBranchNotFound() {
        this.state = State.INVALID_CONFIG;
        this.imageLabel.setImage(Display.getDefault().getSystemImage(1));
        this.textLabel.setText("Remote Branch not found");
        this.textLabel.requestLayout();
        this.button.setText("Open preference page");
        this.button.setVisible(true);
        this.button.requestLayout();
        this.show();
    }

    public void showRepoContainsConflicts() {
        this.state = State.ERROR;
        this.imageLabel.setImage(Display.getDefault().getSystemImage(1));
        this.textLabel.setText("Repo contains conflicts!");
        this.textLabel.requestLayout();
        this.button.setVisible(false);
        this.show();
    }

    public void showDependenciesMissing() {
        this.state = State.INSTALL;
        this.imageLabel.setImage(Display.getDefault().getSystemImage(8));
        this.textLabel.setText("This example requires additional features. Do you want to install them?");
        this.textLabel.requestLayout();
        this.button.setText("Install Dependencies...");
        this.button.setVisible(true);
        this.button.requestLayout();
        this.show();
    }

    public void showUnableToDownloadError() {
        this.state = State.ERROR;
        this.imageLabel.setImage(Display.getDefault().getSystemImage(1));
        this.textLabel.setText("Unable to download examples. You can manually download them from \n <a>http://www.statecharts.org/examples.html</a>");
        this.textLabel.requestLayout();
        this.button.setVisible(false);
        this.show();
    }

    protected void show() {
        this.setVisible(true);
        GridData data = (GridData)this.getLayoutData();
        data.exclude = false;
    }

    public void hide() {
        this.state = State.HIDE;
        this.setVisible(false);
        GridData data = (GridData)this.getLayoutData();
        data.exclude = true;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.button.addSelectionListener(listener);
    }

    public State getState() {
        return this.state;
    }

    public static enum State {
        DOWNLOAD,
        UPDATE,
        INSTALL,
        INVALID_CONFIG,
        ERROR,
        HIDE;

    }
}

