/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.examples.wizard.service.data;

import com.yakindu.sct.examples.wizard.ExampleActivator;
import com.yakindu.sct.examples.wizard.service.data.ExampleData;
import com.yakindu.sct.examples.wizard.service.data.IExampleData;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ExampleCategory
implements IExampleData {
    private String title;
    private String desc;
    private static List<ExampleCategory> categorysList = new ArrayList<ExampleCategory>();
    private static Map<String, String> legacyTitles = Stream.of({"modeling", "Getting Started - Modeling"}, {"code-generation", "Getting Started - Code Generation"}, {"testing", "Getting Started - Testing & Coverage"}, {"multi-sm", "Multi State Machines - Code Generation & Modeling"}, {"execution-variants", "Execution Variants"}, {"advanced", "Application Examples"}, {"embedded", "Embedded Systems"}, {"integration", "Embedded Systems Integration Guide"}, {"others", "Other"}).collect(Collectors.toMap(data -> data[0], data -> data[1]));
    private static final String PREVIEW_PAGES = "category-pages";

    ExampleCategory(String title, String desc) {
        this.title = title;
        this.desc = desc;
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescriptionPath() {
        return String.valueOf(this.getStorageLocation()) + File.separator + PREVIEW_PAGES + File.separator + this.desc;
    }

    protected Path getStorageLocation() {
        return Paths.get(ExampleActivator.getDefault().getPreferenceStore().getString("storageLocation"), new String[0]);
    }

    protected static String convertLegacyCategorys(String category) {
        String convertedCategory = legacyTitles.get(category);
        if (convertedCategory != null) {
            return convertedCategory;
        }
        return category;
    }

    public static List<ExampleCategory> get(ExampleData data) {
        ArrayList<ExampleCategory> returnList = new ArrayList<ExampleCategory>();
        List<String> categorys = Arrays.asList(data.getCategory());
        String category = ExampleCategory.convertLegacyCategorys(categorys.get(categorys.size() - 1));
        for (String cat : categorys) {
            if (!cat.equals(ExampleCategory.convertLegacyCategorys(cat))) {
                category = ExampleCategory.convertLegacyCategorys(cat);
                break;
            }
            if (!legacyTitles.containsValue(cat)) continue;
            category = cat;
        }
        boolean exists = false;
        for (ExampleCategory exampleCategory : categorysList) {
            if (!exampleCategory.getTitle().equals(category)) continue;
            returnList.add(exampleCategory);
            exists = true;
            break;
        }
        if (!exists) {
            ExampleCategory ex = new ExampleCategory(category, category + ".html");
            categorysList.add(ex);
            returnList.add(ex);
        }
        return returnList;
    }
}

