/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.examples.wizard.service.git;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.yakindu.sct.examples.wizard.service.IExampleService;
import com.yakindu.sct.examples.wizard.service.data.ExampleData;
import com.yakindu.sct.examples.wizard.service.git.EclipseGitProgressTransformer;
import com.yakindu.sct.examples.wizard.service.git.IExampleDataReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;

@Singleton
public class GitRepositoryExampleService
implements IExampleService {
    private static final String METADATA_JSON = "metadata.json";
    @Inject
    private IExampleDataReader reader;
    @Inject
    private IPreferenceStore preferenceStore;
    @Inject(optional=true)
    private CredentialsProvider credentialsProvider = CredentialsProvider.getDefault();

    protected Path getStorageLocation() {
        return Paths.get(this.preferenceStore.getString("storageLocation"), new String[0]);
    }

    @Override
    public boolean exists() {
        return Files.exists(this.getStorageLocation(), new LinkOption[0]) && this.hasMetaData(this.getStorageLocation());
    }

    @Override
    public IStatus fetchAllExamples(IProgressMonitor monitor) {
        if (!this.exists()) {
            Path storageLocation = this.getStorageLocation();
            try {
                Files.createDirectories(storageLocation, new FileAttribute[0]);
            }
            catch (IOException e1) {
                return new Status(4, "com.yakindu.sct.examples.ui", "Unable to create folder " + String.valueOf(storageLocation.getFileName()));
            }
            return this.cloneRepository(monitor);
        }
        return this.updateRepository(monitor);
    }

    protected IStatus updateRepository(IProgressMonitor monitor) {
        String repoURL = this.getPreference("remoteLocation");
        Path storageLocation = this.getStorageLocation();
        try {
            Git git = Git.open((File)storageLocation.toFile());
            PullResult result = ((PullCommand)git.pull().setProgressMonitor((ProgressMonitor)new EclipseGitProgressTransformer(monitor)).setCredentialsProvider(this.credentialsProvider)).call();
            if (!result.isSuccessful()) {
                return new Status(4, "com.yakindu.sct.examples.ui", "Unable to update repository " + repoURL + "!");
            }
        }
        catch (IOException | GitAPIException e) {
            return new Status(4, "com.yakindu.sct.examples.ui", "Unable to update repository " + repoURL + "!");
        }
        return Status.OK_STATUS;
    }

    protected String getPreference(String constant) {
        return this.preferenceStore.getString(constant);
    }

    protected IStatus cloneRepository(IProgressMonitor monitor) {
        String repoURL = this.getPreference("remoteLocation");
        String remoteBranch = this.getPreference("remoteBranch");
        Git call = null;
        Path storageLocation = this.getStorageLocation();
        try {
            try {
                call = ((CloneCommand)Git.cloneRepository().setURI(repoURL).setDirectory(storageLocation.toFile()).setProgressMonitor((ProgressMonitor)new EclipseGitProgressTransformer(monitor)).setBranch(remoteBranch).setCredentialsProvider(this.credentialsProvider)).call();
            }
            catch (GitAPIException e) {
                try {
                    this.deleteFolder(storageLocation);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                Status status = new Status(4, "com.yakindu.sct.examples.ui", "Unable to clone repository " + repoURL + "!");
                if (call != null) {
                    call.close();
                }
                if (monitor.isCanceled()) {
                    try {
                        this.deleteFolder(storageLocation);
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                return status;
            }
        }
        finally {
            if (call != null) {
                call.close();
            }
            if (monitor.isCanceled()) {
                try {
                    this.deleteFolder(storageLocation);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return Status.OK_STATUS;
    }

    @Override
    public List<ExampleData> getExamples(IProgressMonitor monitor) {
        Path storageLocation = this.getStorageLocation();
        ArrayList<Path> projects = new ArrayList<Path>();
        this.findMetaData(projects, storageLocation);
        List<ExampleData> result = this.reader.parse(projects);
        Collections.sort(result);
        return result;
    }

    protected void findMetaData(List<Path> result, Path root) {
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(root);){
                for (Path entry : stream) {
                    if (Files.isDirectory(entry, new LinkOption[0])) {
                        this.findMetaData(result, entry);
                        continue;
                    }
                    if (!entry.getFileName().toString().equals(METADATA_JSON)) continue;
                    result.add(entry);
                }
                stream.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (AccessDeniedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected boolean hasMetaData(Path root) {
        ArrayList<Path> result = new ArrayList<Path>();
        this.findMetaData(result, root);
        return !result.isEmpty();
    }

    protected void deleteFolder(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @Override
    public IExampleService.UpdateResult fetchNewUpdates(IProgressMonitor monitor) {
        Path storageLocation = this.getStorageLocation();
        String remoteBranch = this.getPreference("remoteBranch");
        try {
            Git git = Git.open((File)storageLocation.toFile());
            FetchCommand fetch = (FetchCommand)git.fetch().setCredentialsProvider(this.credentialsProvider);
            FetchResult result = fetch.setProgressMonitor((ProgressMonitor)new EclipseGitProgressTransformer(monitor)).call();
            if (this.doesBranchExist(git, BranchType.REMOTE, remoteBranch)) {
                CheckoutCommand checkout = git.checkout();
                checkout.setName(remoteBranch);
                checkout.setCreateBranch(!this.doesBranchExist(git, BranchType.LOCAL, remoteBranch));
                try {
                    checkout.call();
                }
                catch (CheckoutConflictException e) {
                    return IExampleService.UpdateResult.REPO_CONTAINS_CONFLICTS;
                }
            } else {
                return IExampleService.UpdateResult.REMOTE_BRANCH_NOT_FOUND;
            }
            if (result.getTrackingRefUpdates().isEmpty()) {
                return IExampleService.UpdateResult.NO_UPDATES;
            }
            return IExampleService.UpdateResult.UPDATE_AVAILABLE;
        }
        catch (RepositoryNotFoundException ex) {
            return IExampleService.UpdateResult.NO_UPDATES;
        }
        catch (Exception ex) {
            return IExampleService.UpdateResult.NO_UPDATES;
        }
    }

    private boolean doesBranchExist(Git git, BranchType type, String remoteBranch) throws GitAPIException {
        if (type == BranchType.LOCAL) {
            return git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call().stream().anyMatch(branch -> branch.getName().equals("refs/heads/" + remoteBranch));
        }
        return git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call().stream().anyMatch(branch -> branch.getName().equals("refs/remotes/origin/" + remoteBranch));
    }

    private static enum BranchType {
        LOCAL,
        REMOTE;

    }
}

