/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.java;

import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import com.itemis.create.base.generator.core.codepattern.TypeSystemAccessExpressionCode;
import com.yakindu.sct.generator.core.IExecutionFlowGenerator;
import com.yakindu.sct.generator.core.IGeneratorModule;
import com.yakindu.sct.generator.core.extensions.CoreFlowConfiguration;
import com.yakindu.sct.generator.core.templates.ExpressionsGenerator;
import com.yakindu.sct.generator.core.templates.TraceCodeGenerator;
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess;
import com.yakindu.sct.generator.java.JavaExpressionsGenerator;
import com.yakindu.sct.generator.java.JavaGenerator;
import com.yakindu.sct.generator.java.JavaIncludeProvider;
import com.yakindu.sct.generator.java.JavaNamingService;
import com.yakindu.sct.generator.java.JavaStatechartIncludeProvider;
import com.yakindu.sct.generator.java.submodules.EventCode;
import com.yakindu.sct.generator.java.submodules.FieldDeclarationGenerator;
import com.yakindu.sct.generator.java.submodules.InitializedCheckCode;
import com.yakindu.sct.generator.java.submodules.TimingFunctions;
import com.yakindu.sct.generator.java.submodules.TraceCode;
import com.yakindu.sct.generator.java.submodules.eventdriven.EventDrivenEventCode;
import com.yakindu.sct.generator.java.submodules.eventdriven.EventDrivenFieldDeclarationGenerator;
import com.yakindu.sct.generator.java.submodules.eventdriven.EventDrivenTimingFunctions;
import com.yakindu.sct.generator.java.types.JavaTypeSystemAccess;
import com.yakindu.sct.model.sexec.naming.INamingService;
import com.yakindu.sct.model.sexec.transformation.IModelSequencer;
import com.yakindu.sct.model.sexec.transformation.ModelSequencer;
import com.yakindu.sct.model.sexec.transformation.config.IFlowConfiguration;
import com.yakindu.sct.model.sgen.FeatureParameterValue;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations;
import java.lang.annotation.Annotation;

public class JavaGeneratorModule
implements IGeneratorModule {
    protected Multibinder<JavaIncludeProvider> includeProviderBinder;

    public void configure(GeneratorEntry entry, Binder binder) {
        this.includeProviderBinder = Multibinder.newSetBinder((Binder)binder, JavaIncludeProvider.class);
        this.includeProviderBinder.addBinding().to(JavaStatechartIncludeProvider.class);
        this.configureGeneratorRoot(entry, binder);
        this.configureForExecutionStyle(entry, binder);
        this.configureServices(entry, binder);
        this.bindTracingProperty(entry, binder);
    }

    public void configureGeneratorRoot(GeneratorEntry entry, Binder binder) {
        binder.bind(IFlowConfiguration.class).to(CoreFlowConfiguration.class);
        binder.bind(com.yakindu.sct.generator.core.submodules.lifecycle.EventCode.class).to(EventCode.class);
        binder.bind(com.yakindu.sct.generator.core.submodules.lifecycle.TraceCode.class).to(TraceCodeGenerator.class);
        binder.bind(TraceCodeGenerator.class).to(TraceCode.class);
        binder.bind(com.yakindu.sct.generator.core.submodules.lifecycle.InitializedCheckCode.class).to(InitializedCheckCode.class);
        binder.bind(IModelSequencer.class).to(ModelSequencer.class);
        binder.bind(IExecutionFlowGenerator.class).to(JavaGenerator.class);
        binder.bind(GeneratorEntry.class).toInstance((Object)entry);
        binder.bind(TypeSystemAccessExpressionCode.class).to(ExpressionsGenerator.class);
        binder.bind(ExpressionsGenerator.class).to(JavaExpressionsGenerator.class);
    }

    public void configureForExecutionStyle(GeneratorEntry entry, Binder binder) {
        if (this.isEventDriven(entry)) {
            binder.bind(TimingFunctions.class).to(EventDrivenTimingFunctions.class);
            binder.bind(EventCode.class).to(EventDrivenEventCode.class);
            binder.bind(FieldDeclarationGenerator.class).to(EventDrivenFieldDeclarationGenerator.class);
        }
    }

    public void configureServices(GeneratorEntry entry, Binder binder) {
        binder.bind(com.itemis.create.base.generator.core.types.ICodegenTypeSystemAccess.class).to(ICodegenTypeSystemAccess.class);
        binder.bind(ICodegenTypeSystemAccess.class).to(JavaTypeSystemAccess.class);
        binder.bind(INamingService.class).to(JavaNamingService.class).in(Scopes.SINGLETON);
    }

    protected void bindTracingProperty(GeneratorEntry entry, Binder binder) {
        FeatureParameterValue traceEnterFeature = entry.getFeatureParameterValue("Tracing", "enterState");
        FeatureParameterValue traceExitFeature = entry.getFeatureParameterValue("Tracing", "exitState");
        FeatureParameterValue traceGenericFeature = entry.getFeatureParameterValue("Tracing", "generic");
        boolean traceEnter = traceEnterFeature != null ? traceEnterFeature.getBooleanValue() : false;
        boolean traceExit = traceExitFeature != null ? traceExitFeature.getBooleanValue() : false;
        boolean traceGeneric = traceGenericFeature != null ? traceGenericFeature.getBooleanValue() : false;
        binder.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)"ADD_TRACES")).toInstance((Object)(traceEnter || traceExit || traceGeneric ? 1 : 0));
    }

    protected boolean isEventDriven(GeneratorEntry entry) {
        return new StatechartAnnotations().isEventDriven((Statechart)entry.getElementRef());
    }
}

