/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.java.files;

import com.google.inject.Inject;
import com.yakindu.sct.generator.core.extensions.StringHelper;
import com.yakindu.sct.generator.core.filesystem.OutputConfigProvider;
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper;
import com.yakindu.sct.generator.java.GenmodelEntries;
import com.yakindu.sct.generator.java.Naming;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ITimed {
    @Inject
    @Extension
    private Naming _naming;
    @Inject
    @Extension
    private GenmodelEntries _genmodelEntries;
    @Inject
    @Extension
    private OutputConfigProvider _outputConfigProvider;
    @Inject
    @Extension
    private ICoreLibraryHelper _iCoreLibraryHelper;
    @Inject
    @Extension
    private StringHelper _stringHelper;

    public void generateITimed(ExecutionFlow flow, GeneratorEntry entry, IFileSystemAccess fsa) {
        boolean _skipLibraryFiles = this._iCoreLibraryHelper.getSkipLibraryFiles(entry);
        if (_skipLibraryFiles) {
            return;
        }
        String _path = this._stringHelper.toPath(this._genmodelEntries.getLibraryPackage(entry));
        String _plus = _path + "/";
        String _java = this._naming.java(this._naming.iTimed());
        String fileName = _plus + _java;
        fsa.generateFile(fileName, this._outputConfigProvider.getLibraryOutputConfig(entry), this.content(entry));
    }

    public CharSequence content(GeneratorEntry entry) {
        return this.content(this._genmodelEntries.getLicenseText(entry), this._genmodelEntries.getLibraryPackage(entry));
    }

    public CharSequence content(String licenseText, String pkg) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(licenseText);
        _builder.newLineIfNotEmpty();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)pkg);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append("package ");
            _builder.append(pkg);
            _builder.append(";");
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append("* Interface for state machines which use timed event triggers.");
        _builder.newLine();
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public interface ");
        String _iTimed = this._naming.iTimed();
        _builder.append(_iTimed);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("* Callback method if a time event occurred.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("* ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("* @param eventID\tthe id of the occurred event");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void raiseTimeEvent(int eventID);");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("* Set the {@link ");
        String _iTimerService = this._naming.iTimerService();
        _builder.append(_iTimerService, "\t");
        _builder.append("} for the state machine. It must be set");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("* externally on a timed state machine before <code>enter()</code> is called.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("* ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("* @param timerService\tthe timer service implementation to be set.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setTimerService(");
        String _iTimerService_1 = this._naming.iTimerService();
        _builder.append(_iTimerService_1, "\t");
        _builder.append(" timerService);");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

