/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.java.files;

import com.google.inject.Inject;
import com.yakindu.sct.generator.core.extensions.StringHelper;
import com.yakindu.sct.generator.core.filesystem.OutputConfigProvider;
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper;
import com.yakindu.sct.generator.java.GenmodelEntries;
import com.yakindu.sct.generator.java.Naming;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ITracingListener {
    @Inject
    @Extension
    private Naming _naming;
    @Inject
    @Extension
    private GenmodelEntries _genmodelEntries;
    @Inject
    @Extension
    private ICoreLibraryHelper _iCoreLibraryHelper;
    @Inject
    @Extension
    private OutputConfigProvider _outputConfigProvider;
    @Inject
    @Extension
    private StringHelper _stringHelper;

    public void generateTracingListener(ExecutionFlow flow, GeneratorEntry entry, IFileSystemAccess fsa) {
        boolean _skipLibraryFiles = this._iCoreLibraryHelper.getSkipLibraryFiles(entry);
        if (_skipLibraryFiles) {
            return;
        }
        String _path = this._stringHelper.toPath(this._genmodelEntries.getLibraryPackage(entry));
        String _plus = _path + "/";
        String _java = this._naming.java(this._naming.tracingListener());
        String fileName = _plus + _java;
        fsa.generateFile(fileName, this._outputConfigProvider.getLibraryOutputConfig(entry), this.content(entry));
    }

    private CharSequence content(GeneratorEntry it) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        String _licenseText = this._genmodelEntries.getLicenseText(it);
        _builder.append(_licenseText);
        _builder.newLineIfNotEmpty();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this._genmodelEntries.getLibraryPackage(it));
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append("package ");
            String _libraryPackage = this._genmodelEntries.getLibraryPackage(it);
            _builder.append(_libraryPackage);
            _builder.append(";");
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Tracing interface for state machines.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Must be implemented if tracing feature is used.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Multiple listeners can be added to and removed from the state machine.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public interface ");
        String _tracingListener = this._naming.tracingListener();
        _builder.append(_tracingListener);
        _builder.append("<T> {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* ");
        String _firstUpper = StringExtensions.toFirstUpper((String)this._naming.stateEnteredTraceFunctionID());
        _builder.append(_firstUpper, "\t ");
        _builder.append(" will be called if any state has been entered.");
        _builder.newLineIfNotEmpty();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("void ");
        String _stateEnteredTraceFunctionID = this._naming.stateEnteredTraceFunctionID();
        _builder.append(_stateEnteredTraceFunctionID, "\t");
        _builder.append("(T state);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("* ");
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)this._naming.stateExitedTraceFunctionID());
        _builder.append(_firstUpper_1, "\t");
        _builder.append(" will be called if any state has been exited.");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("void ");
        String _stateExitedTraceFunctionID = this._naming.stateExitedTraceFunctionID();
        _builder.append(_stateExitedTraceFunctionID, "\t");
        _builder.append("(T state);");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

