/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.types.lib;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.yakindu.base.expressions.parser.antlr.ExpressionsParser;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Package;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypeSpecifier;
import com.yakindu.base.types.TypesFactory;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.sct.model.sexec.concepts.SubMachine;
import java.io.Reader;
import java.io.StringReader;
import java.util.Objects;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class StatechartLibrary {
    public static final String STATEMACHINE_TYPES = "statemachine.types";
    @Extension
    private TypesFactory factory = TypesFactory.eINSTANCE;
    @Inject
    @Extension
    private ITypeSystem ts;
    private Package typesPackage;
    @Inject(optional=true)
    private ExpressionsParser parser;
    @Inject
    @Extension
    private SubMachine.SubmachineTypeLibrary subLib;
    public static final String EVENT_DRIVEN_NAME = "EventDrivenStatemachine";
    public static final String CYCLE_BASED_NAME = "CycleBasedStatemachine";
    public static final String STATEMACHINE_NAME = "Statemachine";
    public static final String TRIGGER_WITHOUT_EVENT_NAME = "triggerWithoutEvent";
    private final ResourceImpl resource = new ResourceImpl(){

        protected void doUnload() {
        }
    };

    protected boolean create() {
        boolean _xblockexpression = false;
        this.typesPackage = this.createBaseTypes();
        this.resource.setURI(URI.createURI((String)STATEMACHINE_TYPES));
        EList _contents = this.resource.getContents();
        _xblockexpression = _contents.add((Object)this.typesPackage);
        return _xblockexpression;
    }

    public Package getTypesPackage() {
        if (this.typesPackage == null) {
            this.create();
        }
        return this.typesPackage;
    }

    public ComplexType getEventDriven() {
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return Objects.equals(_name, EVENT_DRIVEN_NAME);
        };
        Declaration _findFirst = (Declaration)IterableExtensions.findFirst((Iterable)this.getTypesPackage().getMember(), (Functions.Function1)_function);
        return (ComplexType)_findFirst;
    }

    public ComplexType getCycleBased() {
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return Objects.equals(_name, CYCLE_BASED_NAME);
        };
        Declaration _findFirst = (Declaration)IterableExtensions.findFirst((Iterable)this.getTypesPackage().getMember(), (Functions.Function1)_function);
        return (ComplexType)_findFirst;
    }

    public ComplexType getStatemachine() {
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return Objects.equals(_name, STATEMACHINE_NAME);
        };
        Declaration _findFirst = (Declaration)IterableExtensions.findFirst((Iterable)this.getTypesPackage().getMember(), (Functions.Function1)_function);
        return (ComplexType)_findFirst;
    }

    protected Package createBaseTypes() {
        Package _createPackage = this.factory.createPackage();
        Procedures.Procedure1 _function = package_ -> {
            package_.setName("");
            ComplexType smType = this.createStatemachineType();
            EList _superTypes = this.subLib.getSubmachineInterface().getSuperTypes();
            TypeSpecifier _createTypeSpecifier = this.factory.createTypeSpecifier();
            Procedures.Procedure1 _function_1 = it -> it.setType((Type)smType);
            TypeSpecifier _doubleArrow = (TypeSpecifier)ObjectExtensions.operator_doubleArrow((Object)_createTypeSpecifier, (Procedures.Procedure1)_function_1);
            _superTypes.add((Object)_doubleArrow);
            EList _member = package_.getMember();
            _member.add((Object)smType);
            EList _member_1 = package_.getMember();
            ComplexType _createCycleBased = this.createCycleBased(smType);
            _member_1.add((Object)_createCycleBased);
            EList _member_2 = package_.getMember();
            ComplexType _createEventDriven = this.createEventDriven(smType);
            _member_2.add((Object)_createEventDriven);
        };
        return (Package)ObjectExtensions.operator_doubleArrow((Object)_createPackage, (Procedures.Procedure1)_function);
    }

    protected ComplexType createStatemachineType() {
        ComplexType _createComplexType = this.factory.createComplexType();
        Procedures.Procedure1 _function = it -> {
            it.setName(STATEMACHINE_NAME);
            EList _features = it.getFeatures();
            Operation _createOperation = this.factory.createOperation();
            Procedures.Procedure1 _function_1 = it_1 -> {
                it_1.setName("enter");
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("/**");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* Enters the state machine. Sets the state machine into a defined state.");
                _builder.newLine();
                _builder.append("*/");
                _builder.newLine();
                this.doc((EObject)it_1, _builder.toString());
                TypeSpecifier _createTypeSpecifier = this.factory.createTypeSpecifier();
                Procedures.Procedure1 _function_2 = it_2 -> it_2.setType(this.ts.getType("void"));
                TypeSpecifier _doubleArrow = (TypeSpecifier)ObjectExtensions.operator_doubleArrow((Object)_createTypeSpecifier, (Procedures.Procedure1)_function_2);
                it_1.setTypeSpecifier(_doubleArrow);
            };
            Operation _doubleArrow = (Operation)ObjectExtensions.operator_doubleArrow((Object)_createOperation, (Procedures.Procedure1)_function_1);
            _features.add((Object)_doubleArrow);
            EList _features_1 = it.getFeatures();
            Operation _createOperation_1 = this.factory.createOperation();
            Procedures.Procedure1 _function_2 = it_1 -> {
                it_1.setName("exit");
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("/**");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* Exits the state machine. Leaves the state machine with a defined state.");
                _builder.newLine();
                _builder.append("*/");
                _builder.newLine();
                this.doc((EObject)it_1, _builder.toString());
                TypeSpecifier _createTypeSpecifier = this.factory.createTypeSpecifier();
                Procedures.Procedure1 _function_3 = it_2 -> it_2.setType(this.ts.getType("void"));
                TypeSpecifier _doubleArrow_1 = (TypeSpecifier)ObjectExtensions.operator_doubleArrow((Object)_createTypeSpecifier, (Procedures.Procedure1)_function_3);
                it_1.setTypeSpecifier(_doubleArrow_1);
            };
            Operation _doubleArrow_1 = (Operation)ObjectExtensions.operator_doubleArrow((Object)_createOperation_1, (Procedures.Procedure1)_function_2);
            _features_1.add((Object)_doubleArrow_1);
            EList _features_2 = it.getFeatures();
            Operation _createOperation_2 = this.factory.createOperation();
            Procedures.Procedure1 _function_3 = it_1 -> {
                it_1.setName("isActive");
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("/**");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* Checks whether the state machine is active. <br />");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* A state machine is active if it has been entered. It is inactive if it has not been entered at all or if it has been exited.");
                _builder.newLine();
                _builder.append("*/");
                _builder.newLine();
                this.doc((EObject)it_1, _builder.toString());
                TypeSpecifier _createTypeSpecifier = this.factory.createTypeSpecifier();
                Procedures.Procedure1 _function_4 = it_2 -> it_2.setType(this.ts.getType("boolean"));
                TypeSpecifier _doubleArrow_2 = (TypeSpecifier)ObjectExtensions.operator_doubleArrow((Object)_createTypeSpecifier, (Procedures.Procedure1)_function_4);
                it_1.setTypeSpecifier(_doubleArrow_2);
            };
            Operation _doubleArrow_2 = (Operation)ObjectExtensions.operator_doubleArrow((Object)_createOperation_2, (Procedures.Procedure1)_function_3);
            _features_2.add((Object)_doubleArrow_2);
            EList _features_3 = it.getFeatures();
            Operation _createOperation_3 = this.factory.createOperation();
            Procedures.Procedure1 _function_4 = it_1 -> {
                it_1.setName("isFinal");
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("/**");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* Checks whether all active states are final. <br />");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* If there are no active states then the state machine is considered being inactive. In this case this method returns <code>false</code>.");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("*/");
                _builder.newLine();
                this.doc((EObject)it_1, _builder.toString());
                TypeSpecifier _createTypeSpecifier = this.factory.createTypeSpecifier();
                Procedures.Procedure1 _function_5 = it_2 -> it_2.setType(this.ts.getType("boolean"));
                TypeSpecifier _doubleArrow_3 = (TypeSpecifier)ObjectExtensions.operator_doubleArrow((Object)_createTypeSpecifier, (Procedures.Procedure1)_function_5);
                it_1.setTypeSpecifier(_doubleArrow_3);
            };
            Operation _doubleArrow_3 = (Operation)ObjectExtensions.operator_doubleArrow((Object)_createOperation_3, (Procedures.Procedure1)_function_4);
            _features_3.add((Object)_doubleArrow_3);
        };
        ComplexType baseType = (ComplexType)ObjectExtensions.operator_doubleArrow((Object)_createComplexType, (Procedures.Procedure1)_function);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Basic interface for state machines.");
        _builder.newLine();
        _builder.append("*/");
        _builder.newLine();
        this.doc((EObject)baseType, _builder.toString());
        return baseType;
    }

    protected ComplexType createCycleBased(ComplexType superType) {
        ComplexType _xblockexpression = null;
        ComplexType _createComplexType = this.factory.createComplexType();
        Procedures.Procedure1 _function = it -> {
            it.setName(CYCLE_BASED_NAME);
            EList _features = it.getFeatures();
            Operation _createOperation = this.factory.createOperation();
            Procedures.Procedure1 _function_1 = it_1 -> {
                it_1.setName("runCycle");
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("/**");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* Start a run-to-completion cycle.");
                _builder.newLine();
                _builder.append("*/");
                _builder.newLine();
                this.doc((EObject)it_1, _builder.toString());
                TypeSpecifier _createTypeSpecifier = this.factory.createTypeSpecifier();
                Procedures.Procedure1 _function_2 = it_2 -> it_2.setType(this.ts.getType("void"));
                TypeSpecifier _doubleArrow = (TypeSpecifier)ObjectExtensions.operator_doubleArrow((Object)_createTypeSpecifier, (Procedures.Procedure1)_function_2);
                it_1.setTypeSpecifier(_doubleArrow);
            };
            Operation _doubleArrow = (Operation)ObjectExtensions.operator_doubleArrow((Object)_createOperation, (Procedures.Procedure1)_function_1);
            _features.add((Object)_doubleArrow);
            EList _superTypes = it.getSuperTypes();
            TypeSpecifier _createTypeSpecifier = this.factory.createTypeSpecifier();
            Procedures.Procedure1 _function_2 = it_1 -> it_1.setType((Type)superType);
            TypeSpecifier _doubleArrow_1 = (TypeSpecifier)ObjectExtensions.operator_doubleArrow((Object)_createTypeSpecifier, (Procedures.Procedure1)_function_2);
            _superTypes.add((Object)_doubleArrow_1);
        };
        ComplexType cycleBased = (ComplexType)ObjectExtensions.operator_doubleArrow((Object)_createComplexType, (Procedures.Procedure1)_function);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Interface for cycle-based state machines.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        this.doc((EObject)cycleBased, _builder.toString());
        _xblockexpression = cycleBased;
        return _xblockexpression;
    }

    protected ComplexType createEventDriven(ComplexType superType) {
        ComplexType _createComplexType = this.factory.createComplexType();
        Procedures.Procedure1 _function = it -> {
            it.setName(EVENT_DRIVEN_NAME);
            EList _features = it.getFeatures();
            Operation _createOperation = this.factory.createOperation();
            Procedures.Procedure1 _function_1 = it_1 -> {
                it_1.setName(TRIGGER_WITHOUT_EVENT_NAME);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("/**");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* Performs a state machine run-to-completion step without raising any event.");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("*/");
                _builder.newLine();
                this.doc((EObject)it_1, _builder.toString());
                TypeSpecifier _createTypeSpecifier = this.factory.createTypeSpecifier();
                Procedures.Procedure1 _function_2 = it_2 -> it_2.setType(this.ts.getType("void"));
                TypeSpecifier _doubleArrow = (TypeSpecifier)ObjectExtensions.operator_doubleArrow((Object)_createTypeSpecifier, (Procedures.Procedure1)_function_2);
                it_1.setTypeSpecifier(_doubleArrow);
            };
            Operation _doubleArrow = (Operation)ObjectExtensions.operator_doubleArrow((Object)_createOperation, (Procedures.Procedure1)_function_1);
            _features.add((Object)_doubleArrow);
            EList _superTypes = it.getSuperTypes();
            TypeSpecifier _createTypeSpecifier = this.factory.createTypeSpecifier();
            Procedures.Procedure1 _function_2 = it_1 -> it_1.setType((Type)superType);
            TypeSpecifier _doubleArrow_1 = (TypeSpecifier)ObjectExtensions.operator_doubleArrow((Object)_createTypeSpecifier, (Procedures.Procedure1)_function_2);
            _superTypes.add((Object)_doubleArrow_1);
        };
        ComplexType eventDriven = (ComplexType)ObjectExtensions.operator_doubleArrow((Object)_createComplexType, (Procedures.Procedure1)_function);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Interface for event-driven state machines.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        this.doc((EObject)eventDriven, _builder.toString());
        return eventDriven;
    }

    protected boolean doc(EObject it, String documentation) {
        boolean _xifexpression = false;
        if (this.parser != null) {
            boolean _xblockexpression = false;
            StringReader _stringReader = new StringReader(documentation);
            IParseResult doc = this.parser.parse((Reader)_stringReader);
            EList _eAdapters = it.eAdapters();
            ICompositeNode _rootNode = doc.getRootNode();
            _xifexpression = _xblockexpression = _eAdapters.add((Object)((Adapter)_rootNode));
        }
        return _xifexpression;
    }
}

