/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.types.validation;

import com.yakindu.base.types.Property;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.util.SubchartDFS;
import com.yakindu.sct.model.stext.stext.VariableDefinition;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;

public class MultiStatechartValidator
implements EValidator {
    public static final String MSG_DOMAIN_DOES_NOT_MATCH = "Domain '%s' can not be imported into a statechart of domain %s.";

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (eObject instanceof Statechart) {
            Statechart sct = (Statechart)eObject;
            String parentDomain = ((Statechart)eObject).getDomainID();
            List subcharts = SubchartDFS.getSubcharts((Statechart)sct);
            for (Property element : subcharts) {
                String childDomain;
                Statechart elementChart = SubchartDFS.getStatechart((Property)((VariableDefinition)element));
                String string = childDomain = elementChart == null ? null : elementChart.getDomainID();
                if (childDomain == null || parentDomain.equals(childDomain)) continue;
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "MultiStatechartValidator", 0, String.format(MSG_DOMAIN_DOES_NOT_MATCH, childDomain, parentDomain), new Object[]{element}));
            }
        }
        return true;
    }

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }
}

