/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.internal;

import com.yakindu.licmgmt.IEclipseLicenseManager;
import com.yakindu.licmgmt.IEclipseLicenseService;
import com.yakindu.licmgmt.ILicenseManager;
import com.yakindu.licmgmt.ILicenseService;
import com.yakindu.licmgmt.LicenseException;
import com.yakindu.licmgmt.ServerSettings;
import com.yakindu.licmgmt.internal.EclipseLicenseManager;
import com.yakindu.licmgmt.internal.EclipseLicenseSettings;
import com.yakindu.licmgmt.internal.GeneralExceptionHelper;
import com.yakindu.licmgmt.internal.IEclipseLicenseSettings;
import com.yakindu.licmgmt.internal.LicenseManager;
import com.yakindu.licmgmt.internal.LicenseService;
import com.yakindu.licmgmt.internal.LoggingHelper;
import com.yakindu.licmgmt.utils.VersionHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;

public final class EclipseLicenseService
implements IEclipseLicenseService {
    private static final String INIT_LOG_MSG = "Initializing itemis eclipse license management service v%s for product %s.";
    private final Map<String, EclipseLicenseManager> registry = new HashMap<String, EclipseLicenseManager>();
    private EclipseLicenseSettings licenseSettings;

    public EclipseLicenseService() {
        if (INSTANCE != null) {
            throw new IllegalStateException("Please use IEclipseLicenseService.INSTANCE to access the license service.");
        }
        this.logInitializationInfo();
        this.licenseSettings = new EclipseLicenseSettings();
    }

    private void logInitializationInfo() {
        IProduct product = Platform.isRunning() ? Platform.getProduct() : null;
        String productName = product == null ? "<unknown>" : String.valueOf(product.getName()) + " (" + product.getId() + ")";
        LoggingHelper.info((String)String.format(INIT_LOG_MSG, VersionHelper.getLicmgmtVersion(), productName), (Object[])new Object[0]);
    }

    public IEclipseLicenseSettings getSettings() {
        return this.licenseSettings;
    }

    @Override
    public Collection<IEclipseLicenseManager> getAllEclipseLicenseManagers() {
        return Collections.unmodifiableCollection(this.registry.values());
    }

    public Collection<ILicenseManager> getAllLicenseManagers() {
        return Collections.unmodifiableCollection(this.registry.values());
    }

    @Override
    public IEclipseLicenseManager getLicenseManager(String featureId, String featureVersion) throws LicenseException {
        return this.getLicenseManager(featureId, featureVersion, Collections.emptyList());
    }

    @Override
    public IEclipseLicenseManager getLicenseManager(String featureId, String featureVersion, String additionalPath) throws LicenseException {
        return this.getLicenseManager(featureId, featureVersion, (List)Collections.singletonList(additionalPath));
    }

    @Override
    public IEclipseLicenseManager getLicenseManager(String featureId, String featureVersion, List<String> additionalPaths) throws LicenseException {
        EclipseLicenseManager manager = this.registry.get(featureId);
        if (manager == null) {
            manager = new EclipseLicenseManager(featureId, featureVersion, additionalPaths);
            this.registry.put(featureId, manager);
        } else {
            LicenseManager realLicenseManager = (LicenseManager)manager.getLicenseManager();
            if (!realLicenseManager.getFeatureVersion().equals(featureVersion)) {
                GeneralExceptionHelper.throwBasicLicenseException((String)String.format("License manager for feature '%s' already initialized for different version (%s vs %s)", featureId, featureVersion, realLicenseManager.getFeatureVersion()));
            }
            realLicenseManager.checkForUpdatedLicensePaths(additionalPaths);
        }
        return manager;
    }

    void shutdownAndRemoveLicenseManager(IEclipseLicenseManager eclipseLicenseManager) {
        LoggingHelper.debug((String)"Shutting down and removing EclipseLicenseManager for feature '%s'.", (Object[])new Object[]{eclipseLicenseManager.getFeatureId()});
        EclipseLicenseManager elm = (EclipseLicenseManager)eclipseLicenseManager;
        LicenseManager realLicenseManager = (LicenseManager)elm.getLicenseManager();
        ((LicenseService)ILicenseService.INSTANCE).shutdownAndRemoveLicenseManager((ILicenseManager)realLicenseManager);
        this.registry.remove(eclipseLicenseManager.getFeatureId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdownAllLicenseManagers() {
        LoggingHelper.debug((String)"Shutting down and removing all EclipseLicenseManagers...", (Object[])new Object[0]);
        Class<EclipseLicenseService> clazz = EclipseLicenseService.class;
        synchronized (EclipseLicenseService.class) {
            IEclipseLicenseManager[] managers = this.getAllLicenseManagers().toArray(new IEclipseLicenseManager[0]);
            int i = 0;
            while (i < managers.length) {
                this.shutdownAndRemoveLicenseManager(managers[i]);
                ++i;
            }
            this.clear();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void clear() {
        this.registry.clear();
    }

    public ServerSettings getServerSettings() {
        return ILicenseService.INSTANCE.getServerSettings();
    }

    public void setServerSettings(ServerSettings newServerSettings) {
        ILicenseService.INSTANCE.setServerSettings(newServerSettings);
    }
}

