/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.c.ui.editor;

import com.yakindu.sct.commons.EmfUriUtil;
import com.yakindu.sct.domain.common.FileLocationAdapter;
import com.yakindu.sct.ui.editor.partitioning.DiagramPartitioningUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;
import org.eclipse.xtext.ui.editor.XtextReadonlyEditorInput;

public class CFileEditorOpener
implements IURIEditorOpener {
    public static final String C_EDITOR_ID = "org.eclipse.cdt.ui.editor.CEditor";

    public IEditorPart open(URI uri, boolean select) {
        try {
            FileLocationAdapter exitingAdapter;
            Object input = null;
            input = uri.isPlatformResource() ? new FileEditorInput(EmfUriUtil.toFile((URI)uri)) : new XtextReadonlyEditorInput((IStorage)new URIStorage(uri));
            IEditorPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, C_EDITOR_ID);
            if (uri.fragment() != null && (exitingAdapter = (FileLocationAdapter)EcoreUtil.getExistingAdapter((Notifier)this.getEObject(uri), FileLocationAdapter.class)) != null && part instanceof ITextEditor) {
                ((ITextEditor)part).selectAndReveal(exitingAdapter.getOffset(), exitingAdapter.getLength());
            }
        }
        catch (InterruptedException | PartInitException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected EObject getEObject(final URI uri) throws InterruptedException {
        final TransactionalEditingDomain domain = DiagramPartitioningUtil.getSharedDomain();
        RunnableWithResult.Impl<EObject> r = new RunnableWithResult.Impl<EObject>(){

            public void run() {
                ResourceSet resourceSet = domain.getResourceSet();
                EObject eObject = resourceSet.getEObject(uri, true);
                this.setResult(eObject);
            }
        };
        domain.runExclusive((Runnable)r);
        return (EObject)r.getResult();
    }

    public IEditorPart open(URI referenceOwnerURI, EReference reference, int indexInList, boolean select) {
        return this.open(referenceOwnerURI, select);
    }

    public static class URIStorage
    implements IStorage {
        private final URI uri;
        private URIConverter converter;

        public URIStorage(URI uri) {
            this.uri = uri;
            this.converter = new ExtensibleURIConverterImpl();
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public InputStream getContents() throws CoreException {
            Map<String, URIConverter> options = Collections.singletonMap("URI_CONVERTER", this.converter);
            try {
                return this.converter.createInputStream(this.converter.normalize(this.uri), options);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        public IPath getFullPath() {
            URI normalized = this.converter.normalize(this.uri);
            String path = normalized.isRelative() ? normalized.toString() : normalized.toString();
            return new Path(path);
        }

        public String getName() {
            return URI.decode((String)this.converter.normalize(this.uri).lastSegment());
        }

        public boolean isReadOnly() {
            return true;
        }
    }
}

