/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.java.ui.simulation;

import com.google.inject.Inject;
import com.yakindu.base.expressions.expressions.ArgumentExpression;
import com.yakindu.base.expressions.expressions.Literal;
import com.yakindu.base.expressions.expressions.PrimitiveValueExpression;
import com.yakindu.base.expressions.interpreter.SlotResolutionExceptionSupplier;
import com.yakindu.base.expressions.interpreter.context.IExecutionSlotResolver;
import com.yakindu.base.expressions.util.ExpressionExtensions;
import com.yakindu.base.types.AnnotatableElement;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.Enumerator;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Parameter;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.TypesUtil;
import com.yakindu.sct.domain.java.ui.simulation.AbstractJavaExecutor;
import com.yakindu.sct.domain.java.ui.simulation.JavaObjectSlot;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sruntime.ExecutionContext;
import com.yakindu.sct.model.sruntime.ExecutionSlot;
import com.yakindu.sct.model.stext.stext.VariableDefinition;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.util.PolymorphicDispatcher;

public class InstanceOperationExecutor
extends AbstractJavaExecutor {
    @Inject
    protected IExecutionSlotResolver resolver;
    @Inject
    protected ExpressionExtensions exprExt;
    @Inject
    protected TypesUtil typesUtil;

    public boolean canExecute(ArgumentExpression expression, ExecutionContext context) {
        EObject owner = this.getOwner(expression);
        if (owner instanceof VariableDefinition && !this.ownerIsSource((VariableDefinition)owner) && (EcoreUtil2.getContainerOfType((EObject)owner, Statechart.class) != null || EcoreUtil2.getContainerOfType((EObject)owner, ExecutionFlow.class) != null)) {
            return false;
        }
        Operation operation = this.getOperation(expression);
        return !operation.isStatic() && this.getOwner(expression) instanceof Declaration;
    }

    protected boolean ownerIsSource(VariableDefinition owner) {
        return owner.getType() instanceof ComplexType && this.typesUtil.isSource_type((AnnotatableElement)owner.getType());
    }

    public Object execute(ArgumentExpression expression, ExecutionContext context) {
        return this.execute(expression, context, null);
    }

    public Object execute(ArgumentExpression expression, ExecutionContext context, List<Object> argValues) {
        Operation operation = this.getOperation(expression);
        ExecutionSlot slot = (ExecutionSlot)this.resolver.resolve(context, (Expression)expression).orElseThrow(SlotResolutionExceptionSupplier.forContext((Expression)expression));
        ExecutionSlot ownerSlot = (ExecutionSlot)slot.eContainer();
        try {
            Property property;
            Enumerator enumer;
            if (ownerSlot != null && !(ownerSlot instanceof JavaObjectSlot) && slot.getValue() != null && slot.getValue() instanceof Enumerator && !(enumer = (Enumerator)slot.getValue()).getMetaFeatures().isEmpty() && (property = (Property)enumer.getMetaFeatures().get(0)).getInitialValue() != null && property.getInitialValue() instanceof PrimitiveValueExpression && ((PrimitiveValueExpression)property.getInitialValue()).getValue() != null) {
                Literal literal = ((PrimitiveValueExpression)property.getInitialValue()).getValue();
                return this.exprExt.literalValue(literal);
            }
            if (ownerSlot != null && ownerSlot.getValue() != null) {
                PolymorphicDispatcher dispatcher = new PolymorphicDispatcher(operation.getName(), operation.getParameters().size(), operation.getParameters().size(), Collections.singletonList(ownerSlot.getValue()));
                return dispatcher.invoke(this.provideArguments(this.castIfNecessary(argValues, operation), (List)expression.getArguments(), context, operation));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected List<Object> castIfNecessary(List<Object> argValues, Operation operation) {
        Object[] arguments = argValues.toArray();
        EList params = operation.getParameters();
        Class[] argumentTypes = new Class[params.size()];
        int i = 0;
        while (i < params.size()) {
            Parameter param = (Parameter)params.get(i);
            argumentTypes[i] = this.mapParameterTypeToClass(param);
            ++i;
        }
        return Arrays.asList(this.castIfNecessary(arguments, argumentTypes));
    }

    private Class<?> mapParameterTypeToClass(Parameter param) {
        String typeName;
        switch (typeName = param.getType().getName()) {
            case "String": {
                return String.class;
            }
            case "boolean": {
                return Boolean.class;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
        }
        throw new IllegalArgumentException("Unknown type: " + typeName);
    }
}

